/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
public class TokenIndexChaosIT {
    @Inject
    private RandomSupport random;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DbmsController controller;

    @Test
    void shouldRebuildDeletedTokenIndexesOnStartup() {
        Relationship rel2;
        Relationship rel1;
        Node node3;
        Node node2;
        Node node1;
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists((GraphDatabaseService)this.db);
        RelationshipType relType = RelationshipType.withName((String)"Sample");
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode(new Label[]{Labels.First});
            node2 = tx.createNode(new Label[]{Labels.First});
            node3 = tx.createNode(new Label[]{Labels.First});
            rel1 = node1.createRelationshipTo(node2, relType);
            rel2 = node1.createRelationshipTo(node3, relType);
            tx.commit();
        }
        this.deleteRelation(rel2);
        this.deleteNode(node3);
        Path labelTokenIndexFile = this.getLabelTokenIndexFile();
        Path relationshipTypeTokenIndexFile = this.getRelationshipTypeTokenIndexFile();
        this.controller.restartDbms(builder -> {
            try {
                this.fs.deleteFile(labelTokenIndexFile);
                this.fs.deleteFile(relationshipTypeTokenIndexFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return builder;
        });
        this.awaitIndexesOnline();
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists((GraphDatabaseService)this.db);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node2}), this.getAllNodesWithLabel(Labels.First));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{rel1}), this.getRelationships(relType));
    }

    @Test
    void shouldRebuildCorruptedTokenIndexesOnStartup() {
        Relationship relation;
        Node node2;
        Node node1;
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists((GraphDatabaseService)this.db);
        RelationshipType relType = RelationshipType.withName((String)"Sample");
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode(new Label[]{Labels.First});
            node2 = tx.createNode(new Label[]{Labels.First});
            relation = node1.createRelationshipTo(node2, relType);
            tx.commit();
        }
        Path labelTokenIndexFile = this.getLabelTokenIndexFile();
        Path relationshipTypeTokenIndexFile = this.getRelationshipTypeTokenIndexFile();
        this.controller.restartDbms(builder -> {
            this.scrambleFile(labelTokenIndexFile);
            this.scrambleFile(relationshipTypeTokenIndexFile);
            return builder;
        });
        this.awaitIndexesOnline();
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists((GraphDatabaseService)this.db);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node2}), this.getAllNodesWithLabel(Labels.First));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{relation}), this.getRelationships(relType));
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction tx = this.db.beginTx();){
            Set set = Iterators.asSet((Iterator)tx.findNodes(label));
            return set;
        }
    }

    private Set<Relationship> getRelationships(RelationshipType relType) {
        try (Transaction tx = this.db.beginTx();){
            Set set = Iterators.asSet((Iterator)tx.findRelationships(relType));
            return set;
        }
    }

    private void scrambleFile(Path path) {
        TokenIndexChaosIT.scrambleFile(this.random.random(), path);
    }

    private void deleteRelation(Relationship relationship) {
        try (Transaction tx = this.db.beginTx();){
            tx.getRelationshipById(relationship.getId()).delete();
            tx.commit();
        }
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
    }

    public static void scrambleFile(Random random, Path file) {
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            byte[] bytes = new byte[(int)channel.size()];
            TokenIndexChaosIT.putRandomBytes(random, bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            channel.position(0L);
            FileUtils.writeAll((FileChannel)channel, (ByteBuffer)buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void putRandomBytes(Random random, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)random.nextInt();
        }
    }

    private void awaitIndexesOnline() {
        try (Transaction transaction = this.db.beginTx();){
            transaction.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            transaction.commit();
        }
    }

    private Path getLabelTokenIndexFile() {
        return this.getTokenIndexFile(true);
    }

    private Path getRelationshipTypeTokenIndexFile() {
        return this.getTokenIndexFile(false);
    }

    private Path getTokenIndexFile(boolean nodeIndex) {
        try (Transaction tx = this.db.beginTx();){
            Path path = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).filter(idx -> idx.getIndexType() == IndexType.LOOKUP).filter(idx -> idx.isNodeIndex() == nodeIndex).map(idx -> {
                IndexDirectoryStructure indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.db.databaseLayout().databaseDirectory()).forProvider(TokenIndexProvider.DESCRIPTOR);
                long id = ((IndexDefinitionImpl)idx).getIndexReference().getId();
                IndexFiles indexFiles = new IndexFiles(this.fs, indexDirectoryStructure, id);
                return indexFiles.getStoreFile();
            }).findAny().get();
            return path;
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

