/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.Test;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SpecialisedIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

abstract class SpecialisedIndexPopulatorCompatibility
extends SpecialisedIndexProviderCompatibilityTestSuite.Compatibility {
    SpecialisedIndexPopulatorCompatibility(SpecialisedIndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, testSuite.indexPrototype());
    }

    @Test
    void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        String failure = "The contrived failure";
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.markAsFailed(failure)), false);
        Assertions.assertThat((String)this.indexProvider.getPopulationFailure(this.descriptor, CursorContext.NULL_CONTEXT, Sets.immutable.empty())).contains(new CharSequence[]{failure});
    }

    @Test
    void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.markAsFailed(failure);
            p.close(false, CursorContext.NULL_CONTEXT);
            org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(this.descriptor, CursorContext.NULL_CONTEXT, Sets.immutable.empty()));
        }), false);
    }

    @Test
    void shouldBeAbleToDropAClosedIndexPopulator() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        IndexPopulator p = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY);
        p.close(false, CursorContext.NULL_CONTEXT);
        p.drop();
    }
}

