/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.test.RandomSupport;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class PropertyIndexPartitionedScanTestSuite<QUERY extends PartitionedScanTestSuite.Query<?>, CURSOR extends Cursor>
implements PartitionedScanTestSuite.TestSuite<QUERY, IndexReadSession, CURSOR> {
    private final TestIndexType index;

    PropertyIndexPartitionedScanTestSuite(TestIndexType index) {
        this.index = index;
    }

    protected final Iterable<IndexPrototype> createIndexPrototypes(int tokenId, int[] propKeyIds) {
        PartitionedScanFactories.PropertyIndex factory = (PartitionedScanFactories.PropertyIndex)this.getFactory();
        return Stream.concat(Arrays.stream(propKeyIds).mapToObj(propKeyId -> Pair.of((Object)factory.getSchemaDescriptor(tokenId, propKeyId), (Object)factory.getIndexName(tokenId, propKeyId))), Stream.of(Pair.of((Object)factory.getSchemaDescriptor(tokenId, propKeyIds), (Object)factory.getIndexName(tokenId, propKeyIds)))).distinct().map(indexFrom -> IndexPrototype.forSchema((SchemaDescriptor)((SchemaDescriptor)indexFrom.first())).withIndexType(this.index.type()).withIndexProvider(this.index.descriptor()).withName((String)indexFrom.other())).toList();
    }

    protected static PropertyRecord createRandomPropertyRecord(RandomSupport random, int propKeyId, int value) {
        ValueType type = (ValueType)((Object)random.among((Object[])ValueType.values()));
        return new PropertyRecord(propKeyId, type.toValue(value), type);
    }

    protected static enum TestIndexType {
        RANGE(IndexType.RANGE, RangeIndexProvider.DESCRIPTOR);

        private final IndexType type;
        private final IndexProviderDescriptor descriptor;

        private TestIndexType(IndexType type, IndexProviderDescriptor descriptor) {
            this.type = type;
            this.descriptor = descriptor;
        }

        final IndexType type() {
            return this.type;
        }

        final IndexProviderDescriptor descriptor() {
            return this.descriptor;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum ValueType {
        NUMBER{

            @Override
            protected Integer createUnderlyingValue(int value) {
                return value;
            }
        }
        ,
        NUMBER_ARRAY{

            protected Integer[] createUnderlyingValue(int value) {
                return (Integer[])this.splitNumber(value).mapToObj(NUMBER::createUnderlyingValue).map(Integer.class::cast).toArray(Integer[]::new);
            }
        }
        ,
        TEXT{

            @Override
            protected String createUnderlyingValue(int value) {
                return String.valueOf(value);
            }
        }
        ,
        TEXT_ARRAY{

            protected String[] createUnderlyingValue(int value) {
                return (String[])this.splitNumber(value).mapToObj(TEXT::createUnderlyingValue).map(String.class::cast).toArray(String[]::new);
            }
        }
        ,
        GEOMETRY{

            protected PointValue createUnderlyingValue(int value) {
                return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])this.splitNumber(value).asDoubleStream().toArray());
            }
        }
        ,
        GEOMETRY_ARRAY{

            protected PointValue[] createUnderlyingValue(int value) {
                return (PointValue[])this.splitNumber(value).mapToObj(GEOMETRY::createUnderlyingValue).map(PointValue.class::cast).toArray(PointValue[]::new);
            }
        }
        ,
        TEMPORAL{

            @Override
            protected ZonedDateTime createUnderlyingValue(int value) {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(value), ZoneOffset.UTC);
            }
        }
        ,
        TEMPORAL_ARRAY{

            protected ZonedDateTime[] createUnderlyingValue(int value) {
                return (ZonedDateTime[])this.splitNumber(value).mapToObj(TEMPORAL::createUnderlyingValue).map(ZonedDateTime.class::cast).toArray(ZonedDateTime[]::new);
            }
        }
        ,
        BOOLEAN{

            @Override
            protected Boolean createUnderlyingValue(int value) {
                return value % 2 == 0;
            }
        }
        ,
        BOOLEAN_ARRAY{

            protected Boolean[] createUnderlyingValue(int value) {
                return (Boolean[])this.splitNumber(value).mapToObj(BOOLEAN::createUnderlyingValue).map(Boolean.class::cast).toArray(Boolean[]::new);
            }
        };


        protected abstract Object createUnderlyingValue(int var1);

        protected IntStream splitNumber(int value) {
            int mask = Short.MAX_VALUE;
            int x = value & Short.MAX_VALUE;
            int y = (value & Short.MIN_VALUE) >> 16;
            return IntStream.of(x, y);
        }

        public Value toValue(int value) {
            return Values.of((Object)this.createUnderlyingValue(value));
        }
    }

    protected record PropertyRecord(int id, Value value, ValueType type) {
    }

    static abstract class WithData<QUERY extends PartitionedScanTestSuite.Query<?>, CURSOR extends Cursor>
    extends PartitionedScanTestSuite.WithData<QUERY, IndexReadSession, CURSOR> {
        protected final PartitionedScanFactories.PropertyIndex<QUERY, CURSOR> factory;

        protected abstract PartitionedScanTestSuite.Queries<QUERY> createData(int var1, int var2, int[] var3);

        WithData(PropertyIndexPartitionedScanTestSuite<QUERY, CURSOR> testSuite) {
            super(testSuite);
            this.factory = (PartitionedScanFactories.PropertyIndex)testSuite.getFactory();
        }
    }

    static abstract class WithoutData<QUERY extends PartitionedScanTestSuite.Query<?>, CURSOR extends Cursor>
    extends PartitionedScanTestSuite.WithoutData<QUERY, IndexReadSession, CURSOR> {
        protected final PartitionedScanFactories.PropertyIndex<QUERY, CURSOR> factory;

        WithoutData(PropertyIndexPartitionedScanTestSuite<QUERY, CURSOR> testSuite) {
            super(testSuite);
            this.factory = (PartitionedScanFactories.PropertyIndex)testSuite.getFactory();
        }
    }
}

