/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.TestAccessMode;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.RelationshipTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class RelationshipTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    void shouldSeeSingleRelationshipInTransaction() throws Exception {
        int label;
        long n2;
        long n1;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            long decoyNode = tx.dataWrite().nodeCreate();
            label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            tx.dataWrite().relationshipCreate(n2, label, decoyNode);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleRelationship(r, relationship);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should find relationship");
                org.junit.jupiter.api.Assertions.assertEquals((int)label, (int)relationship.type());
                org.junit.jupiter.api.Assertions.assertEquals((long)n1, (long)relationship.sourceNodeReference());
                org.junit.jupiter.api.Assertions.assertEquals((long)n2, (long)relationship.targetNodeReference());
                org.junit.jupiter.api.Assertions.assertEquals((long)r, (long)relationship.relationshipReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotSeeSingleRelationshipWhichWasDeletedInTransaction() throws Exception {
        long r;
        try (KernelTransaction tx = this.beginTransaction();){
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long decoyNode = tx.dataWrite().nodeCreate();
            tx.dataWrite().relationshipCreate(n2, label, decoyNode);
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r), (String)"should delete relationship");
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleRelationship(r, relationship);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should not find relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotSeeRelationshipsForSingleRelationshipNoId() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipScanCursor relationships = tx.cursors().allocateRelationshipScanCursor(tx.cursorContext());){
            Write write = tx.dataWrite();
            int relType = tx.tokenWrite().relationshipTypeGetOrCreateForName("REL");
            write.relationshipCreate(write.nodeCreate(), relType, write.nodeCreate());
            tx.dataRead().singleRelationship(-1L, relationships);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)relationships.next());
        }
    }

    @Test
    void shouldScanRelationshipInTransaction() throws Exception {
        int type;
        long n2;
        long n1;
        int nRelationshipsInStore = 10;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            RelationshipTransactionStateTestBase.relateNTimes(10, type, n1, n2, tx);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            long r = tx.dataWrite().relationshipCreate(n1, type, n2);
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().allRelationshipsScan(relationship);
                RelationshipTransactionStateTestBase.assertCountRelationships(relationship, 11, n1, type, n2);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotScanRelationshipWhichWasDeletedInTransaction() throws Exception {
        long r;
        int type;
        long n2;
        long n1;
        int nRelationshipsInStore = 11;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            RelationshipTransactionStateTestBase.relateNTimes(5, type, n1, n2, tx);
            r = tx.dataWrite().relationshipCreate(n1, type, n2);
            RelationshipTransactionStateTestBase.relateNTimes(5, type, n1, n2, tx);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r), (String)"should delete relationship");
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().allRelationshipsScan(relationship);
                RelationshipTransactionStateTestBase.assertCountRelationships(relationship, 10, n1, type, n2);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeRelationshipInTransaction() throws Exception {
        long n2;
        long n1;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleNode(n1, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.relationships(relationship, RelationshipSelection.ALL_RELATIONSHIPS);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should find relationship");
                org.junit.jupiter.api.Assertions.assertEquals((long)r, (long)relationship.relationshipReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotSeeRelationshipDeletedInTransaction() throws Exception {
        long r;
        long n1;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(r);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleNode(n1, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.relationships(relationship, RelationshipSelection.ALL_RELATIONSHIPS);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should not find relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeRelationshipInTransactionBeforeCursorInitialization() throws Exception {
        long n2;
        long n1;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleNode(n1, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.relationships(relationship, RelationshipSelection.ALL_RELATIONSHIPS);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should find relationship");
                org.junit.jupiter.api.Assertions.assertEquals((long)r, (long)relationship.relationshipReference());
                tx.dataWrite().relationshipCreate(n1, label, n2);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should not find relationship added after cursor init");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldTraverseSparseNode() throws Exception {
        this.traverse(RelationshipTestSupport.sparse(this.graphDb), false);
    }

    @Test
    void shouldTraverseDenseNode() throws Exception {
        this.traverse(RelationshipTestSupport.dense(this.graphDb), false);
    }

    @Test
    void shouldTraverseSparseNodeWithDetachedReferences() throws Exception {
        this.traverse(RelationshipTestSupport.sparse(this.graphDb), true);
    }

    @Test
    void shouldTraverseDenseNodeWithDetachedReferences() throws Exception {
        this.traverse(RelationshipTestSupport.dense(this.graphDb), true);
    }

    @Test
    void shouldSeeNewRelationshipPropertyInTransaction() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            String propKey1 = "prop1";
            String propKey2 = "prop2";
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            int prop1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            int prop2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            tx.dataWrite().relationshipSetProperty(r, prop1, (Value)Values.stringValue((String)"hello"));
            tx.dataWrite().relationshipSetProperty(r, prop2, (Value)Values.stringValue((String)"world"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleNode(n1, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.relationships(relationship, RelationshipSelection.ALL_RELATIONSHIPS);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should access relationship");
                relationship.properties(property);
                while (property.next()) {
                    if (property.propertyKey() == prop1) {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                        continue;
                    }
                    if (property.propertyKey() == prop2) {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                        continue;
                    }
                    org.junit.jupiter.api.Assertions.fail((String)(property.propertyKey() + " was not the property key you were looking for"));
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
    }

    @Test
    void shouldSeeAddedPropertyFromExistingRelationshipWithoutPropertiesInTransaction() throws Exception {
        long relationshipId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            tx.dataWrite().relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello"));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should access relationship");
                relationship.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should only find one properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty(propKey)).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldSeeAddedPropertyFromExistingRelationshipWithPropertiesInTransaction() throws Exception {
        RelationshipScanCursor relationship;
        int propToken1;
        long relationshipId;
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            write.relationshipSetProperty(relationshipId, propToken1, (Value)Values.stringValue((String)"hello"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int propToken2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            tx.dataWrite().relationshipSetProperty(relationshipId, propToken2, (Value)Values.stringValue((String)"world"));
            relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
            try (PropertyCursor property = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should access relationship");
                relationship.properties(property);
                while (property.next()) {
                    if (property.propertyKey() == propToken1) {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                        continue;
                    }
                    if (property.propertyKey() == propToken2) {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                        continue;
                    }
                    org.junit.jupiter.api.Assertions.fail((String)(property.propertyKey() + " was not the property you were looking for"));
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            finally {
                if (relationship != null) {
                    relationship.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            relationship = transaction.getRelationshipById(relationshipId);
            Assertions.assertThat((Object)relationship.getProperty(propKey1)).isEqualTo((Object)"hello");
            Assertions.assertThat((Object)relationship.getProperty(propKey2)).isEqualTo((Object)"world");
        }
    }

    @Test
    void shouldSeeUpdatedPropertyFromExistingRelationshipWithPropertiesInTransaction() throws Exception {
        int propToken;
        long relationshipId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            write.relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"world"));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should access relationship");
                relationship.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should only find one property");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty(propKey)).isEqualTo((Object)"world");
        }
    }

    @Test
    void shouldNotSeeRemovedPropertyInTransaction() throws Exception {
        int propToken;
        long relationshipId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            write.relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, propToken), (Object)Values.stringValue((String)"hello"));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should access relationship");
                relationship.properties(property);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should not find any properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty(propKey));
        }
    }

    @Test
    void shouldSeeRemovedThenAddedPropertyInTransaction() throws Exception {
        int propToken;
        long relationshipId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            write.relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, propToken), (Object)Values.stringValue((String)"hello"));
            tx.dataWrite().relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"world"));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"should access relationship");
                relationship.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should not find any properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"should only find one relationship");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty(propKey)).isEqualTo((Object)"world");
        }
    }

    @Test
    void shouldCountFromTxState() throws Exception {
        this.assertCount(100, RelationshipDirection.OUTGOING, degree -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degree.incomingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.totalDegree());
        });
        this.assertCount(1, RelationshipDirection.OUTGOING, degree -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degree.incomingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.totalDegree());
        });
        this.assertCount(100, RelationshipDirection.INCOMING, degree -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.incomingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.totalDegree());
        });
        this.assertCount(1, RelationshipDirection.INCOMING, degree -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.incomingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.totalDegree());
        });
        this.assertCount(100, RelationshipDirection.LOOP, degree -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.incomingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)degree.totalDegree());
        });
        this.assertCount(1, RelationshipDirection.LOOP, degree -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.outgoingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.incomingDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degree.totalDegree());
        });
    }

    @Test
    void shouldSeeNewTypes() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            long start = write.nodeCreate();
            int outgoing = tx.tokenWrite().relationshipTypeGetOrCreateForName("OUT");
            int incoming = tx.tokenWrite().relationshipTypeGetOrCreateForName("IN");
            int looping = tx.tokenWrite().relationshipTypeGetOrCreateForName("LOOP");
            long out = write.relationshipCreate(start, outgoing, write.nodeCreate());
            long in1 = write.relationshipCreate(write.nodeCreate(), incoming, start);
            long in2 = write.relationshipCreate(write.nodeCreate(), incoming, start);
            long loop = write.relationshipCreate(start, looping, start);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                Degrees degrees = node.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                for (int t : degrees.types()) {
                    if (t == outgoing) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, out);
                        RelationshipTransactionStateTestBase.assertNoRelationships(Direction.INCOMING, node, t, traversal);
                        continue;
                    }
                    if (t == incoming) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.INCOMING, node, t, traversal, in1, in2);
                        RelationshipTransactionStateTestBase.assertNoRelationships(Direction.OUTGOING, node, t, traversal);
                        continue;
                    }
                    if (t == looping) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.BOTH, node, t, traversal, loop);
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, loop);
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.INCOMING, node, t, traversal, loop);
                        continue;
                    }
                    org.junit.jupiter.api.Assertions.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
    }

    @Test
    void shouldAddToCountFromTxState() throws Exception {
        long existingRelationship;
        int type;
        long start;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("OUT");
            existingRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            long newRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                Degrees degrees = node.degrees(RelationshipSelection.selection((int)type, (Direction)Direction.BOTH));
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degrees.outgoingDegree(type));
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(type));
                RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, type, traversal, newRelationship, existingRelationship);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeBothOldAndNewRelationshipsFromSparseNode() throws Exception {
        long existingRelationship;
        int one;
        long start;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            one = tx.tokenWrite().relationshipTypeGetOrCreateForName("ONE");
            existingRelationship = write.relationshipCreate(start, one, write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            int two = tx.tokenWrite().relationshipTypeGetOrCreateForName("TWO");
            long newRelationship = write.relationshipCreate(start, two, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                Degrees degrees = node.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                for (int t : degrees.types()) {
                    if (t == one) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, existingRelationship);
                        continue;
                    }
                    if (t == two) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, newRelationship);
                        continue;
                    }
                    org.junit.jupiter.api.Assertions.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeBothOldAndNewRelationshipsFromDenseNode() throws Exception {
        int bulk;
        long existingRelationship;
        int one;
        long start;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            one = tx.tokenWrite().relationshipTypeGetOrCreateForName("ONE");
            existingRelationship = write.relationshipCreate(start, one, write.nodeCreate());
            bulk = tx.tokenWrite().relationshipTypeGetOrCreateForName("BULK");
            for (int i = 0; i < 100; ++i) {
                write.relationshipCreate(start, bulk, write.nodeCreate());
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            int two = tx.tokenWrite().relationshipTypeGetOrCreateForName("TWO");
            long newRelationship = write.relationshipCreate(start, two, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.supportsFastDegreeLookup());
                Degrees degrees = node.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                for (int t : degrees.types()) {
                    if (t == one) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, existingRelationship);
                        continue;
                    }
                    if (t == two) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, newRelationship);
                        continue;
                    }
                    if (t == bulk) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        continue;
                    }
                    org.junit.jupiter.api.Assertions.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNewRelationshipBetweenAlreadyConnectedSparseNodes() throws Exception {
        long existingRelationship;
        int type;
        long start;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            long end = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            existingRelationship = write.relationshipCreate(start, type, end);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            long newRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                Degrees degrees = node.degrees(RelationshipSelection.selection((int)type, (Direction)Direction.BOTH));
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degrees.outgoingDegree());
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree());
                RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, type, traversal, newRelationship, existingRelationship);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNewRelationshipBetweenAlreadyConnectedDenseNodes() throws Exception {
        int bulk;
        long existingRelationship;
        int type;
        long start;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            long end = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            existingRelationship = write.relationshipCreate(start, type, end);
            bulk = tx.tokenWrite().relationshipTypeGetOrCreateForName("BULK");
            for (int i = 0; i < 100; ++i) {
                write.relationshipCreate(start, bulk, write.nodeCreate());
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            long newRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.supportsFastDegreeLookup());
                Degrees degrees = node.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                for (int t : degrees.types()) {
                    if (t == type) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        RelationshipTransactionStateTestBase.assertRelationships(Direction.OUTGOING, node, t, traversal, existingRelationship, newRelationship);
                        continue;
                    }
                    if (t == bulk) {
                        org.junit.jupiter.api.Assertions.assertEquals((int)bulk, (int)t);
                        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)degrees.outgoingDegree(t));
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)degrees.incomingDegree(t));
                        continue;
                    }
                    org.junit.jupiter.api.Assertions.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCountNewRelationships() throws Exception {
        int relationship;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            relationship = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            write.relationshipCreate(write.nodeCreate(), relationship, write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            write.relationshipCreate(write.nodeCreate(), relationship, write.nodeCreate());
            long countsTxState = tx.dataRead().countsForRelationship(-1, relationship, -1);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countsTxState);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotCountRemovedRelationships() throws Exception {
        long relationship;
        int relationshipId;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            relationshipId = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), relationshipId, write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            write.relationshipDelete(relationship);
            long countsTxState = tx.dataRead().countsForRelationship(-1, relationshipId, -1);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)countsTxState);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCountNewRelationshipsRestrictedUser() throws Exception {
        int relationship;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationship = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            write.relationshipCreate(write.nodeCreate(), relationship, write.nodeCreate());
            tx.commit();
        }
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            Write write = tx.dataWrite();
            write.relationshipCreate(write.nodeCreate(), relationship, write.nodeCreate());
            long countsTxState = tx.dataRead().countsForRelationship(-1, relationship, -1);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countsTxState);
        }
    }

    @Test
    void shouldNotCountRemovedRelationshipsRestrictedUser() throws Exception {
        long relationship;
        int relationshipId;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), relationshipId, write.nodeCreate());
            tx.commit();
        }
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            Write write = tx.dataWrite();
            write.relationshipDelete(relationship);
            long countsTxState = tx.dataRead().countsForRelationship(-1, relationshipId, -1);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)countsTxState);
        }
    }

    @Test
    void shouldIncludeAddedRelationshipsByTypeAndDirection() throws Exception {
        long targetNode;
        long relationship2;
        long relationship1;
        long sourceNode;
        int typeId2;
        int typeId1;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            typeId1 = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            typeId2 = tx.tokenWrite().relationshipTypeGetOrCreateForName("R2");
            sourceNode = write.nodeCreate();
            relationship1 = write.relationshipCreate(sourceNode, typeId1, write.nodeCreate());
            relationship2 = write.relationshipCreate(sourceNode, typeId2, write.nodeCreate());
            targetNode = write.nodeCreate();
            tx.commit();
        }
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);
             NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
             RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
            Write write = tx.dataWrite();
            long r1 = write.relationshipCreate(sourceNode, typeId1, targetNode);
            long r2 = write.relationshipCreate(targetNode, typeId1, sourceNode);
            long r3 = write.relationshipCreate(sourceNode, typeId1, sourceNode);
            long r4 = write.relationshipCreate(sourceNode, typeId2, targetNode);
            long r5 = write.relationshipCreate(targetNode, typeId2, sourceNode);
            long r6 = write.relationshipCreate(sourceNode, typeId2, sourceNode);
            Read read = tx.dataRead();
            read.singleNode(sourceNode, node);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.ALL_RELATIONSHIPS, relationship1, relationship2, r1, r2, r3, r4, r5, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((Direction)Direction.OUTGOING), relationship1, relationship2, r1, r3, r4, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)typeId1, (Direction)Direction.BOTH), relationship1, r1, r2, r3);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)typeId1, (Direction)Direction.OUTGOING), relationship1, r1, r3);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)typeId1, (Direction)Direction.INCOMING), r2, r3);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)typeId2, (Direction)Direction.BOTH), relationship2, r4, r5, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)typeId2, (Direction)Direction.OUTGOING), relationship2, r4, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)typeId2, (Direction)Direction.INCOMING), r5, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int[])new int[]{typeId1, typeId2}, (Direction)Direction.BOTH), relationship1, relationship2, r1, r2, r3, r4, r5, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int[])new int[]{typeId1, typeId2}, (Direction)Direction.OUTGOING), relationship1, relationship2, r1, r3, r4, r6);
            RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int[])new int[]{typeId1, typeId2}, (Direction)Direction.INCOMING), r2, r3, r5, r6);
        }
    }

    private static void assertRelationships(Direction direction, NodeCursor node, int type, RelationshipTraversalCursor traversal, long ... relationships) {
        RelationshipTransactionStateTestBase.assertRelationships(node, traversal, RelationshipSelection.selection((int)type, (Direction)direction), relationships);
    }

    private static void assertRelationships(NodeCursor node, RelationshipTraversalCursor traversal, RelationshipSelection selection, long ... relationships) {
        node.relationships(traversal, selection);
        LongHashSet set = LongHashSet.newSetWith((long[])relationships);
        for (long relationship : relationships) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)traversal.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)set.contains(traversal.relationshipReference()));
            set.remove(traversal.relationshipReference());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)set.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)traversal.next());
    }

    private static void assertNoRelationships(Direction direction, NodeCursor node, int type, RelationshipTraversalCursor traversal) {
        node.relationships(traversal, RelationshipSelection.selection((int)type, (Direction)direction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)traversal.next());
    }

    private void traverse(RelationshipTestSupport.StartNode start, boolean detached) throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Map<String, Integer> expectedCounts = RelationshipTransactionStateTestBase.modifyStartNodeRelationships(start, tx);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleNode(start.id, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"access node");
                if (detached) {
                    tx.dataRead().relationships(start.id, node.relationshipsReference(), RelationshipSelection.ALL_RELATIONSHIPS, relationship);
                } else {
                    node.relationships(relationship, RelationshipSelection.ALL_RELATIONSHIPS);
                }
                Map<String, Integer> counts = RelationshipTestSupport.count(tx, relationship);
                RelationshipTestSupport.assertCounts(expectedCounts, counts);
            }
            tx.rollback();
        }
    }

    private static Map<String, Integer> modifyStartNodeRelationships(RelationshipTestSupport.StartNode start, KernelTransaction tx) throws KernelException {
        HashMap<String, Integer> expectedCounts = new HashMap<String, Integer>();
        for (Map.Entry<String, List<RelationshipTestSupport.StartRelationship>> kv : start.relationships.entrySet()) {
            List<RelationshipTestSupport.StartRelationship> rs = kv.getValue();
            RelationshipTestSupport.StartRelationship head = rs.get(0);
            int type = tx.token().relationshipType(head.type.name());
            switch (head.direction) {
                case INCOMING: {
                    tx.dataWrite().relationshipCreate(tx.dataWrite().nodeCreate(), type, start.id);
                    tx.dataWrite().relationshipCreate(tx.dataWrite().nodeCreate(), type, start.id);
                    break;
                }
                case OUTGOING: {
                    tx.dataWrite().relationshipCreate(start.id, type, tx.dataWrite().nodeCreate());
                    tx.dataWrite().relationshipCreate(start.id, type, tx.dataWrite().nodeCreate());
                    break;
                }
                case BOTH: {
                    tx.dataWrite().relationshipCreate(start.id, type, start.id);
                    tx.dataWrite().relationshipCreate(start.id, type, start.id);
                    break;
                }
                default: {
                    throw new IllegalStateException("Oh ye be cursed, foul checkstyle!");
                }
            }
            tx.dataWrite().relationshipDelete(head.id);
            expectedCounts.put(kv.getKey(), rs.size() + 1);
        }
        String newTypeName = "NEW";
        int newType = tx.token().relationshipTypeGetOrCreateForName(newTypeName);
        tx.dataWrite().relationshipCreate(tx.dataWrite().nodeCreate(), newType, start.id);
        tx.dataWrite().relationshipCreate(start.id, newType, tx.dataWrite().nodeCreate());
        tx.dataWrite().relationshipCreate(start.id, newType, start.id);
        expectedCounts.put(RelationshipTestSupport.computeKey(newTypeName, Direction.OUTGOING), 1);
        expectedCounts.put(RelationshipTestSupport.computeKey(newTypeName, Direction.INCOMING), 1);
        expectedCounts.put(RelationshipTestSupport.computeKey(newTypeName, Direction.BOTH), 1);
        return expectedCounts;
    }

    @Test
    void hasPropertiesShouldSeeNewlyCreatedProperties() throws Exception {
        long relationship;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
            tx.dataRead().singleRelationship(relationship, cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
            tx.dataWrite().relationshipSetProperty(relationship, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void hasPropertiesShouldSeeNewlyCreatedPropertiesOnNewlyCreatedRelationship() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleRelationship(relationship, cursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
                tx.dataWrite().relationshipSetProperty(relationship, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
            }
        }
    }

    @Test
    void hasPropertiesShouldSeeNewlyRemovedProperties() throws Exception {
        int prop3;
        int prop2;
        int prop1;
        long relationship;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            prop3 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop3");
            tx.dataWrite().relationshipSetProperty(relationship, prop1, (Value)Values.longValue((long)1L));
            tx.dataWrite().relationshipSetProperty(relationship, prop2, (Value)Values.longValue((long)2L));
            tx.dataWrite().relationshipSetProperty(relationship, prop3, (Value)Values.longValue((long)3L));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
            tx.dataRead().singleRelationship(relationship, cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
            tx.dataWrite().relationshipRemoveProperty(relationship, prop1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
            tx.dataWrite().relationshipRemoveProperty(relationship, prop2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
            tx.dataWrite().relationshipRemoveProperty(relationship, prop3);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)RelationshipTransactionStateTestBase.hasProperties(cursor, tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void propertyTypeShouldBeTxStateAware() throws Exception {
        long relationship;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipScanCursor relationships = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor properties = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            tx.dataRead().singleRelationship(relationship, relationships);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)relationships.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)RelationshipTransactionStateTestBase.hasProperties(relationships, tx));
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().relationshipSetProperty(relationship, prop, (Value)Values.stringValue((String)"foo"));
            relationships.properties(properties);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.next());
            Assertions.assertThat((Comparable)properties.propertyType()).isEqualTo((Object)ValueGroup.TEXT);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static boolean hasProperties(RelationshipScanCursor cursor, KernelTransaction tx) {
        try (PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            cursor.properties(propertyCursor);
            boolean bl = propertyCursor.next();
            return bl;
        }
    }

    private static void relateNTimes(int nRelationshipsInStore, int type, long n1, long n2, KernelTransaction tx) throws KernelException {
        for (int i = 0; i < nRelationshipsInStore; ++i) {
            tx.dataWrite().relationshipCreate(n1, type, n2);
        }
    }

    private static void assertCountRelationships(RelationshipScanCursor relationship, int expectedCount, long sourceNode, int type, long targetNode) {
        int count = 0;
        while (relationship.next()) {
            org.junit.jupiter.api.Assertions.assertEquals((long)sourceNode, (long)relationship.sourceNodeReference());
            org.junit.jupiter.api.Assertions.assertEquals((int)type, (int)relationship.type());
            org.junit.jupiter.api.Assertions.assertEquals((long)targetNode, (long)relationship.targetNodeReference());
            ++count;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedCount, (int)count);
    }

    private void assertCount(int count, RelationshipDirection direction, Consumer<Degrees> asserter) throws Exception {
        int type;
        long start;
        Write write;
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < count; ++i) {
                RelationshipTransactionStateTestBase.createRelationship(direction, start, type, write);
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = tx.dataWrite();
            RelationshipTransactionStateTestBase.createRelationship(direction, start, type, write);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next());
                Degrees degrees = node.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                asserter.accept(degrees);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void createRelationship(RelationshipDirection direction, long start, int type, Write write) throws EntityNotFoundException {
        switch (direction) {
            case OUTGOING: {
                write.relationshipCreate(start, type, write.nodeCreate());
                break;
            }
            case INCOMING: {
                write.relationshipCreate(write.nodeCreate(), type, start);
                break;
            }
            case LOOP: {
                write.relationshipCreate(start, type, start);
                break;
            }
            default: {
                throw new IllegalStateException("Checkstyle, you win again!");
            }
        }
    }
}

