/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.NodeIdReference;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.VirtualValues;

@DbmsExtension
class ExecutionContextProcedureIT {
    private static final String RUNTIME_USED = "TEST";
    @Inject
    private GraphDatabaseAPI db;

    ExecutionContextProcedureIT() {
    }

    @BeforeEach
    void beforeEach() throws KernelException {
        this.registerProcedures();
    }

    @Test
    void testProcedureAcceptingBasicType() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            List<AnyValue[]> result = this.invokeProcedure(executionContext, "range", new AnyValue[]{Values.intValue((int)0), Values.intValue((int)3)});
            this.assertColumnCount(result, 1);
            Assertions.assertThat(result.stream().map(row -> row[0])).containsExactly((Object[])new AnyValue[]{Values.intValue((int)0), Values.intValue((int)1), Values.intValue((int)2)});
        });
    }

    @ValueSource(strings={"relationshipsWithCompilation", "relationshipsWithoutCompilation"})
    @ParameterizedTest
    void testProcedureAcceptingNodeAndProducingRelationships(String method) throws ProcedureException {
        NodeIdReference nodeReference;
        ArrayList<RelationshipReference> relReferences = new ArrayList<RelationshipReference>();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeReference = VirtualValues.node((long)node.getId());
            relReferences.add(VirtualValues.relationship((long)node.createRelationshipTo(node, RelationshipType.withName((String)"T1")).getId()));
            relReferences.add(VirtualValues.relationship((long)node.createRelationshipTo(node, RelationshipType.withName((String)"T2")).getId()));
            relReferences.add(VirtualValues.relationship((long)node.createRelationshipTo(node, RelationshipType.withName((String)"T3")).getId()));
            tx.commit();
        }
        this.doWithExecutionContext(executionContext -> {
            List<AnyValue[]> result = this.invokeProcedure(executionContext, method, new AnyValue[]{nodeReference});
            this.assertColumnCount(result, 1);
            Assertions.assertThat(result.stream().map(row -> row[0])).containsExactlyInAnyOrderElementsOf((Iterable)relReferences);
        });
    }

    @ValueSource(strings={"nodesWithCompilation", "nodesWithoutCompilation"})
    @ParameterizedTest
    void testProcedureAcceptingRelationshipAndProducingNodes(String method) throws ProcedureException {
        RelationshipReference relReference;
        NodeIdReference endNodeReference;
        NodeIdReference startNodeReference;
        try (Transaction tx = this.db.beginTx();){
            Node startNode = tx.createNode();
            startNodeReference = VirtualValues.node((long)startNode.getId());
            Node endNode = tx.createNode();
            endNodeReference = VirtualValues.node((long)endNode.getId());
            relReference = VirtualValues.relationship((long)startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"T1")).getId());
            tx.commit();
        }
        this.doWithExecutionContext(executionContext -> {
            List<AnyValue[]> result = this.invokeProcedure(executionContext, method, new AnyValue[]{relReference});
            this.assertColumnCount(result, 1);
            Assertions.assertThat(result.stream().map(row -> row[0])).containsExactly((Object[])new AnyValue[]{startNodeReference, endNodeReference});
        });
    }

    @ValueSource(strings={"passThrough", "passThroughPath"})
    @ParameterizedTest
    void testProcedureAcceptingPathAndProducingPath(String method) throws ProcedureException {
        long[] nodeIds = new long[3];
        long[] relIds = new long[2];
        try (Transaction tx = this.db.beginTx();){
            Node node1 = tx.createNode();
            nodeIds[0] = node1.getId();
            Node node2 = tx.createNode();
            nodeIds[1] = node2.getId();
            Node node3 = tx.createNode();
            nodeIds[2] = node3.getId();
            relIds[0] = node1.createRelationshipTo(node2, RelationshipType.withName((String)"T1")).getId();
            relIds[1] = node2.createRelationshipTo(node3, RelationshipType.withName((String)"T1")).getId();
            tx.commit();
        }
        PathReference path = VirtualValues.pathReference((long[])nodeIds, (long[])relIds);
        this.doWithExecutionContext(executionContext -> {
            AnyValue result = this.invokeSimpleProcedure(executionContext, method, new AnyValue[]{path});
            Assertions.assertThat((Object)result).isInstanceOf(PathReference.class);
            PathReference resultPath = (PathReference)result;
            Assertions.assertThat((long[])resultPath.nodeIds()).containsExactly(nodeIds);
            Assertions.assertThat((long[])resultPath.relationshipIds()).containsExactly(relIds);
        });
    }

    @Test
    void procedureShouldNotWrapExecutionContextNodes() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            AnyValue result = this.invokeSimpleProcedure(executionContext, "passThrough", new AnyValue[]{VirtualValues.node((long)123L)});
            Assertions.assertThat((Object)result).isNotInstanceOf(NodeEntityWrappingNodeValue.class);
        });
    }

    @Test
    void procedureShouldNotWrapExecutionContextRelationships() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            AnyValue result = this.invokeSimpleProcedure(executionContext, "passThrough", new AnyValue[]{VirtualValues.relationship((long)123L)});
            Assertions.assertThat((Object)result).isNotInstanceOf(RelationshipEntityWrappingValue.class);
        });
    }

    @Test
    void procedureShouldNotHandleWrappedNodesAsReferences() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            Node originalWrappedNode = (Node)Mockito.mock(Node.class);
            AnyValue result = this.invokeSimpleProcedure(executionContext, "passThrough", new AnyValue[]{ValueUtils.wrapNodeEntity((Node)originalWrappedNode)});
            Assertions.assertThat((Object)result).isInstanceOf(NodeEntityWrappingNodeValue.class);
            Node unwrappedNode = ((NodeEntityWrappingNodeValue)result).getEntity();
            Assertions.assertThat((Object)unwrappedNode).isEqualTo((Object)originalWrappedNode);
        });
    }

    @Test
    void procedureShouldNotHandleWrappedRelationshipsAsReferences() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            Relationship originalWrappedRelationship = (Relationship)Mockito.mock(Relationship.class);
            AnyValue result = this.invokeSimpleProcedure(executionContext, "passThrough", new AnyValue[]{ValueUtils.wrapRelationshipEntity((Relationship)originalWrappedRelationship)});
            Assertions.assertThat((Object)result).isInstanceOf(RelationshipEntityWrappingValue.class);
            Relationship unwrappedRelationship = ((RelationshipEntityWrappingValue)result).getEntity();
            Assertions.assertThat((Object)unwrappedRelationship).isEqualTo((Object)originalWrappedRelationship);
        });
    }

    @Test
    void procedureShouldNotHandleWrappedPathsAsReferences() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            Path originalWrappedPath = (Path)Mockito.mock(Path.class);
            AnyValue result = this.invokeSimpleProcedure(executionContext, "passThrough", new AnyValue[]{ValueUtils.wrapPath((Path)originalWrappedPath)});
            Assertions.assertThat((Object)result).isInstanceOf(PathWrappingPathValue.class);
            Path unwrappedPath = ((PathWrappingPathValue)result).path();
            Assertions.assertThat((Iterable)unwrappedPath).isEqualTo((Object)originalWrappedPath);
        });
    }

    @Test
    void testProcedureUsingUnsupportedNodeOperation() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> Assertions.assertThatThrownBy(() -> this.invokeProcedure(executionContext, "deleteEntity", new AnyValue[]{VirtualValues.node((long)123L)})).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasMessageContaining("Operation unsupported during parallel query execution"));
    }

    @Test
    void testProcedureUsingUnsupportedRelationshipOperation() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> Assertions.assertThatThrownBy(() -> this.invokeProcedure(executionContext, "deleteEntity", new AnyValue[]{VirtualValues.relationship((long)123L)})).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasMessageContaining("Operation unsupported during parallel query execution"));
    }

    @Test
    void testInjectingTransactionIntoProcedureAndGettingDataFromIt() throws ProcedureException {
        NodeIdReference node2;
        NodeIdReference node1;
        try (Transaction tx = this.db.beginTx();){
            node1 = VirtualValues.node((long)tx.createNode().getId());
            node2 = VirtualValues.node((long)tx.createNode().getId());
            tx.commit();
        }
        this.doWithExecutionContext(executionContext -> {
            List<AnyValue[]> result = this.invokeProcedure(executionContext, "getAllNodesFromTransaction", new AnyValue[0]);
            this.assertColumnCount(result, 1);
            Assertions.assertThat(result.stream().map(row -> row[0])).containsExactly((Object[])new AnyValue[]{node1, node2});
        });
    }

    @Test
    void testKernelTransactionInjectionIntoProcedure() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> Assertions.assertThatThrownBy(() -> this.invokeProcedure(executionContext, "doSomethingWithKernelTransaction", new AnyValue[0])).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasMessageContaining("`transaction.createExecutionContext' is not supported in procedures when called from parallel runtime. Please retry using another runtime."));
    }

    @Test
    void testGraphDatabaseServiceInjectionIntoProcedure() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            AnyValue result = this.invokeSimpleProcedure(executionContext, "databaseName", new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.stringValue((String)this.db.databaseName()));
        });
    }

    @Test
    void testProcedureSecurityContext() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            AccessMode originalAccessMode = executionContext.securityContext().mode();
            Assertions.assertThat((Object)originalAccessMode).isEqualTo((Object)AccessMode.Static.FULL);
            AnyValue result = this.invokeSimpleProcedure(executionContext, "accessMode", new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.stringValue((String)new OverriddenAccessMode(originalAccessMode, AccessMode.Static.READ).name()));
            Assertions.assertThat((Object)executionContext.securityContext().mode()).isEqualTo((Object)AccessMode.Static.FULL);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void closedTransactionShouldBeDetectedOnProcedureInvocation() throws ProcedureException {
        try (Transaction transaction = this.db.beginTx();
             Statement statement = this.acquireStatement(transaction);
             ExecutionContext executionContext = this.createExecutionContext(transaction);){
            try {
                ProcedureHandle handle = executionContext.procedures().procedureGet(this.getName("range"), CypherScope.CYPHER_5);
                transaction.rollback();
                ProcedureCallContext procContext = new ProcedureCallContext(handle.id(), ArrayUtils.EMPTY_STRING_ARRAY, false, "", false, RUNTIME_USED);
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executionContext.procedures().procedureCallRead(handle.id(), (AnyValue[])new Value[]{Values.intValue((int)0), Values.intValue((int)2)}, procContext)).isInstanceOf(NotInTransactionException.class)).hasMessageContaining("This transaction has already been closed.");
            }
            finally {
                executionContext.complete();
            }
        }
    }

    @Test
    void testProcedureWithWriteAccessMode() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            ProcedureHandle handle = executionContext.procedures().procedureGet(this.getName("range"), CypherScope.CYPHER_5);
            ProcedureCallContext procContext = new ProcedureCallContext(handle.id(), ArrayUtils.EMPTY_STRING_ARRAY, false, "", false, RUNTIME_USED);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executionContext.procedures().procedureCallWrite(handle.id(), (AnyValue[])new Value[]{Values.intValue((int)0), Values.intValue((int)2)}, procContext)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Invoking procedure with WRITE access mode is not allowed during parallel execution.");
        });
    }

    @Test
    void testProcedureWithSchemaAccessMode() throws ProcedureException {
        this.doWithExecutionContext(executionContext -> {
            ProcedureHandle handle = executionContext.procedures().procedureGet(this.getName("range"), CypherScope.CYPHER_5);
            ProcedureCallContext procContext = new ProcedureCallContext(handle.id(), ArrayUtils.EMPTY_STRING_ARRAY, false, "", false, RUNTIME_USED);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executionContext.procedures().procedureCallSchema(handle.id(), (AnyValue[])new Value[]{Values.intValue((int)0), Values.intValue((int)2)}, procContext)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Invoking procedure with SCHEMA access mode is not allowed during parallel execution.");
        });
    }

    private void assertColumnCount(List<AnyValue[]> result, int count) {
        result.forEach(row -> Assertions.assertThat((int)((AnyValue[])row).length).isEqualTo(count));
    }

    private void registerProcedures() throws KernelException {
        GlobalProcedures globalProcedures = (GlobalProcedures)this.db.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        globalProcedures.registerProcedure(BasicTestProcedures.class);
        globalProcedures.registerProcedure(ProcedureInjectingTransaction.class);
        globalProcedures.registerProcedure(ProcedureInjectingKernelTransaction.class);
        globalProcedures.registerProcedure(ProcedureInjectingDatabase.class);
        globalProcedures.registerProcedure(ProcedureInjectingSecurityContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWithExecutionContext(ExecutionContextLogic executionContextLogic) throws ProcedureException {
        try (Transaction transaction = this.db.beginTx();
             Statement statement = this.acquireStatement(transaction);
             ExecutionContext executionContext = this.createExecutionContext(transaction);){
            try {
                executionContextLogic.doWithExecutionContext(executionContext);
            }
            finally {
                executionContext.complete();
            }
        }
    }

    private ExecutionContext createExecutionContext(Transaction transaction) {
        return ((InternalTransaction)transaction).kernelTransaction().createExecutionContext();
    }

    private Statement acquireStatement(Transaction transaction) {
        return ((InternalTransaction)transaction).kernelTransaction().acquireStatement();
    }

    private List<AnyValue[]> invokeProcedure(ExecutionContext executionContext, String name, AnyValue ... args) throws ProcedureException {
        ProcedureHandle handle = executionContext.procedures().procedureGet(this.getName(name), CypherScope.CYPHER_5);
        ProcedureCallContext procContext = new ProcedureCallContext(handle.id(), ArrayUtils.EMPTY_STRING_ARRAY, false, "", false, RUNTIME_USED);
        RawIterator iterator = executionContext.procedures().procedureCallRead(handle.id(), args, procContext);
        ArrayList<AnyValue[]> result = new ArrayList<AnyValue[]>();
        while (iterator.hasNext()) {
            result.add((AnyValue[])iterator.next());
        }
        return result;
    }

    private AnyValue invokeSimpleProcedure(ExecutionContext executionContext, String name, AnyValue ... args) throws ProcedureException {
        return this.invokeProcedure(executionContext, name, args).stream().map(row -> row[0]).findFirst().get();
    }

    private QualifiedName getName(String name) {
        return new QualifiedName("execution", "context", "test", "procedure", name);
    }

    private static interface ExecutionContextLogic {
        public void doWithExecutionContext(ExecutionContext var1) throws ProcedureException;
    }

    public static class BasicTestProcedures {
        @Procedure(value="execution.context.test.procedure.range")
        public Stream<GenericResult> range(@Name(value="from") long from, @Name(value="to") long to) {
            return LongStream.range(from, to).mapToObj(GenericResult::new);
        }

        @Procedure(value="execution.context.test.procedure.relationshipsWithCompilation")
        public Stream<RelationshipResult> relationshipsWithCompilation(@Name(value="node") Node node) {
            return node.getRelationships().stream().map(RelationshipResult::new);
        }

        @Procedure(value="execution.context.test.procedure.relationshipsWithoutCompilation")
        public Stream<GenericResult> relationshipsWithoutCompilation(@Name(value="node") Object o) {
            if (o instanceof Node) {
                Node node = (Node)o;
                return node.getRelationships().stream().map(GenericResult::new);
            }
            throw new IllegalStateException("Procedures accepts only one Node instance");
        }

        @Procedure(value="execution.context.test.procedure.nodesWithCompilation")
        public Stream<NodeResult> nodesWithCompilation(@Name(value="relationship") Relationship relationship) {
            return Stream.of(relationship.getStartNode(), relationship.getEndNode()).map(NodeResult::new);
        }

        @Procedure(value="execution.context.test.procedure.nodesWithoutCompilation")
        public Stream<GenericResult> nodesWithoutCompilation(@Name(value="relationship") Object o) {
            if (o instanceof Relationship) {
                Relationship relationship = (Relationship)o;
                return Stream.of(relationship.getStartNode(), relationship.getEndNode()).map(GenericResult::new);
            }
            throw new IllegalStateException("Procedures accepts only one Relationship instance");
        }

        @Procedure(value="execution.context.test.procedure.passThrough")
        public Stream<GenericResult> passThrough(@Name(value="Object") Object o) {
            return Stream.of(o).map(GenericResult::new);
        }

        @Procedure(value="execution.context.test.procedure.passThroughPath")
        public Stream<PathResult> passThroughPath(@Name(value="Object") Path path) {
            return Stream.of(path).map(PathResult::new);
        }

        @Procedure(value="execution.context.test.procedure.deleteEntity")
        public void deleteEntity(@Name(value="entity") Object o) {
            if (!(o instanceof Entity)) {
                throw new IllegalStateException("Procedures accepts only one Entity instance");
            }
            Entity entity = (Entity)o;
            entity.delete();
        }

        public record PathResult(Path path) {
        }

        public record RelationshipResult(Relationship relationship) {
        }
    }

    public static class ProcedureInjectingTransaction {
        @Context
        public Transaction transaction;

        @Procedure(value="execution.context.test.procedure.getAllNodesFromTransaction")
        public Stream<NodeResult> getAllNodesFromTransaction() {
            return this.transaction.getAllNodes().stream().map(NodeResult::new);
        }
    }

    public static class ProcedureInjectingKernelTransaction {
        @Context
        public KernelTransaction kernelTransaction;

        @NotThreadSafe
        @Procedure(value="execution.context.test.procedure.doSomethingWithKernelTransaction")
        public void doSomethingWithKernelTransaction() {
            this.kernelTransaction.createExecutionContext();
        }
    }

    public static class ProcedureInjectingDatabase {
        @Context
        public GraphDatabaseService db;

        @Procedure(value="execution.context.test.procedure.databaseName")
        public Stream<GenericResult> databaseName() {
            return Stream.of(this.db.databaseName()).map(GenericResult::new);
        }
    }

    public static class ProcedureInjectingSecurityContext {
        @Context
        public SecurityContext securityContext;

        @Procedure(value="execution.context.test.procedure.accessMode")
        public Stream<GenericResult> accessMode() {
            return Stream.of(this.securityContext.mode().name()).map(GenericResult::new);
        }
    }

    public record NodeResult(Node node) {
    }

    public record GenericResult(Object object) {
    }
}

