/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogFileRotationIT {
    static final long CONFIG_ROTATION_THRESHOLD = ByteUnit.kibiBytes((long)1L);
    static final long ACTUAL_ROTATION_THRESHOLD = (long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2L;
    static final String CHECKPOINT_REASON = "checkpoint for rotation test";
    static final LogPosition LOG_POSITION = new LogPosition(1000L, 12345L);
    static final TransactionId TRANSACTION_ID = new TransactionId(100L, 101L, LatestVersions.LATEST_KERNEL_VERSION, 101, 102L, 103L);
    @Inject
    LogFiles logFiles;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)CONFIG_ROTATION_THRESHOLD).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)100).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)this.preallocateLogs());
    }

    @Test
    void rotateCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        CheckpointLogFileRotationIT.fillWithCheckpoints(5, checkpointAppender);
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(6);
        for (Object fileWithCheckpoints : matchedFiles) {
            Assertions.assertThat((Path)fileWithCheckpoints).satisfies((Condition)new Condition<Path>(){

                public boolean matches(Path file) {
                    long length = file.toFile().length();
                    return length < ACTUAL_ROTATION_THRESHOLD + 232L;
                }
            });
        }
    }

    @Test
    void doNotRotateWhileCheckpointsAreFitting() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        int i = LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + 464;
        while ((long)i < ACTUAL_ROTATION_THRESHOLD) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, TRANSACTION_ID, TRANSACTION_ID.id() + 10L, LatestVersions.LATEST_KERNEL_VERSION, LOG_POSITION, Instant.now(), CHECKPOINT_REASON);
            i += 232;
        }
        Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(1);
    }

    @Test
    void afterRotationNewFileHaveHeader() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        CheckpointLogFileRotationIT.fillWithCheckpoints(1, checkpointAppender);
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        boolean headerFileFound = false;
        for (Object matchedFile : matchedFiles) {
            if (checkpointFile.getDetachedCheckpointLogFileVersion((Path)matchedFile) != 1L) continue;
            Assertions.assertThat((File)matchedFile.toFile()).hasSize(this.expectedNewFileSize());
            headerFileFound = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)headerFileFound);
    }

    private static void fillWithCheckpoints(int files, CheckpointAppender appender) throws IOException {
        for (int fileCount = 0; fileCount < files; ++fileCount) {
            int startOffset;
            int i = startOffset = LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + (fileCount == 0 ? 232 : 0);
            while ((long)i < ACTUAL_ROTATION_THRESHOLD) {
                appender.checkPoint(LogCheckPointEvent.NULL, TRANSACTION_ID, TRANSACTION_ID.id() + 77L, LatestVersions.LATEST_KERNEL_VERSION, LOG_POSITION, Instant.now(), CHECKPOINT_REASON);
                i += 232;
            }
        }
    }

    protected long expectedNewFileSize() {
        return LatestVersions.LATEST_LOG_FORMAT.getHeaderSize();
    }

    protected boolean preallocateLogs() {
        return false;
    }
}

