/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointLogFileRotationIT;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;

@EnabledOnOs(value={OS.LINUX})
class PreallocatedCheckpointLogFileRotationIT
extends CheckpointLogFileRotationIT {
    PreallocatedCheckpointLogFileRotationIT() {
    }

    @Override
    protected boolean preallocateLogs() {
        return true;
    }

    @Override
    protected long expectedNewFileSize() {
        return ACTUAL_ROTATION_THRESHOLD;
    }

    @Test
    void writeCheckpointsIntoPreallocatedFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101L, LatestVersions.LATEST_KERNEL_VERSION, 101, 102L, 103L);
        String reason = "checkpoints in preallocated file";
        for (int i = 0; i < 2; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, transactionId.id() + 7L, LatestVersions.LATEST_KERNEL_VERSION, logPosition, Instant.now(), reason);
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(1);
    }

    @Test
    void writeCheckpointsIntoSeveralPreallocatedFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101L, LatestVersions.LATEST_KERNEL_VERSION, 101, 102L, 103L);
        String reason = "checkpoint in preallocated file";
        checkpointFile.rotate();
        for (int fileCount = 2; fileCount < 6; ++fileCount) {
            int i = LatestVersions.LATEST_LOG_FORMAT.getHeaderSize();
            while ((long)i < ACTUAL_ROTATION_THRESHOLD) {
                ((ObjectArrayAssert)Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(fileCount)).allMatch(this::sizeEqualsToPreallocatedFile);
                checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, transactionId.id() + 7L, LatestVersions.LATEST_KERNEL_VERSION, logPosition, Instant.now(), reason);
                i += 232;
            }
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(6)).allMatch(this::sizeEqualsToPreallocatedFile);
    }

    private boolean sizeEqualsToPreallocatedFile(Path path) {
        try {
            return Files.size(path) < ACTUAL_ROTATION_THRESHOLD + 232L;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

