/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cloud.storage.StorageUtils;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.SimpleAppendIndexProvider;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@PageCacheExtension
@Neo4jLayoutExtension
public class LogTailAppendIndexIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private Neo4jLayout neo4jLayout;
    private DatabaseManagementService dbms;

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
            this.dbms = null;
        }
    }

    @Test
    void emptyLogsLastBatch() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        DatabaseLayout layout = (DatabaseLayout)db.getDependencyResolver().resolveDependency(DatabaseLayout.class);
        this.dbms.shutdown();
        this.fileSystem.delete(layout.getTransactionLogsDirectory());
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        AppendBatchInfo lastBatch = logFiles.getTailMetadata().lastBatch();
        Assertions.assertEquals((long)1L, (long)lastBatch.appendIndex());
        Assertions.assertEquals((Object)new LogPosition(0L, 64L), (Object)lastBatch.logPositionAfter());
    }

    @Test
    void logLastBatchNoCheckpoints() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        for (int i = 0; i < 10; ++i) {
            LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        AppendBatchInfo lastBatchBeforeRestart = ((TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class)).lastBatch();
        DatabaseLayout layout = (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class);
        LogFiles originalLogFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        Path[] checkpointFiles = originalLogFiles.getCheckpointFile().getDetachedCheckpointFiles();
        this.dbms.shutdown();
        for (Path checkpointFile : checkpointFiles) {
            this.fileSystem.delete(checkpointFile);
        }
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        Assertions.assertEquals((Object)lastBatchBeforeRestart, (Object)logFiles.getTailMetadata().lastBatch());
    }

    @Test
    void logLastBatchNoCheckpointsSeveralFiles() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        LogFiles originalLogFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 10; ++i) {
                LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
            }
            originalLogFiles.getLogFile().rotate();
        }
        AppendBatchInfo lastBatchBeforeRestart = ((TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class)).lastBatch();
        DatabaseLayout layout = (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class);
        Path[] checkpointFiles = originalLogFiles.getCheckpointFile().getDetachedCheckpointFiles();
        this.dbms.shutdown();
        for (Path checkpointFile : checkpointFiles) {
            this.fileSystem.delete(checkpointFile);
        }
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        Assertions.assertEquals((Object)lastBatchBeforeRestart, (Object)logFiles.getTailMetadata().lastBatch());
    }

    @Test
    void logLastBatchWithCheckpointInTheEnd() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        for (int i = 0; i < 10; ++i) {
            LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        AppendBatchInfo lastBatchBeforeRestart = ((TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class)).lastBatch();
        DatabaseLayout layout = (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class);
        this.dbms.shutdown();
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        Assertions.assertEquals((Object)lastBatchBeforeRestart, (Object)logFiles.getTailMetadata().lastBatch());
    }

    @Test
    void logLastBatchWithSeveralFilesAndCheckpointInTheEnd() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        LogFiles originalLogFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 10; ++i) {
                LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
            }
            originalLogFiles.getLogFile().rotate();
        }
        AppendBatchInfo lastBatchBeforeRestart = ((TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class)).lastBatch();
        DatabaseLayout layout = (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class);
        this.dbms.shutdown();
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        Assertions.assertEquals((Object)lastBatchBeforeRestart, (Object)logFiles.getTailMetadata().lastBatch());
    }

    @Test
    void logLastBatchWithCheckpointAndRecordsAfterTheCheckpoint() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 10; ++i) {
                LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
            }
            ((CheckPointer)dependencyResolver.resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test"));
        }
        for (int i = 0; i < 10; ++i) {
            LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        AppendBatchInfo lastBatchBeforeRestart = ((TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class)).lastBatch();
        DatabaseLayout layout = (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class);
        this.dbms.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        Assertions.assertEquals((Object)lastBatchBeforeRestart, (Object)logFiles.getTailMetadata().lastBatch());
    }

    @Test
    void logLastBatchNoCheckpointsSeveralFilesAndCorruptionInFiles() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        LogFiles originalLogFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        AppendBatchInfo lastBatchBeforeRestart = null;
        Path fileToManipulate = null;
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 10; ++i) {
                LogTailAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
            }
            if (j == 5) {
                lastBatchBeforeRestart = ((TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class)).lastBatch();
                fileToManipulate = originalLogFiles.getLogFile().getLogFileForVersion(lastBatchBeforeRestart.logPositionAfter().getLogVersion());
                continue;
            }
            originalLogFiles.getLogFile().rotate();
        }
        DatabaseLayout layout = (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class);
        Path[] checkpointFiles = originalLogFiles.getCheckpointFile().getDetachedCheckpointFiles();
        this.dbms.shutdown();
        for (Path checkpointFile : checkpointFiles) {
            this.fileSystem.delete(checkpointFile);
        }
        try (StoreFileChannel channel = this.fileSystem.open(fileToManipulate, StorageUtils.WRITE_OPTIONS);){
            channel.position(lastBatchBeforeRestart.logPositionAfter().getByteOffset()).writeAll(ByteBuffer.wrap(new byte[1024]));
        }
        LogFiles logFiles = this.buildDefaultLogFiles(layout);
        Assertions.assertEquals((Object)lastBatchBeforeRestart, (Object)logFiles.getTailMetadata().lastBatch());
    }

    private static void createNodesWithRelationship(GraphDatabaseService db, RelationshipType marker) {
        try (Transaction transaction = db.beginTx();){
            Node start = transaction.createNode();
            Node end = transaction.createNode();
            start.createRelationshipTo(end, marker);
            transaction.commit();
        }
    }

    private DatabaseManagementService buildDbms() {
        return new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false).build();
    }

    private LogFiles buildDefaultLogFiles(DatabaseLayout databaseLayout) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withAppendIndexProvider((AppendIndexProvider)new SimpleAppendIndexProvider()).withStorageEngineFactory(StorageEngineFactory.selectStorageEngine((Configuration)Config.defaults())).build();
    }
}

