/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.index.IndexProviderCompatabilityTestBase;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

abstract class IndexConfigurationCompletionCompatibility
extends IndexProviderCompatabilityTestBase {
    IndexConfigurationCompletionCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, testSuite.indexPrototype());
    }

    @Test
    void configurationCompletionMustNotOverwriteExistingConfiguration() {
        IndexDescriptor index = this.descriptor;
        index = index.withIndexConfig(IndexConfig.with((String)"Bob", (Value)Values.stringValue((String)"Howard")));
        index = this.indexProvider.completeConfiguration(index, this.storageEngineIndexingBehaviour);
        org.junit.jupiter.api.Assertions.assertEquals((Object)index.getIndexConfig().get("Bob"), (Object)Values.stringValue((String)"Howard"));
    }

    @Test
    void configurationCompletionMustBeIdempotent() {
        IndexDescriptor index = this.descriptor;
        IndexDescriptor onceCompleted = this.indexProvider.completeConfiguration(index, this.storageEngineIndexingBehaviour);
        IndexDescriptor twiceCompleted = this.indexProvider.completeConfiguration(onceCompleted, this.storageEngineIndexingBehaviour);
        org.junit.jupiter.api.Assertions.assertEquals((Object)onceCompleted.getIndexConfig(), (Object)twiceCompleted.getIndexConfig());
    }

    @Test
    void mustAssignCapabilitiesToDescriptorsThatHaveNone() {
        IndexDescriptor index = this.descriptor;
        IndexDescriptor completed = this.indexProvider.completeConfiguration(index, this.storageEngineIndexingBehaviour);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)completed.getCapability(), (Object)IndexCapability.NO_CAPABILITY);
        completed = completed.withIndexCapability(IndexCapability.NO_CAPABILITY);
        completed = this.indexProvider.completeConfiguration(completed, this.storageEngineIndexingBehaviour);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)completed.getCapability(), (Object)IndexCapability.NO_CAPABILITY);
    }

    @Test
    void mustNotOverwriteExistingCapabilities() {
        IndexCapability capability = new IndexCapability(){

            public boolean supportsOrdering() {
                return false;
            }

            public boolean supportsReturningValues() {
                return false;
            }

            public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
                Preconditions.requireNonEmpty((Object[])valueCategories);
                Preconditions.requireNoNullElements((Object[])valueCategories);
                return true;
            }

            public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
                return true;
            }

            public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
                return 1.0;
            }

            public boolean supportPartitionedScan(IndexQuery ... queries) {
                Preconditions.requireNonEmpty((Object[])queries);
                Preconditions.requireNoNullElements((Object[])queries);
                return false;
            }
        };
        IndexDescriptor index = this.descriptor.withIndexCapability(capability);
        IndexDescriptor completed = this.indexProvider.completeConfiguration(index, this.storageEngineIndexingBehaviour);
        org.junit.jupiter.api.Assertions.assertSame((Object)capability, (Object)completed.getCapability());
    }

    @Test
    void indexProviderMustReturnCorrectIndexType() {
        Assertions.assertThat((Comparable)this.indexProvider.getIndexType()).isEqualTo((Object)this.testSuite.indexType());
    }
}

