/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.index.BaseTestingIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
public class IndexPopulationMissConcurrentUpdateIT {
    private static final String NAME_PROPERTY = "name";
    private static final long INITIAL_CREATION_NODE_ID_THRESHOLD = 30L;
    private static final long SCAN_BARRIER_NODE_ID_THRESHOLD = 10L;
    private final ControlledSchemaIndexProvider index = new ControlledSchemaIndexProvider();
    @Inject
    private GraphDatabaseService db;
    @Inject
    private IdController idController;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.noOpSystemGraphInitializer().addExtension((ExtensionFactory)this.index);
        builder.setConfig(GraphDatabaseInternalSettings.index_population_queue_threshold, (Object)1);
    }

    @Test
    public void shouldNoticeConcurrentUpdatesWithinCurrentLabelIndexEntryRange() throws Exception {
        Node node;
        ArrayList<Node> nodes = new ArrayList<Node>();
        int nextId = 0;
        try (Transaction tx = this.db.beginTx();){
            do {
                node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                node.setProperty(NAME_PROPERTY, (Object)("Node " + nextId++));
                nodes.add(node);
            } while (node.getId() < 30L);
            tx.commit();
        }
        ((AbstractLongAssert)Assertions.assertThat((long)Iterables.count((Iterable)Iterables.filter(n -> n.getId() <= 10L, nodes))).as("At least one node below the scan barrier threshold must have been created, otherwise test assumptions are invalid or outdated", new Object[0])).isGreaterThan(0L);
        ((AbstractLongAssert)Assertions.assertThat((long)Iterables.count((Iterable)Iterables.filter(n -> n.getId() > 10L, nodes))).as("At least two nodes above the scan barrier threshold and below initial creation threshold must have been created, otherwise test assumptions are invalid or outdated", new Object[0])).isGreaterThan(1L);
        this.idController.maintenance();
        tx = (TransactionImpl)this.db.beginTx();
        try {
            IndexingTestUtil.createNodePropIndexWithSpecifiedProvider((TransactionImpl)tx, ControlledSchemaIndexProvider.INDEX_PROVIDER, TestLabels.LABEL_ONE, NAME_PROPERTY);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.index.barrier.await();
        tx = this.db.beginTx();
        try {
            do {
                node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                node.setProperty(NAME_PROPERTY, (Object)nextId++);
                nodes.add(node);
            } while (node.getId() < this.index.populationAtId);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.index.barrier.release();
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)nodes.size(), (int)(this.index.entitiesByScan.size() + this.index.entitiesByUpdater.size()));
        tx = this.db.beginTx();
        try (ResourceIterable allNodes = tx.getAllNodes();){
            for (Node node2 : allNodes) {
                org.junit.jupiter.api.Assertions.assertTrue((this.index.entitiesByScan.contains(node2.getId()) || this.index.entitiesByUpdater.contains(node2.getId()) ? 1 : 0) != 0);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static class ControlledSchemaIndexProvider
    extends ExtensionFactory<Supplier> {
        private final Barrier.Control barrier = new Barrier.Control();
        private final Set<Long> entitiesByScan = new ConcurrentSkipListSet<Long>();
        private final Set<Long> entitiesByUpdater = new ConcurrentSkipListSet<Long>();
        private volatile long populationAtId;
        static final IndexProviderDescriptor INDEX_PROVIDER = new IndexProviderDescriptor("controlled", "1");

        ControlledSchemaIndexProvider() {
            super(ExtensionType.DATABASE, "controlled");
        }

        public Lifecycle newInstance(ExtensionContext context, Supplier noDependencies) {
            return new BaseTestingIndexProvider(INDEX_PROVIDER, IndexDirectoryStructure.directoriesByProvider((Path)Path.of("not-even-persistent", new String[0]))){

                public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor, boolean forRebuildDuringRecovery) {
                    return null;
                }

                public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
                    return new IndexPopulator.Adapter(){

                        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
                            for (IndexEntryUpdate<?> update : updates) {
                                boolean added = entitiesByScan.add(update.getEntityId());
                                org.junit.jupiter.api.Assertions.assertTrue((boolean)added);
                                if (update.getEntityId() <= 10L) continue;
                                populationAtId = update.getEntityId();
                                barrier.reached();
                            }
                        }

                        public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
                            return new IndexUpdater(){

                                public void process(IndexEntryUpdate<?> update) {
                                    boolean added = entitiesByUpdater.add(update.getEntityId());
                                    org.junit.jupiter.api.Assertions.assertTrue((boolean)added);
                                }

                                public void close() {
                                }
                            };
                        }

                        public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)populationCompletedSuccessfully);
                        }

                        public void markAsFailed(String failure) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) {
                    return (IndexAccessor)Mockito.mock(IndexAccessor.class);
                }

                public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
                    return InternalIndexState.POPULATING;
                }
            };
        }
    }
}

