/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.LongStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.api.CommandCommitListener;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class TransactionAppendIndexIT {
    private static final int MB_DATA_SIZE = 5;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private TransactionIdStore txIdStore;
    private BatchValidatorListener batchValidatorListener;
    private final AtomicBoolean enabledCheck = new AtomicBoolean();

    TransactionAppendIndexIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        this.batchValidatorListener = new BatchValidatorListener();
        builder.setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)new CommandCommitListeners(new CommandCommitListener[]{this.batchValidatorListener})));
    }

    @Test
    void transactionsAppendIndexes() {
        String propertyName = "data";
        String data = TransactionAppendIndexIT.getRandomData();
        int txNumber = 20;
        try (Transaction transaction = this.database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty(propertyName, (Object)"a");
            transaction.commit();
        }
        this.enabledCheck.set(true);
        long latestAppendIndexBeforeLoop = this.txIdStore.getLastCommittedBatch().appendIndex();
        for (int transactions = 0; transactions < txNumber; ++transactions) {
            try (Transaction transaction = this.database.beginTx();){
                for (int i = 0; i < 10; ++i) {
                    Node node = transaction.createNode();
                    node.setProperty(propertyName, (Object)data);
                }
                transaction.commit();
                continue;
            }
        }
        this.enabledCheck.set(false);
        CopyOnWriteArrayList<Long> observedBatches = this.batchValidatorListener.getObservedBatches();
        int expectedNumberOfAppends = txNumber;
        Assertions.assertThat(observedBatches).hasSize(expectedNumberOfAppends);
        Assertions.assertThat(observedBatches).containsExactlyElementsOf(LongStream.range(latestAppendIndexBeforeLoop + 1L, latestAppendIndexBeforeLoop + 1L + (long)expectedNumberOfAppends).boxed().toList());
    }

    private static String getRandomData() {
        return RandomStringUtils.randomAscii((int)((int)ByteUnit.MebiByte.toBytes(5L)));
    }

    private class BatchValidatorListener
    implements CommandCommitListener {
        private final CopyOnWriteArrayList<Long> observedBatches = new CopyOnWriteArrayList();

        private BatchValidatorListener() {
        }

        public void onCommandBatchCommitFailure(CommandBatch commandBatch, Exception exception) {
        }

        public void onCommandBatchCommitSuccess(CommandBatch commandBatch, long lastCommittedTx) {
            if (TransactionAppendIndexIT.this.enabledCheck.get()) {
                this.observedBatches.add(commandBatch.appendIndex());
            }
        }

        public CopyOnWriteArrayList<Long> getObservedBatches() {
            return this.observedBatches;
        }
    }
}

