/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class CheckpointKernelVersionIT {
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private KernelVersionRepository kernelVersionRepository;
    @Inject
    private LogFiles logFiles;

    @Test
    void checkPointRecordContainsDatabaseKernelVersion() throws IOException {
        this.kernelVersionRepository.setKernelVersion(KernelVersion.V5_7);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Forced " + this.kernelVersionRepository.kernelVersion()));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)checkpoint.kernelVersion()).as("kernel version from last checkpoint", new Object[0])).isEqualTo((Object)this.kernelVersionRepository.kernelVersion());
    }

    @Test
    void checkPointRecordContainsAppendIndex() throws IOException {
        this.kernelVersionRepository.setKernelVersion(KernelVersion.V5_20);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Forced " + this.kernelVersionRepository.kernelVersion()));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        ((AbstractLongAssert)Assertions.assertThat((long)checkpoint.appendIndex()).as("Append index should be positive number", new Object[0])).isGreaterThan(1L);
    }

    @Test
    void checkPointInLegacy5_0Format() throws IOException {
        this.kernelVersionRepository.setKernelVersion(KernelVersion.V5_0);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Legacy format."));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        org.junit.jupiter.api.Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)checkpoint.kernelVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)checkpoint.transactionId().consensusIndex());
    }
}

