/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.FileLockException;
import org.neo4j.io.locker.Locker;
import org.neo4j.kernel.internal.locker.DatabaseLocker;
import org.neo4j.kernel.internal.locker.GlobalLocker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class FileLockerTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;

    FileLockerTest() {
    }

    static Stream<LockerFactory> lockerFactories() {
        return Stream.of((fs, directory) -> new GlobalLocker(fs, Neo4jLayout.of((Path)directory.homePath())), (fs, directory) -> new DatabaseLocker(fs, Neo4jLayout.of((Path)directory.homePath()).databaseLayout("neo4j")));
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldUseAlreadyOpenedFileChannel(LockerFactory lockerFactory) throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        CustomChannelFileSystemAbstraction fileSystemAbstraction = new CustomChannelFileSystemAbstraction(this.fileSystem, channel);
        MutableInt numberOfCallesToOpen = new MutableInt();
        org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> {
            try (Locker locker = lockerFactory.createLocker((FileSystemAbstraction)fileSystemAbstraction, this.testDirectory);){
                org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> ((Locker)locker).checkLock());
                numberOfCallesToOpen.setValue(fileSystemAbstraction.getNumberOfCallsToOpen());
                locker.checkLock();
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)numberOfCallesToOpen.intValue(), (int)fileSystemAbstraction.getNumberOfCallsToOpen(), (String)"Expect that number of open channels will remain the same for ");
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldAllowMultipleCallsToCheckLock(LockerFactory lockerFactory) throws Exception {
        try (Locker locker = lockerFactory.createLocker(this.fileSystem, this.testDirectory);){
            locker.checkLock();
            locker.checkLock();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void keepLockWhenOtherTryToTakeLock(LockerFactory lockerFactory) throws Exception {
        Locker locker = lockerFactory.createLocker(this.fileSystem, this.testDirectory);
        locker.checkLock();
        org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> {
            try (Locker locker1 = lockerFactory.createLocker(this.fileSystem, this.testDirectory);){
                locker1.checkLock();
            }
        });
        org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> {
            try (Locker locker1 = lockerFactory.createLocker(this.fileSystem, this.testDirectory);){
                locker1.checkLock();
            }
        });
        locker.close();
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldObtainLockWhenFileNotLocked(LockerFactory lockerFactory) {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystem){

            public boolean fileExists(Path file) {
                return FileLockerTest.this.fileSystem.fileExists(file);
            }
        };
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$shouldObtainLockWhenFileNotLocked$5(lockerFactory, (FileSystemAbstraction)fileSystemAbstraction));
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldCreateDirAndObtainLockWhenDirDoesNotExist(LockerFactory lockerFactory) throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystem){

            public boolean fileExists(Path file) {
                return false;
            }
        };
        try (Locker locker = lockerFactory.createLocker((FileSystemAbstraction)fileSystemAbstraction, this.testDirectory);){
            locker.checkLock();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldNotObtainLockWhenDirCannotBeCreated(LockerFactory lockerFactory) {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystem){

            public void mkdirs(Path fileName) throws IOException {
                throw new IOException("store dir could not be created");
            }

            public boolean fileExists(Path file) {
                return false;
            }
        };
        FileLockException fileLockException = (FileLockException)org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> this.lambda$shouldNotObtainLockWhenDirCannotBeCreated$6(lockerFactory, (FileSystemAbstraction)fileSystemAbstraction));
        Assertions.assertThat((String)fileLockException.getMessage()).startsWith((CharSequence)"Unable to create path for dir: ");
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldNotObtainLockWhenUnableToOpenLockFile(LockerFactory lockerFactory) {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystem){

            public StoreChannel write(Path fileName) throws IOException {
                throw new IOException("cannot open lock file");
            }

            public boolean fileExists(Path file) {
                return false;
            }
        };
        FileLockException fileLockException = (FileLockException)org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> this.lambda$shouldNotObtainLockWhenUnableToOpenLockFile$7(lockerFactory, (FileSystemAbstraction)fileSystemAbstraction));
        Assertions.assertThat((String)fileLockException.getMessage()).startsWith((CharSequence)"Unable to obtain lock on file:");
    }

    @ParameterizedTest
    @MethodSource(value={"lockerFactories"})
    void shouldNotObtainLockWhenAlreadyInUse(LockerFactory lockerFactory) {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystem){

            public boolean fileExists(Path file) {
                return false;
            }

            public StoreChannel write(Path fileName) throws IOException {
                return new DelegatingStoreChannel(super.write(fileName)){

                    public FileLock tryLock() {
                        return null;
                    }
                };
            }
        };
        FileLockException fileLockException = (FileLockException)org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> this.lambda$shouldNotObtainLockWhenAlreadyInUse$8(lockerFactory, (FileSystemAbstraction)fileSystemAbstraction));
        Assertions.assertThat((String)fileLockException.getMessage()).contains(new CharSequence[]{"Lock file has been locked by another process"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void mustPreventMultipleInstancesFromStartingOnSameStore() {
        Path storeDir = this.testDirectory.homePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        try {
            GraphDatabaseService db = managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
            }
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> new TestDatabaseManagementServiceBuilder(storeDir).build());
        }
        finally {
            managementService.shutdown();
        }
    }

    private /* synthetic */ void lambda$shouldNotObtainLockWhenAlreadyInUse$8(LockerFactory lockerFactory, FileSystemAbstraction fileSystemAbstraction) throws Throwable {
        try (Locker storeLocker = lockerFactory.createLocker(fileSystemAbstraction, this.testDirectory);){
            storeLocker.checkLock();
        }
    }

    private /* synthetic */ void lambda$shouldNotObtainLockWhenUnableToOpenLockFile$7(LockerFactory lockerFactory, FileSystemAbstraction fileSystemAbstraction) throws Throwable {
        try (Locker storeLocker = lockerFactory.createLocker(fileSystemAbstraction, this.testDirectory);){
            storeLocker.checkLock();
        }
    }

    private /* synthetic */ void lambda$shouldNotObtainLockWhenDirCannotBeCreated$6(LockerFactory lockerFactory, FileSystemAbstraction fileSystemAbstraction) throws Throwable {
        try (Locker storeLocker = lockerFactory.createLocker(fileSystemAbstraction, this.testDirectory);){
            storeLocker.checkLock();
        }
    }

    private /* synthetic */ void lambda$shouldObtainLockWhenFileNotLocked$5(LockerFactory lockerFactory, FileSystemAbstraction fileSystemAbstraction) throws Throwable {
        try (Locker locker = lockerFactory.createLocker(fileSystemAbstraction, this.testDirectory);){
            locker.checkLock();
        }
    }

    @FunctionalInterface
    private static interface LockerFactory {
        public Locker createLocker(FileSystemAbstraction var1, TestDirectory var2);
    }

    private static class CustomChannelFileSystemAbstraction
    extends DelegatingFileSystemAbstraction {
        private final StoreChannel channel;
        private int numberOfCallsToOpen;

        CustomChannelFileSystemAbstraction(FileSystemAbstraction delegate, StoreChannel channel) {
            super(delegate);
            this.channel = channel;
        }

        public StoreChannel write(Path fileName) {
            ++this.numberOfCallsToOpen;
            return this.channel;
        }

        int getNumberOfCallsToOpen() {
            return this.numberOfCallsToOpen;
        }
    }
}

