/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.version.VersionStorageTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.tracer.DefaultTracer;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryPredicateException;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.facade.RecoveryCriteria;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

@PageCacheExtension
@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class RecoveryIT {
    private static final int TEN_KB = (int)ByteUnit.kibiBytes((long)10L);
    private static final CursorContextFactory CONTEXT_FACTORY = CursorContextFactory.NULL_CONTEXT_FACTORY;
    private static final IdType TEST_NODE_TYPE = new IdType(){

        public String name() {
            return "TestNodeId";
        }

        public boolean highActivity() {
            return false;
        }
    };
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private RandomSupport random;
    private DatabaseLayout databaseLayout;
    private TestDatabaseManagementServiceBuilder builder;
    private DatabaseManagementService managementService;
    private FakeClock fakeClock;
    private AssertableLogProvider logProvider;

    RecoveryIT() {
    }

    @BeforeEach
    void setUp() {
        this.databaseLayout = this.neo4jLayout.databaseLayout("neo4j");
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void avoidRescanningLogTailInfoOnRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        CheckpointTracer checkpointTracer = new CheckpointTracer();
        DatabaseTracers tracers = new DatabaseTracers((DatabaseTracer)checkpointTracer, LockTracer.NONE, PageCacheTracer.NULL, VersionStorageTracer.NULL);
        this.recoverDatabase(tracers);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)checkpointTracer.getCheckpointOpenCounter());
    }

    @Test
    void isRecoveryRequiredCheckKeepsEmptyLastCheckpointFile() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        logFiles.getCheckpointFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        int checkpointFilesWithoutVictim = this.countCheckpointFiles();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        Path victimFilePath = logFiles.getCheckpointFile().rotate();
        Config config = (Config)database.getDependencyResolver().resolveDependency(Config.class);
        this.managementService.shutdown();
        this.prepareEmptyLogFile(victimFilePath);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)checkpointFilesWithoutVictim, (int)this.countCheckpointFiles());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout, (Config)config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout, (Config)config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        org.junit.jupiter.api.Assertions.assertNotEquals((int)checkpointFilesWithoutVictim, (int)this.countCheckpointFiles());
    }

    @Test
    void recoverDatabaseWithEmptyLastCheckpointFileAndRemoveThatFileAfterRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        logFiles.getCheckpointFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        int checkpointFilesWithoutVictim = this.countCheckpointFiles();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        Path victimFilePath = logFiles.getCheckpointFile().rotate();
        this.managementService.shutdown();
        this.prepareEmptyLogFile(victimFilePath);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)checkpointFilesWithoutVictim, (int)this.countCheckpointFiles());
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)checkpointFilesWithoutVictim, (int)this.countCheckpointFiles());
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void recoverDatabaseWithEmptyPreallocatedLastCheckpointFileAndRemoveThatFileAfterRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        logFiles.getCheckpointFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        int checkpointFilesWithoutVictim = this.countCheckpointFiles();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        Path victimFilePath = logFiles.getCheckpointFile().rotate();
        this.managementService.shutdown();
        this.prepareEmptyZeroedLogFile(victimFilePath);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)checkpointFilesWithoutVictim, (int)this.countCheckpointFiles());
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)checkpointFilesWithoutVictim, (int)this.countCheckpointFiles());
    }

    @Test
    void recoverTxLogsWithPartiallyWrittenLastRecordInFirstTransactionAfterCheckpoint() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        this.assumeRecordStorageEngine(database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        Path logFileToManipulate = logFiles.getLogFile().getHighestLogFile();
        RelationshipType marker = RelationshipType.withName((String)"Type");
        String propertyName = "a";
        try (Transaction tx = database.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            node1.createRelationshipTo(node2, marker);
            node2.setProperty(propertyName, (Object)"b");
            tx.commit();
        }
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        LogPosition position = logFiles.getLogFile().getTransactionLogWriter().getCurrentPosition();
        try (Transaction tx = database.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            node1.createRelationshipTo(node2, marker);
            node2.setProperty(propertyName, (Object)RandomStringUtils.randomAlphanumeric((int)TEN_KB));
            tx.commit();
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.removeLastKbFromLogFile(logFileToManipulate, position);
        this.recoverDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverTxLogsWithBrokenFirstEntryInFirstTransactionAfterCheckpoint() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        Path logFileToManipulate = logFiles.getLogFile().getHighestLogFile();
        LogPosition positionForCorruption = logFiles.getLogFile().getTransactionLogWriter().getCurrentPosition();
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.appendBytesToLastLogFile(logFileToManipulate, positionForCorruption, new byte[]{1, 0, 0});
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((Object)positionForCorruption, (Object)logFiles.getLogFile().getTransactionLogWriter().getCurrentPosition());
        try (Transaction tx = recoveredDatabase.beginTx();){
            tx.createNode();
            tx.commit();
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void failToRecoverDatabaseWithCorruptedLastCheckpointFile() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        logFiles.getCheckpointFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        int checkpointFilesWithoutVictim = this.countCheckpointFiles();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        Path victimFilePath = logFiles.getCheckpointFile().rotate();
        this.managementService.shutdown();
        this.prepareCorruptedLogFile(victimFilePath);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this::recoverDatabase).rootCause().isInstanceOf(IllegalStateException.class)).hasMessageContaining("has unreadable header but looks like it also contains some checkpoint data.");
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void recoverDatabaseWithEmptyLastLogFileAndRemoveThatFileAfterRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        logFiles.getLogFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        int logFilesWithoutVictim = this.countTransactionLogFiles();
        Path victimFilePath = logFiles.getLogFile().rotate();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.prepareEmptyZeroedLogFile(victimFilePath);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)logFilesWithoutVictim, (int)this.countTransactionLogFiles());
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)logFilesWithoutVictim, (int)this.countTransactionLogFiles());
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void recoverDatabaseWithEmptySeveralLastLogFileAndRemoveThatFileAfterRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        logFiles.getLogFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        int logFilesWithoutVictims = this.countTransactionLogFiles();
        Path victimFilePath1 = logFiles.getLogFile().rotate();
        Path victimFilePath2 = logFiles.getLogFile().rotate();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.prepareEmptyZeroedLogFile(victimFilePath1);
        this.prepareEmptyZeroedLogFile(victimFilePath2);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)logFilesWithoutVictims, (int)this.countTransactionLogFiles());
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)logFilesWithoutVictims, (int)this.countTransactionLogFiles());
    }

    @Test
    void recoverDatabaseWithEmptyNotPreallocatedLastLogFileAndRemoveThatFileAfterRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        logFiles.getLogFile().rotate();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        int logFilesWithoutVictim = this.countTransactionLogFiles();
        Path victimFilePath = logFiles.getLogFile().rotate();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.prepareEmptyLogFile(victimFilePath);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)logFilesWithoutVictim, (int)this.countTransactionLogFiles());
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)logFilesWithoutVictim, (int)this.countTransactionLogFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @EnabledOnOs(value={OS.LINUX})
    void recoverDatabaseWithEmptyLastLogFileWithCorrectNumberOfNodesAndRelationships() throws Exception {
        Node end;
        Node start;
        GraphDatabaseAPI database = this.createDatabase();
        RelationshipType relationshipType = RelationshipType.withName((String)"marker");
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        try (Transaction tx = database.beginTx();){
            start = tx.createNode();
            end = tx.createNode();
            start.createRelationshipTo(end, relationshipType);
            tx.commit();
        }
        logFiles.getLogFile().rotate();
        tx = database.beginTx();
        try {
            start = tx.createNode();
            end = tx.createNode();
            start.createRelationshipTo(end, relationshipType);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        logFiles.getLogFile().rotate();
        tx = database.beginTx();
        try {
            start = tx.createNode();
            end = tx.createNode();
            start.createRelationshipTo(end, relationshipType);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        logFiles.getLogFile().rotate();
        int logFilesWithoutVictim = this.countTransactionLogFiles();
        Path victimFilePath = logFiles.getLogFile().rotate();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.prepareEmptyZeroedLogFile(victimFilePath);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)logFilesWithoutVictim, (int)this.countTransactionLogFiles());
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try (Transaction transaction = recoveredDatabase.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)6L, (long)Iterables.count((Iterable)transaction.getAllNodes()));
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)Iterables.count((Iterable)transaction.getAllRelationships()));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @Test
    void recoveryWithLastBrokenRecord() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        LogPosition currentPosition = logFile.getTransactionLogWriter().getCurrentPosition();
        Path logFileToMutate = logFile.getLogFileForVersion(currentPosition.getLogVersion());
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.appendBytesToLastLogFile(logFileToMutate, currentPosition, new byte[]{1, 0, 0});
        this.recoverDatabase();
    }

    @Test
    void recoveryWithDataAfterLastBrokenRecord() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        LogPosition currentPosition = logFile.getTransactionLogWriter().getCurrentPosition();
        Path logFileToMutate = logFile.getLogFileForVersion(currentPosition.getLogVersion());
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.appendBytesToLastLogFile(logFileToMutate, currentPosition, new byte[]{1, 0, 0, 1});
        Assertions.assertThatThrownBy(this::recoverDatabase).hasStackTraceContaining("Failure to read transaction log file number 0. Unreadable bytes are encountered after last readable position.");
    }

    @Test
    void recoveryWithLastBrokenRecordTruncateFile() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        LogPosition currentPosition = logFile.getTransactionLogWriter().getCurrentPosition();
        long fileSizeBeforeMutation = currentPosition.getByteOffset();
        Path logFileToMutate = logFile.getLogFileForVersion(currentPosition.getLogVersion());
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.appendBytesToLastLogFile(logFileToMutate, currentPosition, new byte[]{1, 2, 0, 0});
        org.junit.jupiter.api.Assertions.assertNotEquals((long)fileSizeBeforeMutation, (long)this.fileSystem.getFileSize(logFileToMutate));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)fileSizeBeforeMutation, (long)this.fileSystem.getFileSize(logFileToMutate));
    }

    @Test
    void recoveryWithLastBrokenRecordTruncateBigFile() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        LogPosition currentPosition = logFile.getTransactionLogWriter().getCurrentPosition();
        long fileSizeBeforeMutation = currentPosition.getByteOffset();
        Path logFileToMutate = logFile.getLogFileForVersion(currentPosition.getLogVersion());
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        byte[] data = new byte[(int)ByteUnit.kibiBytes((long)this.random.nextInt(120, 484))];
        data[0] = 1;
        data[1] = 2;
        this.appendBytesToLastLogFile(logFileToMutate, currentPosition, data);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)fileSizeBeforeMutation, (long)this.fileSystem.getFileSize(logFileToMutate));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)fileSizeBeforeMutation, (long)this.fileSystem.getFileSize(logFileToMutate));
    }

    @Test
    void recoveryWithDataLongAfterLastBrokenRecord() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        LogPosition currentPosition = logFile.getTransactionLogWriter().getCurrentPosition();
        Path logFileToMutate = logFile.getLogFileForVersion(currentPosition.getLogVersion());
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        byte[] data = new byte[(int)ByteUnit.kibiBytes((long)this.random.nextInt(20, 789))];
        data[0] = 1;
        data[data.length - this.random.nextInt((int)2, (int)15)] = 2;
        this.appendBytesToLastLogFile(logFileToMutate, currentPosition, data);
        Assertions.assertThatThrownBy(this::recoverDatabase).hasStackTraceContaining("Failure to read transaction log file number 0. Unreadable bytes are encountered after last readable position.");
    }

    @Test
    void recoveryWithRemovedLogs() throws Exception {
        Path[] files;
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        int removedFiles = 0;
        Path transactionLogsDirectory = this.databaseLayout.getTransactionLogsDirectory();
        for (Path file : files = FileUtils.listPaths((Path)transactionLogsDirectory)) {
            this.fileSystem.deleteFile(file);
            ++removedFiles;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)removedFiles);
        this.createDatabase();
        this.managementService.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        GraphDatabaseAPI db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)((LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class)).getCheckpointFile().getCurrentDetachedLogVersion());
    }

    @Test
    void recoveryWithRemovedOnlyTransactionLogs() throws Exception {
        Path[] files;
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        int removedFiles = 0;
        Path transactionLogsDirectory = this.databaseLayout.getTransactionLogsDirectory();
        for (Path file : files = FileUtils.listPaths((Path)transactionLogsDirectory)) {
            if (file.getFileName().getFileName().toString().contains("checkpoint")) continue;
            this.fileSystem.deleteFile(file);
            ++removedFiles;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)removedFiles);
        this.createDatabase();
        this.managementService.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        GraphDatabaseAPI db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)((LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class)).getCheckpointFile().getCurrentDetachedLogVersion());
    }

    @Test
    void recoveryWithRemovedOnlyTransactionLogsAndLotsOfCheckpointFiles() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        CheckPointer checkPointer = (CheckPointer)dependencyResolver.resolveDependency(CheckPointer.class);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        for (int i = 0; i < 12; ++i) {
            checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
            checkpointFile.rotate();
        }
        this.managementService.shutdown();
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)checkpointFile.getLowestLogVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)checkpointFile.getHighestLogVersion());
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        int removedFiles = 0;
        int checkpointFilesLeftOvers = 0;
        Path transactionLogsDirectory = this.databaseLayout.getTransactionLogsDirectory();
        for (Path file : this.fileSystem.listFiles(transactionLogsDirectory)) {
            if (!file.getFileName().getFileName().toString().contains("checkpoint")) {
                this.fileSystem.deleteFile(file);
                ++removedFiles;
                continue;
            }
            ++checkpointFilesLeftOvers;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)removedFiles);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)checkpointFilesLeftOvers);
        DatabaseManagementService recoveryDbms = this.dbmsWithFailOnCorruptedFalse();
        recoveryDbms.shutdown();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        GraphDatabaseAPI db = this.createDatabase();
        CheckpointFile restoredCheckpoint = ((LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class)).getCheckpointFile();
        org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)restoredCheckpoint.getCurrentDetachedLogVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)restoredCheckpoint.getDetachedCheckpointFiles().length);
    }

    @Test
    void recoveryRequiredOnDatabaseWithoutCorrectCheckpoints() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
    }

    @Test
    void recoveryNotRequiredWhenDatabaseNotFound() throws Exception {
        DatabaseLayout absentDatabase = this.neo4jLayout.databaseLayout("absent");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(absentDatabase));
    }

    @Test
    void recoverEmptyDatabase() throws Throwable {
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.skip_default_indexes_on_creation, (Object)true).set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).build();
        this.managementService = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(config).build();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout, config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithNodes() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfNodes = 10;
        for (int i = 0; i < numberOfNodes; ++i) {
            RecoveryIT.createSingleNode((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try (Transaction tx = recoveredDatabase.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)tx.getAllNodes()));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void tracePageCacheAccessOnDatabaseRecovery() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfNodes = 10;
        for (int i = 0; i < numberOfNodes; ++i) {
            RecoveryIT.createSingleNode((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        DatabaseTracers tracers = new DatabaseTracers(DatabaseTracer.NULL, LockTracer.NONE, (PageCacheTracer)pageCacheTracer, VersionStorageTracer.NULL);
        this.recoverDatabase(tracers);
        long pins = pageCacheTracer.pins();
        Assertions.assertThat((long)pins).isGreaterThan(0L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(pins);
        Assertions.assertThat((long)pageCacheTracer.hits()).isGreaterThan(0L).isLessThanOrEqualTo(pins);
        Assertions.assertThat((long)pageCacheTracer.faults()).isGreaterThan(0L).isLessThanOrEqualTo(pins);
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try (Transaction tx = recoveredDatabase.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)tx.getAllNodes()));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithNodesAndRelationshipsAndRelationshipTypes() throws Throwable {
        Transaction transaction;
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfRelationships = 10;
        int numberOfNodes = numberOfRelationships * 2;
        for (int i = 0; i < numberOfRelationships; ++i) {
            transaction = database.beginTx();
            try {
                Node start = transaction.createNode();
                Node stop = transaction.createNode();
                start.createRelationshipTo(stop, RelationshipType.withName((String)String.valueOf(i)));
                transaction.commit();
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try {
            transaction = recoveredDatabase.beginTx();
            try {
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)transaction.getAllNodes()));
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfRelationships, (long)Iterables.count((Iterable)transaction.getAllRelationships()));
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfRelationships, (long)Iterables.count((Iterable)transaction.getAllRelationshipTypesInUse()));
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithProperties() throws Throwable {
        Transaction transaction;
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfRelationships = 10;
        int numberOfNodes = numberOfRelationships * 2;
        for (int i = 0; i < numberOfRelationships; ++i) {
            transaction = database.beginTx();
            try {
                Node start = transaction.createNode();
                Node stop = transaction.createNode();
                start.setProperty("start" + i, (Object)i);
                stop.setProperty("stop" + i, (Object)i);
                start.createRelationshipTo(stop, RelationshipType.withName((String)String.valueOf(i)));
                transaction.commit();
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try {
            transaction = recoveredDatabase.beginTx();
            try {
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)transaction.getAllNodes()));
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfRelationships, (long)Iterables.count((Iterable)transaction.getAllRelationships()));
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfRelationships, (long)Iterables.count((Iterable)transaction.getAllRelationshipTypesInUse()));
                org.junit.jupiter.api.Assertions.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)transaction.getAllPropertyKeys()));
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithConstraint() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfNodes = 10;
        String property = "prop";
        Label label = Label.label((String)"myLabel");
        try (Transaction tx = database.beginTx();){
            tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        for (int i = 0; i < numberOfNodes; ++i) {
            try (Transaction tx = database.beginTx();){
                Node node = tx.createNode(new Label[]{label});
                node.setProperty(property, (Object)i);
                tx.commit();
                continue;
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try {
            int i = 0;
            while (i < numberOfNodes) {
                int finalInt = i++;
                org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
                    try (Transaction tx = recoveredDatabase.beginTx();){
                        Node node = tx.createNode(new Label[]{label});
                        node.setProperty(property, (Object)finalInt);
                        tx.commit();
                    }
                });
            }
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithRelConstraint() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfRels = 10;
        String property = "prop";
        RelationshipType type = RelationshipType.withName((String)"myType");
        try (Transaction tx = database.beginTx();){
            tx.schema().constraintFor(type).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        for (int i = 0; i < numberOfRels; ++i) {
            try (Transaction tx = database.beginTx();){
                Node node = tx.createNode();
                Relationship rel = node.createRelationshipTo(node, type);
                rel.setProperty(property, (Object)i);
                tx.commit();
                continue;
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        try {
            int i = 0;
            while (i < numberOfRels) {
                int finalInt = i++;
                org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
                    try (Transaction tx = recoveredDatabase.beginTx();){
                        Node node = tx.createNode();
                        Relationship rel = node.createRelationshipTo(node, type);
                        rel.setProperty(property, (Object)finalInt);
                        tx.commit();
                    }
                });
            }
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithNodeIndexes() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfNodes = 10;
        Label label = Label.label((String)"myLabel");
        String property = "prop";
        String rangeIndex = "range index";
        String textIndex = "text index";
        String fullTextIndex = "full text index";
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(label).on(property).withIndexType(IndexType.RANGE).withName(rangeIndex).create();
            transaction.schema().indexFor(label).on(property).withIndexType(IndexType.TEXT).withName(textIndex).create();
            transaction.schema().indexFor(label).on(property).withIndexType(IndexType.FULLTEXT).withName(fullTextIndex).create();
            transaction.commit();
        }
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        for (int i = 0; i < numberOfNodes; ++i) {
            try (Transaction tx = database.beginTx();){
                Node node = tx.createNode(new Label[]{label});
                node.setProperty(property, (Object)("value" + i));
                tx.commit();
                continue;
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)recoveredDatabase);
        try (InternalTransaction transaction = (InternalTransaction)recoveredDatabase.beginTx();){
            this.verifyNodeIndexEntries(numberOfNodes, rangeIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
            this.verifyNodeIndexEntries(numberOfNodes, textIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
            this.verifyNodeIndexEntries(numberOfNodes, fullTextIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.fulltextSearch((String)"*"));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithNodePointIndex() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfNodes = 10;
        Label label = Label.label((String)"myLabel");
        String property = "prop";
        String pointIndex = "point index";
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(label).on(property).withIndexType(IndexType.POINT).withName(pointIndex).create();
            transaction.commit();
        }
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        for (int i = 0; i < numberOfNodes; ++i) {
            try (Transaction tx = database.beginTx();){
                Node node = tx.createNode(new Label[]{label});
                node.setProperty(property, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{i, -i}));
                tx.commit();
                continue;
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)recoveredDatabase);
        try (InternalTransaction transaction = (InternalTransaction)recoveredDatabase.beginTx();){
            this.verifyNodeIndexEntries(numberOfNodes, pointIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithRelationshipIndexes() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfRelationships = 10;
        RelationshipType type = RelationshipType.withName((String)"TYPE");
        String property = "prop";
        String rangeIndex = "range index";
        String textIndex = "text index";
        String fullTextIndex = "full text index";
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(type).on(property).withIndexType(IndexType.RANGE).withName(rangeIndex).create();
            transaction.schema().indexFor(type).on(property).withIndexType(IndexType.TEXT).withName(textIndex).create();
            transaction.schema().indexFor(type).on(property).withIndexType(IndexType.FULLTEXT).withName(fullTextIndex).create();
            transaction.commit();
        }
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        transaction = database.beginTx();
        try {
            Node start = transaction.createNode();
            Node stop = transaction.createNode();
            for (int i = 0; i < numberOfRelationships; ++i) {
                Relationship relationship = start.createRelationshipTo(stop, type);
                relationship.setProperty(property, (Object)("value" + i));
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)recoveredDatabase);
        try (InternalTransaction transaction = (InternalTransaction)recoveredDatabase.beginTx();){
            this.verifyRelationshipIndexEntries(numberOfRelationships, rangeIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
            this.verifyRelationshipIndexEntries(numberOfRelationships, textIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
            this.verifyRelationshipIndexEntries(numberOfRelationships, fullTextIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.fulltextSearch((String)"*"));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverDatabaseWithRelationshipPointIndex() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfRelationships = 10;
        RelationshipType type = RelationshipType.withName((String)"TYPE");
        String property = "prop";
        String pointIndex = "point index";
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(type).on(property).withIndexType(IndexType.POINT).withName(pointIndex).create();
            transaction.commit();
        }
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        transaction = database.beginTx();
        try {
            Node start = transaction.createNode();
            Node stop = transaction.createNode();
            for (int i = 0; i < numberOfRelationships; ++i) {
                Relationship relationship = start.createRelationshipTo(stop, type);
                relationship.setProperty(property, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{i, -i}));
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)recoveredDatabase);
        try (InternalTransaction transaction = (InternalTransaction)recoveredDatabase.beginTx();){
            this.verifyRelationshipIndexEntries(numberOfRelationships, pointIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverRedefinedIndex() throws Exception {
        Node node;
        long droppedIndexId;
        IndexDefinition indexDefinition;
        GraphDatabaseAPI database = this.createDatabase();
        Label label = Label.label((String)"myLabel");
        String property1 = "prop1";
        String property2 = "prop2";
        String rangeIndex = "range index";
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(label).on(property1).withIndexType(IndexType.RANGE).withName(rangeIndex).create();
            transaction.commit();
        }
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        try (Transaction tx = database.beginTx();){
            Node node2 = tx.createNode(new Label[]{label});
            node2.setProperty(property1, (Object)"value1");
            tx.commit();
        }
        this.forceCheckpoint((GraphDatabaseService)database);
        try (Transaction tx = database.beginTx();){
            indexDefinition = tx.schema().getIndexByName(rangeIndex);
            droppedIndexId = ((IndexDefinitionImpl)indexDefinition).getIndexReference().getId();
            indexDefinition.drop();
            tx.commit();
        }
        tx = database.beginTx();
        try {
            node = tx.createNode(new Label[]{label});
            node.setProperty(property1, (Object)"value2");
            node.setProperty(property2, (Object)"another value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.performIdMaintenance((GraphDatabaseService)database);
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(label).on(property1).on(property2).withIndexType(IndexType.RANGE).withName(rangeIndex).create();
            transaction.commit();
        }
        tx = database.beginTx();
        try {
            indexDefinition = tx.schema().getIndexByName(rangeIndex);
            org.junit.jupiter.api.Assertions.assertEquals((long)droppedIndexId, (long)((IndexDefinitionImpl)indexDefinition).getIndexReference().getId());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        tx = database.beginTx();
        try {
            node = tx.createNode(new Label[]{label});
            node.setProperty(property1, (Object)"value3");
            node.setProperty(property2, (Object)"another value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.recoverDatabase();
        GraphDatabaseAPI recoveredDatabase = this.createDatabase();
        RecoveryIT.awaitIndexesOnline((GraphDatabaseService)recoveredDatabase);
        try (InternalTransaction transaction = (InternalTransaction)recoveredDatabase.beginTx();){
            this.verifyNodeIndexEntries(2, rangeIndex, transaction, (PropertyIndexQuery)PropertyIndexQuery.allEntries());
            List props = transaction.getAllNodes().stream().map(n -> n.getProperty(property1)).collect(Collectors.toList());
            Assertions.assertThat(props).containsExactly(new Object[]{"value1", "value2", "value3"});
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @Test
    void recoveryStopsExtensionsBeforeCheckpoint() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        int checkpointsBeforeRecovery = this.countCheckPointsInTransactionLogs();
        TestRecoveryExtension extension = new TestRecoveryExtension(checkpointsBeforeRecovery);
        this.recoverDatabase(List.of(extension));
        Assertions.assertThat((boolean)extension.stopped).isTrue();
    }

    private void performIdMaintenance(GraphDatabaseService database) {
        ((IdController)((GraphDatabaseAPI)database).getDependencyResolver().resolveDependency(IdController.class)).maintenance();
    }

    private void forceCheckpoint(GraphDatabaseService database) throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)database).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test checkpoint"));
    }

    private void verifyRelationshipIndexEntries(int numberOfRelationships, String indexName, InternalTransaction transaction, PropertyIndexQuery query) throws KernelException {
        KernelTransaction ktx = transaction.kernelTransaction();
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        IndexReadSession indexReadSession = ktx.dataRead().indexReadSession(index);
        int relationshipsInIndex = 0;
        try (RelationshipValueIndexCursor cursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
            ktx.dataRead().relationshipIndexSeek(ktx.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
            while (cursor.next()) {
                ++relationshipsInIndex;
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)numberOfRelationships, (int)relationshipsInIndex);
    }

    private void verifyNodeIndexEntries(int numberOfNodes, String indexName, InternalTransaction transaction, PropertyIndexQuery query) throws KernelException {
        KernelTransaction ktx = transaction.kernelTransaction();
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        IndexReadSession indexReadSession = ktx.dataRead().indexReadSession(index);
        int nodesInIndex = 0;
        try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
            ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
            while (cursor.next()) {
                ++nodesInIndex;
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)numberOfNodes, (int)nodesInIndex);
    }

    @Test
    void recoverDatabaseWithFirstTransactionLogFileWithoutShutdownCheckpoint() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countCheckPointsInTransactionLogs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToStartDatabaseWithRemovedTransactionLogs() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        this.removeTransactionLogs();
        GraphDatabaseAPI restartedDb = this.createDatabase();
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)restartedDb.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional failure = dbStateService.causeOfFailure(restartedDb.databaseId());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)failure.isPresent());
            Assertions.assertThat((Throwable)((Throwable)failure.get())).rootCause().hasMessageContaining("Transaction logs are missing and recovery is not possible.");
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @Test
    void startDatabaseWithRemovedSingleTransactionLogFile() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        this.managementService.shutdown();
        this.removeTransactionLogs();
        this.startStopDatabaseWithForcedRecovery();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
        this.verifyRecoveryMissingLogs();
    }

    @Test
    void startDatabaseWithRemovedMultipleTransactionLogFiles() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase(ByteUnit.mebiBytes((long)1L));
        while (this.countTransactionLogFiles() < 5) {
            RecoveryIT.generateSomeData((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        this.removeTransactionLogs();
        this.startStopDatabaseWithForcedRecovery();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
    }

    @Test
    void killAndStartDatabaseAfterTransactionLogsRemoval() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase(ByteUnit.mebiBytes((long)1L));
        while (this.countTransactionLogFiles() < 5) {
            RecoveryIT.generateSomeData((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        this.removeTransactionLogs();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countTransactionLogFiles());
        DatabaseManagementService forcedRecoveryManagementService = this.forcedRecoveryManagement();
        GraphDatabaseService service = forcedRecoveryManagementService.database("neo4j");
        RecoveryIT.createSingleNode(service);
        forcedRecoveryManagementService.shutdown();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countTransactionLogFiles());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countCheckPointsInTransactionLogs());
    }

    @Test
    void killAndStartDatabaseAfterTransactionLogsRemovalWithSeveralFilesWithoutCheckpoint() throws Throwable {
        GraphDatabaseAPI database = this.createDatabase(ByteUnit.mebiBytes((long)1L));
        while (this.countTransactionLogFiles() < 5) {
            RecoveryIT.generateSomeData((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countTransactionLogFiles());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countCheckPointsInTransactionLogs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
    }

    @Test
    void startDatabaseAfterTransactionLogsRemovalAndKillAfterRecovery() throws Throwable {
        long logThreshold = ByteUnit.mebiBytes((long)1L);
        GraphDatabaseAPI database = this.createDatabase(logThreshold);
        while (this.countTransactionLogFiles() < 5) {
            RecoveryIT.generateSomeData((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countTransactionLogFiles());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countCheckPointsInTransactionLogs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout));
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countCheckPointsInTransactionLogs());
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.builder = null;
        GraphDatabaseAPI service = this.createDatabase(logThreshold * 2L);
        RecoveryIT.createSingleNode((GraphDatabaseService)service);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.startStopDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countCheckPointsInTransactionLogs());
    }

    @Test
    void recoverDatabaseWithoutOneIdFile() throws Throwable {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        this.managementService.shutdown();
        Path idFile = RecoveryIT.getIdFile(layout);
        this.fileSystem.deleteFileOrThrow(idFile);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)Config.defaults(), (DatabaseLayout)layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)this.logProvider, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(idFile));
    }

    @Test
    void shouldPruneLogs() throws Throwable {
        GraphDatabaseAPI db = this.createDatabase(ByteUnit.kibiBytes((long)128L));
        DatabaseLayout layout = db.databaseLayout();
        for (int i = 0; i < 10; ++i) {
            RecoveryIT.generateSomeData((GraphDatabaseService)db);
        }
        this.managementService.shutdown();
        Assertions.assertThat((long)Arrays.stream(this.fileSystem.listFiles(layout.getTransactionLogsDirectory())).filter(path -> path.toString().contains("transaction.db")).count()).isGreaterThan(2L);
        this.fileSystem.deleteFileOrThrow(RecoveryIT.getIdFile(layout));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        Config config = Config.defaults(Map.of(GraphDatabaseSettings.keep_logical_logs, "keep_none"));
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)config, (DatabaseLayout)layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)this.logProvider, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER));
        Assertions.assertThat((long)Arrays.stream(this.fileSystem.listFiles(layout.getTransactionLogsDirectory())).filter(path -> path.toString().contains("transaction.db")).count()).isEqualTo(1L);
    }

    @Test
    void recoverDatabaseWithoutIdFiles() throws Throwable {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        this.managementService.shutdown();
        for (Path idFile : layout.idFiles()) {
            this.fileSystem.deleteFileOrThrow(idFile);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
        for (Path idFile : layout.idFiles()) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(idFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failRecoveryWithMissingStoreFile() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        DatabaseLayout layout = database.databaseLayout();
        this.managementService.shutdown();
        Path storeFile = RecoveryIT.getStoreFile(layout);
        this.fileSystem.deleteFileOrThrow(storeFile);
        GraphDatabaseAPI restartedDb = this.createDatabase();
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)restartedDb.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional failure = dbStateService.causeOfFailure(restartedDb.databaseId());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)failure.isPresent());
            Assertions.assertThat((Throwable)((Throwable)failure.get()).getCause()).hasMessageContainingAll(new CharSequence[]{storeFile.getFileName().toString(), "is(are) missing and recovery is not possible"});
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failRecoveryWithMissingStoreFileAndIdFile() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)database);
        DatabaseLayout layout = database.databaseLayout();
        this.managementService.shutdown();
        Path storeFile = RecoveryIT.getStoreFile(layout);
        this.fileSystem.deleteFileOrThrow(storeFile);
        this.fileSystem.deleteFileOrThrow(RecoveryIT.getIdFile(layout));
        GraphDatabaseAPI restartedDb = this.createDatabase();
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)restartedDb.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional failure = dbStateService.causeOfFailure(restartedDb.databaseId());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)failure.isPresent());
            Assertions.assertThat((Throwable)((Throwable)failure.get()).getCause()).hasMessageContainingAll(new CharSequence[]{storeFile.getFileName().toString(), "is(are) missing and recovery is not possible"});
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void cancelRecoveryInTheMiddle() throws Throwable {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        Monitors monitors = new Monitors();
        final GlobalGuardConsumerTestExtensionFactory guardExtensionFactory = new GlobalGuardConsumerTestExtensionFactory();
        var recoveryMonitor = new RecoveryMonitor(){
            private final AtomicBoolean reverseCompleted = new AtomicBoolean();
            private final AtomicBoolean recoveryCompleted = new AtomicBoolean();

            public void reverseStoreRecoveryCompleted(long lowestRecoveredAppendIndex) {
                try {
                    guardExtensionFactory.getProvidedGuardConsumer().globalGuard.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.reverseCompleted.set(true);
            }

            public void recoveryCompleted(long recoveryTimeInMilliseconds, RecoveryMode mode) {
                this.recoveryCompleted.set(true);
            }

            public boolean isReverseCompleted() {
                return this.reverseCompleted.get();
            }

            public boolean isRecoveryCompleted() {
                return this.recoveryCompleted.get();
            }
        };
        monitors.addMonitorListener((Object)recoveryMonitor, new String[0]);
        DatabaseManagementService service = new TestDatabaseManagementServiceBuilder(layout.getNeo4jLayout()).addExtension((ExtensionFactory)guardExtensionFactory).setMonitors(monitors).build();
        try {
            GraphDatabaseService database = service.database(layout.getDatabaseName());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)recoveryMonitor.isReverseCompleted());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)recoveryMonitor.isRecoveryCompleted());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)guardExtensionFactory.getProvidedGuardConsumer().globalGuard.isAvailable());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)database.isAvailable());
            Assertions.assertThatThrownBy(() -> ((GraphDatabaseService)database).beginTx()).rootCause().isInstanceOf(DatabaseStartAbortedException.class);
        }
        finally {
            service.shutdown();
        }
    }

    @Test
    void shouldForceRecoveryEvenThoughNotSeeminglyRequired() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        this.managementService.shutdown();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
        ImmutableSet openOptions = ((StorageEngine)db.getDependencyResolver().resolveDependency(StorageEngine.class)).getOpenOptions();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fileSystem, RecoveryCleanupWorkCollector.immediate(), PageCacheTracer.NULL, "my db");
        Path idFile = RecoveryIT.getIdFile(layout);
        try (IdGenerator idGenerator = idGeneratorFactory.open(this.pageCache, idFile, TEST_NODE_TYPE, () -> 0L, 10000L, false, Config.defaults(), CONTEXT_FACTORY, openOptions, IdSlotDistribution.SINGLE_IDS);){
            idGenerator.transactionalMarker(CursorContext.NULL_CONTEXT).close();
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.idGeneratorIsDirty(idFile, (ImmutableSet<OpenOption>)openOptions));
        final MutableBoolean recoveryRunEvenThoughNoCommitsAfterLastCheckpoint = new MutableBoolean();
        RecoveryStartInformationProvider.Monitor monitor = new RecoveryStartInformationProvider.Monitor(){

            public void recoveryNotRequired(LogPosition logPosition) {
                recoveryRunEvenThoughNoCommitsAfterLastCheckpoint.setTrue();
            }
        };
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        Config config = Config.defaults();
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)config, (DatabaseLayout)layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)this.logProvider, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).recoveryPredicate(RecoveryPredicate.ALL).monitors(monitors).extensionFactories(Iterables.cast((Iterable)Services.loadAll(ExtensionFactory.class))).startupChecker(null).clock(Clock.systemUTC()).force());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.idGeneratorIsDirty(idFile, (ImmutableSet<OpenOption>)openOptions));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)recoveryRunEvenThoughNoCommitsAfterLastCheckpoint.booleanValue());
    }

    @Test
    void resetCheckpointVersionOnMissingLogFiles() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        DependencyResolver resolver = db.getDependencyResolver();
        LogFiles logFiles = (LogFiles)resolver.resolveDependency(LogFiles.class);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        for (int i = 0; i < 10; ++i) {
            checkpointFile.rotate();
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)((MetadataProvider)resolver.resolveDependency(MetadataProvider.class)).getCheckpointLogVersion());
        this.managementService.shutdown();
        this.removeTransactionLogs();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)((MetadataProvider)this.createDatabase().getDependencyResolver().resolveDependency(MetadataProvider.class)).getCheckpointLogVersion());
    }

    @Test
    void recoverySetsCheckpointLogVersionSeveralCheckpointFiles() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        CheckpointFile checkpointFile = ((LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class)).getCheckpointFile();
        DetachedCheckpointAppender appender = (DetachedCheckpointAppender)checkpointFile.getCheckpointAppender();
        TransactionId transactionId = new TransactionId(100L, 101L, LatestVersions.LATEST_KERNEL_VERSION, 101, 102L, 103L);
        appender.rotate();
        appender.checkPoint(LogCheckPointEvent.NULL, transactionId, transactionId.id() + 1L, LatestVersions.LATEST_KERNEL_VERSION, new LogPosition(0L, (long)LatestVersions.LATEST_LOG_FORMAT.getHeaderSize()), new LogPosition(0L, (long)LatestVersions.LATEST_LOG_FORMAT.getHeaderSize()), Instant.now(), "test1");
        appender.rotate();
        appender.checkPoint(LogCheckPointEvent.NULL, transactionId, transactionId.id() + 1L, LatestVersions.LATEST_KERNEL_VERSION, new LogPosition(0L, (long)LatestVersions.LATEST_LOG_FORMAT.getHeaderSize()), new LogPosition(0L, (long)LatestVersions.LATEST_LOG_FORMAT.getHeaderSize()), Instant.now(), "test2");
        appender.rotate();
        appender.checkPoint(LogCheckPointEvent.NULL, transactionId, transactionId.id() + 1L, LatestVersions.LATEST_KERNEL_VERSION, new LogPosition(0L, (long)LatestVersions.LATEST_LOG_FORMAT.getHeaderSize()), new LogPosition(0L, (long)LatestVersions.LATEST_LOG_FORMAT.getHeaderSize()), Instant.now(), "test3");
        DatabaseLayout layout = db.databaseLayout();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((MetadataProvider)this.createDatabase().getDependencyResolver().resolveDependency(MetadataProvider.class)).getCheckpointLogVersion());
    }

    @Test
    void recoverDatabaseWithAllTransactionsPredicate() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        long expectedLastTransactionId = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase(RecoveryCriteria.ALL);
        db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedLastTransactionId, (long)RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId());
    }

    @Test
    void recoverDatabaseWithIdPredicateHigherToLastAvailable() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        long expectedLastTransactionId = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase(RecoveryCriteria.until((long)(expectedLastTransactionId + 5L)));
        db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedLastTransactionId, (long)RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId());
    }

    @Test
    void recoverDatabaseWithIdPredicateLowerToLastAvailable() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        long originalLastCommitted = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        long lastTransactionToBeApplied = originalLastCommitted - 5L;
        this.recoverDatabase(RecoveryCriteria.until((long)lastTransactionToBeApplied));
        db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)(lastTransactionToBeApplied - 1L), (long)RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId());
    }

    @Test
    void recoverDatabaseWithDatePredicateHigherToLastAvailable() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        MetadataProvider metaDataStore = RecoveryIT.getMetadataProvider(db);
        long expectedLastCommitTimestamp = metaDataStore.getLastCommittedTransaction().commitTimestamp();
        long expectedLastTransactionId = metaDataStore.getLastCommittedTransactionId();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase(RecoveryCriteria.until((Instant)Instant.ofEpochMilli(expectedLastCommitTimestamp + 1L)));
        db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedLastTransactionId, (long)RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId());
    }

    @Test
    void recoverDatabaseWithDatePredicateLowerToLastAvailable() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        MetadataProvider metaDataStore = RecoveryIT.getMetadataProvider(db);
        long expectedLastCommitTimestamp = metaDataStore.getLastCommittedTransaction().commitTimestamp();
        long expectedLastCommitted = metaDataStore.getLastCommittedTransactionId();
        this.fakeClock.forward(4L, TimeUnit.MINUTES);
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        long originalLastCommitted = metaDataStore.getLastCommittedTransactionId();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase(RecoveryCriteria.until((Instant)Instant.ofEpochMilli(expectedLastCommitTimestamp + 1L)));
        db = this.createDatabase();
        long postRecoveryLastCommittedTxId = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedLastCommitted, (long)postRecoveryLastCommittedTxId);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)originalLastCommitted, (long)postRecoveryLastCommittedTxId);
    }

    @Test
    void recoverDatabaseWithIdPredicateWithNothingAfterLastCheckpoint() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        DatabaseLayout layout = db.databaseLayout();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        long originalLastCommitted = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        ((CheckPointerImpl)db.getDependencyResolver().resolveDependency(CheckPointerImpl.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase(RecoveryCriteria.until((long)(originalLastCommitted + 1L)));
        db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)originalLastCommitted, (long)RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId());
    }

    @Test
    void earlyRecoveryTerminationOnTxIdCriteriaShouldPrintReason() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        DatabaseLayout layout = db.databaseLayout();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        long originalLastCommitted = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        long restoreUntilTxId = originalLastCommitted - 4L;
        this.recoverDatabase(RecoveryCriteria.until((long)restoreUntilTxId));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Partial database recovery based on provided criteria: transaction id should be < " + restoreUntilTxId + ". Last replayed transaction: transaction id: " + (restoreUntilTxId - 1L) + ", time 1970-01-01 00:00:10.000+0000."});
        db = this.createDatabase();
        org.junit.jupiter.api.Assertions.assertEquals((long)(restoreUntilTxId - 1L), (long)RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId());
    }

    @Test
    void earlyRecoveryTerminationOnTxDateCriteriaShouldPrintReason() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DatabaseLayout layout = db.databaseLayout();
        MetadataProvider metaDataStore = RecoveryIT.getMetadataProvider(db);
        long expectedLastCommitTimestamp = metaDataStore.getLastCommittedTransaction().commitTimestamp();
        long expectedLastCommitted = metaDataStore.getLastCommittedTransactionId();
        this.fakeClock.forward(10L, TimeUnit.MINUTES);
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        long originalLastCommitted = metaDataStore.getLastCommittedTransactionId();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        this.recoverDatabase(RecoveryCriteria.until((Instant)Instant.ofEpochMilli(expectedLastCommitTimestamp + 1L)));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Partial database recovery based on provided criteria: transaction date should be before 1970-01-01 00:00:10.001+0000. Last replayed transaction: transaction id: " + expectedLastCommitted + ", time 1970-01-01 00:00:10.000+0000."});
        db = this.createDatabase();
        long postRecoveryLastCommittedTxId = RecoveryIT.getMetadataProvider(db).getLastCommittedTransactionId();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedLastCommitted, (long)postRecoveryLastCommittedTxId);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)originalLastCommitted, (long)postRecoveryLastCommittedTxId);
    }

    @Test
    void failToReadTransactionOnIncorrectCriteria() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        DatabaseLayout layout = db.databaseLayout();
        this.managementService.shutdown();
        this.removeFileWithCheckpoint();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        Assertions.assertThatThrownBy(() -> this.recoverDatabase(RecoveryCriteria.until((long)2L))).hasCauseInstanceOf(RecoveryPredicateException.class).getCause().hasMessageContaining("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and fail to read transaction before checkpoint. Recovery criteria: transaction id should be < 2.");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
    }

    @Test
    void transactionBeforeCheckpointNotMatchingExpectedCriteria() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        DatabaseLayout layout = db.databaseLayout();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        DependencyResolver deps = db.getDependencyResolver();
        ((CheckPointerImpl)deps.resolveDependency(CheckPointerImpl.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        long lastTxId = ((TransactionIdStore)deps.resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        Assertions.assertThatThrownBy(() -> this.recoverDatabase(RecoveryCriteria.until((long)1L))).hasCauseInstanceOf(RecoveryPredicateException.class).getCause().hasMessageContaining("Partial recovery criteria can't be satisfied. Transaction after and before checkpoint does not satisfy provided recovery criteria. Observed transaction id: " + lastTxId + ", recovery criteria: transaction id should be < 1.");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
    }

    @Test
    void useProvidedLogFilesLogTailInfo() throws Exception {
        GraphDatabaseAPI db = this.createDatabase();
        DatabaseLayout layout = db.databaseLayout();
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        ((CheckPointerImpl)db.getDependencyResolver().resolveDependency(CheckPointerImpl.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        RecoveryIT.generateSomeData((GraphDatabaseService)db);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(layout));
        LogTailMetadata spiedLogTail = (LogTailMetadata)Mockito.spy((Object)this.buildLogFiles().getTailMetadata());
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)Config.defaults(), (DatabaseLayout)this.databaseLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)this.logProvider, (LogTailMetadata)spiedLogTail).clock((Clock)this.fakeClock));
        ((LogTailMetadata)Mockito.verify((Object)spiedLogTail, (VerificationMode)Mockito.times((int)1))).getLastTransactionLogPosition();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(layout));
    }

    private void prepareEmptyZeroedLogFile(Path victimFilePath) throws IOException {
        this.fileSystem.deleteFileOrThrow(victimFilePath);
        NativeAccess nativeAccess = NativeAccessProvider.getNativeAccess();
        try (StoreFileChannel storeChannel = this.fileSystem.open(victimFilePath, Set.of(StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));){
            int fileDescriptor = storeChannel.getFileDescriptor();
            nativeAccess.tryPreallocateSpace(fileDescriptor, ByteUnit.mebiBytes((long)1L));
        }
    }

    private void prepareCorruptedLogFile(Path victimFilePath) throws IOException {
        this.fileSystem.deleteFileOrThrow(victimFilePath);
        byte corruptionSource = (byte)(ThreadLocalRandom.current().nextBoolean() ? 7 : -7);
        try (StoreFileChannel storeChannel = this.fileSystem.open(victimFilePath, Set.of(StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));){
            storeChannel.writeAll(ByteBuffer.wrap(new byte[LogFormat.BIGGEST_HEADER]));
            storeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, corruptionSource, 0}));
        }
    }

    private void removeLastKbFromLogFile(Path victimFilePath, LogPosition logPosition) throws IOException {
        try (StoreFileChannel storeChannel = this.fileSystem.open(victimFilePath, Set.of(StandardOpenOption.WRITE));){
            long newSize = storeChannel.size() - ByteUnit.kibiBytes((long)1L);
            Assertions.assertThat((long)newSize).isGreaterThan(logPosition.getByteOffset());
            storeChannel.truncate(newSize);
        }
    }

    private void prepareEmptyLogFile(Path victimFilePath) throws IOException {
        this.fileSystem.deleteFileOrThrow(victimFilePath);
        StoreFileChannel storeChannel = this.fileSystem.open(victimFilePath, Set.of(StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));
        if (storeChannel != null) {
            storeChannel.close();
        }
    }

    private boolean idGeneratorIsDirty(Path path, ImmutableSet<OpenOption> openOptions) throws IOException {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fileSystem, RecoveryCleanupWorkCollector.immediate(), PageCacheTracer.NULL, "my db");
        try (IdGenerator idGenerator = idGeneratorFactory.open(this.pageCache, path, TEST_NODE_TYPE, () -> 0L, 10000L, true, Config.defaults(), CONTEXT_FACTORY, openOptions, IdSlotDistribution.SINGLE_IDS);){
            MutableBoolean dirtyOnStartup = new MutableBoolean();
            InvocationHandler invocationHandler = (proxy, method, args) -> {
                if (method.getName().equals("dirtyOnStartup")) {
                    dirtyOnStartup.setTrue();
                }
                return null;
            };
            ReporterFactory reporterFactory = new ReporterFactory(invocationHandler);
            idGenerator.consistencyCheck(reporterFactory, CursorContextFactory.NULL_CONTEXT_FACTORY, Runtime.getRuntime().availableProcessors());
            boolean bl = dirtyOnStartup.booleanValue();
            return bl;
        }
    }

    private static void awaitIndexesOnline(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            transaction.commit();
        }
    }

    private static void createSingleNode(GraphDatabaseService service) {
        try (Transaction transaction = service.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
    }

    private void startStopDatabase() {
        GraphDatabaseAPI db = this.createDatabase();
        db.beginTx().close();
        this.managementService.shutdown();
    }

    private void recoverDatabase() throws Exception {
        this.recoverDatabase(DatabaseTracers.EMPTY, RecoveryCriteria.ALL);
    }

    private void recoverDatabase(DatabaseTracers tracers) throws Exception {
        this.recoverDatabase(tracers, RecoveryCriteria.ALL);
    }

    private void recoverDatabase(RecoveryCriteria recoveryCriteria) throws Exception {
        this.recoverDatabase(DatabaseTracers.EMPTY, recoveryCriteria);
    }

    private void recoverDatabase(Iterable<ExtensionFactory<?>> extensionFactories) throws Exception {
        this.recoverDatabase(DatabaseTracers.EMPTY, RecoveryCriteria.ALL, extensionFactories);
    }

    void additionalConfiguration(Config config) {
        config.set(GraphDatabaseSettings.fail_on_missing_files, (Object)false);
    }

    TestDatabaseManagementServiceBuilder additionalConfiguration(TestDatabaseManagementServiceBuilder builder) {
        return builder;
    }

    private void recoverDatabase(DatabaseTracers databaseTracers, RecoveryCriteria recoveryCriteria) throws Exception {
        this.recoverDatabase(databaseTracers, recoveryCriteria, Iterables.cast((Iterable)Services.loadAll(ExtensionFactory.class)));
    }

    private void recoverDatabase(DatabaseTracers databaseTracers, RecoveryCriteria recoveryCriteria, Iterable<ExtensionFactory<?>> extensionFactories) throws Exception {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)new LoggingLogFileMonitor(this.logProvider.getLog(this.getClass())), new String[0]);
        Config config = Config.newBuilder().build();
        this.additionalConfiguration(config);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout, config, databaseTracers));
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseTracers)databaseTracers, (Config)config, (DatabaseLayout)this.databaseLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)this.logProvider, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).recoveryPredicate(recoveryCriteria.toPredicate()).monitors(monitors).extensionFactories(extensionFactories).startupChecker(RecoveryStartupChecker.EMPTY_CHECKER).clock((Clock)this.fakeClock));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout, config));
    }

    private boolean isRecoveryRequired(DatabaseLayout layout) throws Exception {
        Config config = Config.newBuilder().build();
        this.additionalConfiguration(config);
        return this.isRecoveryRequired(layout, config);
    }

    private boolean isRecoveryRequired(DatabaseLayout layout, Config config) throws Exception {
        return Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseLayout)layout, (Config)config, Optional.empty(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, (DatabaseTracers)DatabaseTracers.EMPTY);
    }

    private boolean isRecoveryRequired(DatabaseLayout layout, Config config, DatabaseTracers tracers) throws Exception {
        return Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseLayout)layout, (Config)config, Optional.empty(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, (DatabaseTracers)tracers);
    }

    private int countCheckPointsInTransactionLogs() throws IOException {
        LogFiles logFiles = this.buildLogFiles();
        List checkpoints = logFiles.getCheckpointFile().reachableCheckpoints();
        return checkpoints.size();
    }

    private LogFiles buildLogFiles() throws IOException {
        return this.buildLogFiles(DatabaseTracers.EMPTY);
    }

    private LogFiles buildLogFiles(DatabaseTracers databaseTracers) throws IOException {
        return LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout, null).commandReaderFactory()).withDatabaseTracers(databaseTracers).build();
    }

    private void removeTransactionLogs() throws IOException {
        LogFiles logFiles = this.buildLogFiles();
        for (Path logFile : this.fileSystem.listFiles(logFiles.logFilesDirectory())) {
            this.fileSystem.deleteFile(logFile);
        }
    }

    private void removeFileWithCheckpoint() throws IOException {
        LogFiles logFiles = this.buildLogFiles();
        this.fileSystem.deleteFileOrThrow(logFiles.getCheckpointFile().getCurrentFile());
    }

    private int countTransactionLogFiles() throws IOException {
        LogFiles logFiles = this.buildLogFiles();
        return logFiles.logFiles().length;
    }

    private int countCheckpointFiles() throws IOException {
        LogFiles logFiles = this.buildLogFiles();
        return logFiles.getCheckpointFile().getDetachedCheckpointFiles().length;
    }

    private static void generateSomeData(GraphDatabaseService database) {
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node1 = transaction.createNode();
                Node node2 = transaction.createNode();
                node1.createRelationshipTo(node2, RelationshipType.withName((String)("Type" + i)));
                node2.setProperty("a", (Object)RandomStringUtils.randomAlphanumeric((int)TEN_KB));
                transaction.commit();
                continue;
            }
        }
    }

    private GraphDatabaseAPI createDatabase() {
        return this.createDatabase((Long)GraphDatabaseSettings.logical_log_rotation_threshold.defaultValue());
    }

    protected GraphDatabaseAPI createDatabase(long logThreshold) {
        this.createBuilder(logThreshold);
        this.managementService = this.builder.build();
        return (GraphDatabaseAPI)this.managementService.database(this.databaseLayout.getDatabaseName());
    }

    private void createBuilder(long logThreshold) {
        if (this.builder == null) {
            this.logProvider = new AssertableLogProvider();
            this.fakeClock = Clocks.fakeClock((long)10L, (TimeUnit)TimeUnit.SECONDS);
            this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setClock((SystemNanoClock)this.fakeClock).setInternalLogProvider((InternalLogProvider)this.logProvider).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)logThreshold);
            this.builder = this.additionalConfiguration(this.builder);
        }
    }

    private void startStopDatabaseWithForcedRecovery() {
        DatabaseManagementService forcedRecoveryManagementService = this.forcedRecoveryManagement();
        forcedRecoveryManagementService.shutdown();
    }

    private DatabaseManagementService forcedRecoveryManagement() {
        TestDatabaseManagementServiceBuilder serviceBuilder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false);
        return this.additionalConfiguration(serviceBuilder).build();
    }

    private DatabaseManagementService dbmsWithFailOnCorruptedFalse() {
        TestDatabaseManagementServiceBuilder serviceBuilder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false).setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false);
        return this.additionalConfiguration(serviceBuilder).build();
    }

    private static MetadataProvider getMetadataProvider(GraphDatabaseAPI db) {
        return (MetadataProvider)db.getDependencyResolver().resolveDependency(MetadataProvider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRecoveryMissingLogs() throws IOException {
        GraphDatabaseAPI restartedDatabase = this.createDatabase();
        try {
            LogFiles logFiles = (LogFiles)restartedDatabase.getDependencyResolver().resolveDependency(LogFiles.class);
            CheckpointInfo checkpointInfo = (CheckpointInfo)logFiles.getCheckpointFile().getReachableDetachedCheckpoints().get(0);
            Assertions.assertThat((String)checkpointInfo.reason()).contains(new CharSequence[]{"missing logs"});
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private void assumeRecordStorageEngine(GraphDatabaseAPI database) {
        StorageEngine storageEngine = (StorageEngine)database.getDependencyResolver().resolveDependency(StorageEngine.class);
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)(storageEngine instanceof RecordStorageEngine)).as("Requires the use of testAccessNeoStores, which is record format specific", new Object[0])).isTrue();
    }

    private void appendBytesToLastLogFile(Path logFilePath, LogPosition logPosition, byte[] bytesToWrite) throws IOException {
        try (StoreFileChannel storeChannel = this.fileSystem.write(logFilePath);){
            storeChannel.position(logPosition.getByteOffset());
            storeChannel.writeAll(ByteBuffer.wrap(bytesToWrite));
        }
    }

    private static Path getIdFile(DatabaseLayout layout) {
        return RecoveryIT.getFirstSortedOnName(layout.idFiles());
    }

    private static Path getStoreFile(DatabaseLayout layout) {
        HashSet<Path> files = new HashSet<Path>(layout.storeFiles());
        files.remove(layout.pathForStore(CommonDatabaseStores.METADATA));
        files.remove(layout.pathForStore(CommonDatabaseStores.INDEX_STATISTICS));
        return RecoveryIT.getFirstSortedOnName(files);
    }

    private static Path getFirstSortedOnName(Set<Path> path) {
        return path.stream().max(Comparator.comparing(p -> p.getFileName().toString())).orElseThrow();
    }

    private static class CheckpointTracer
    extends DefaultTracer {
        private final AtomicInteger openCounter = new AtomicInteger();

        private CheckpointTracer() {
            super(PageCacheTracer.NULL);
        }

        public void openLogFile(Path filePath) {
            if (filePath.getFileName().toString().contains("checkpoint")) {
                this.openCounter.incrementAndGet();
            }
            super.openLogFile(filePath);
        }

        public int getCheckpointOpenCounter() {
            return this.openCounter.get();
        }
    }

    @RecoveryExtension
    private class TestRecoveryExtension
    extends ExtensionFactory<Dependencies> {
        private final int expectedCheckpointsOnStop;
        boolean stopped;

        TestRecoveryExtension(int expectedCheckpointsOnStop) {
            super(ExtensionType.DATABASE, "testRecoveryExtension");
            this.stopped = false;
            this.expectedCheckpointsOnStop = expectedCheckpointsOnStop;
        }

        public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
            return LifecycleAdapter.onStop(() -> {
                this.stopped = true;
                Assertions.assertThat((int)RecoveryIT.this.countCheckPointsInTransactionLogs()).isEqualTo(this.expectedCheckpointsOnStop);
            });
        }

        static interface Dependencies {
        }
    }

    private static class GlobalGuardConsumerTestExtensionFactory
    extends ExtensionFactory<Dependencies> {
        private GlobalGuardConsumer providedConsumer;

        GlobalGuardConsumerTestExtensionFactory() {
            super("globalGuardConsumer");
        }

        public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
            this.providedConsumer = new GlobalGuardConsumer(dependencies);
            return this.providedConsumer;
        }

        public GlobalGuardConsumer getProvidedGuardConsumer() {
            return this.providedConsumer;
        }
    }

    private static class GlobalGuardConsumer
    extends LifecycleAdapter {
        private final CompositeDatabaseAvailabilityGuard globalGuard;

        GlobalGuardConsumer(Dependencies dependencies) {
            this.globalGuard = dependencies.globalGuard();
        }
    }

    static interface Dependencies {
        public CompositeDatabaseAvailabilityGuard globalGuard();
    }
}

