/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class IndexingStringQueryAcceptanceTest {
    private static final String KEY = "name";
    private String tokenName;
    @Inject
    private GraphDatabaseService db;

    @BeforeEach
    void setup(TestInfo testInfo) {
        this.tokenName = "TOKEN1-" + testInfo.getDisplayName();
    }

    @ParameterizedTest(name="shouldSupportIndexSeek using {0} match with {1} index on {2}")
    @MethodSource(value={"data"})
    void shouldSupportIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(entityControl, withIndex);
        IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.nonMatching);
        MutableLongSet expected = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.matching);
        try (Transaction tx = this.db.beginTx();){
            found = entityControl.findEntities(tx, this.tokenName, KEY, dataSet.template, dataSet.searchMode);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldIncludeEntitiesCreatedInSameTxInIndexSeek using {0} match with {1} index on {2}")
    @MethodSource(value={"data"})
    void shouldIncludeEntitiesCreatedInSameTxInIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(entityControl, withIndex);
        IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.nonMatching[0], dataSet.nonMatching[1]);
        MutableLongSet expected = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.matching[0], dataSet.matching[1]);
        try (Transaction tx = this.db.beginTx();){
            expected.add(entityControl.createEntity(tx, this.tokenName, MapUtil.map((Object[])new Object[]{KEY, dataSet.matching[2]})));
            entityControl.createEntity(tx, this.tokenName, MapUtil.map((Object[])new Object[]{KEY, dataSet.nonMatching[2]}));
            found = entityControl.findEntities(tx, this.tokenName, KEY, dataSet.template, dataSet.searchMode);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldNotIncludeEntitiesDeletedInSameTxInIndexSeek using {0} match with {1} index on {2}")
    @MethodSource(value={"data"})
    void shouldNotIncludeEntitiesDeletedInSameTxInIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(entityControl, withIndex);
        IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.nonMatching[0]);
        MutableLongSet toDelete = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.matching[0], dataSet.nonMatching[1], dataSet.matching[1], dataSet.nonMatching[2]);
        MutableLongSet expected = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.matching[2]);
        try (Transaction tx = this.db.beginTx();){
            toDelete.each((LongProcedure & Serializable)id -> entityControl.deleteEntity(tx, id));
            found = entityControl.findEntities(tx, this.tokenName, KEY, dataSet.template, dataSet.searchMode);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldConsiderEntitiesChangedInSameTxInIndexSeek using {0} match with {1} index on {2}")
    @MethodSource(value={"data"})
    void shouldConsiderEntitiesChangedInSameTxInIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(entityControl, withIndex);
        IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.nonMatching[0]);
        MutableLongSet toChangeToMatch = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.nonMatching[1]);
        MutableLongSet toChangeToNotMatch = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.matching[0]);
        MutableLongSet expected = IndexingStringQueryAcceptanceTest.createEntities(entityControl, this.db, this.tokenName, dataSet.matching[1]);
        try (Transaction tx = this.db.beginTx();){
            toChangeToMatch.each((LongProcedure & Serializable)id -> {
                entityControl.setProperty(tx, id, KEY, dataSet.matching[2]);
                expected.add(id);
            });
            toChangeToNotMatch.each((LongProcedure & Serializable)id -> {
                entityControl.setProperty(tx, id, KEY, dataSet.nonMatching[2]);
                expected.remove(id);
            });
            found = entityControl.findEntities(tx, this.tokenName, KEY, dataSet.template, dataSet.searchMode);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    void createIndex(EntityControl entityControl, IndexingMode withIndex) {
        switch (withIndex) {
            case NONE: {
                try (Transaction tx = this.db.beginTx();){
                    tx.schema().getIndexes().forEach(IndexDefinition::drop);
                    tx.commit();
                    break;
                }
            }
            case PROPERTY_RANGE: {
                this.createAndWaitForIndex(entityControl, IndexType.RANGE);
                break;
            }
        }
    }

    private void createAndWaitForIndex(EntityControl entityControl, IndexType indexType) {
        try (Transaction tx = this.db.beginTx();){
            entityControl.createIndex(tx, this.tokenName, KEY, indexType);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static MutableLongSet createEntities(EntityControl entityControl, GraphDatabaseService db, String token, String ... propertyValues) {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            for (String value : propertyValues) {
                expected.add(entityControl.createEntity(tx, token, MapUtil.map((Object[])new Object[]{KEY, value})));
            }
            tx.commit();
        }
        return expected;
    }

    private static Stream<Arguments> generate(DataSet[] dataSets, IndexingMode[] indexingModes, EntityControl[] entityControls) {
        Stream.Builder<Arguments> builder = Stream.builder();
        for (DataSet dataSet : dataSets) {
            for (IndexingMode indexingMode : indexingModes) {
                for (EntityControl entityControl : entityControls) {
                    builder.add(Arguments.arguments((Object[])new Object[]{dataSet, indexingMode, entityControl}));
                }
            }
        }
        return builder.build();
    }

    public static Stream<Arguments> data() {
        return IndexingStringQueryAcceptanceTest.generate(DataSet.values(), IndexingMode.values(), EntityTypes.values());
    }

    static interface EntityControl {
        public void createIndex(Transaction var1, String var2, String var3, IndexType var4);

        public long createEntity(Transaction var1, String var2, Map<String, Object> var3);

        public void deleteEntity(Transaction var1, long var2);

        public void setProperty(Transaction var1, long var2, String var4, String var5);

        public LongSet findEntities(Transaction var1, String var2, String var3, String var4, StringSearchMode var5);
    }

    static enum IndexingMode {
        NONE,
        TOKEN,
        PROPERTY_RANGE;

    }

    static enum DataSet {
        EXACT(StringSearchMode.EXACT, "Johan", (String[])ArrayUtil.array((Object[])new String[]{"Johan", "Johan", "Johan"}), (String[])ArrayUtil.array((Object[])new String[]{"Johanna", "Olivia", "InteJohan"})),
        PREFIX(StringSearchMode.PREFIX, "Olivia", (String[])ArrayUtil.array((Object[])new String[]{"Olivia", "Olivia2", "OliviaYtterbrink"}), (String[])ArrayUtil.array((Object[])new String[]{"Johan", "olivia", "InteOlivia"})),
        SUFFIX(StringSearchMode.SUFFIX, "sson", (String[])ArrayUtil.array((Object[])new String[]{"Jansson", "Hansson", "Svensson"}), (String[])ArrayUtil.array((Object[])new String[]{"Taverner", "Svensson-Averbuch", "Taylor"})),
        CONTAINS(StringSearchMode.CONTAINS, "oo", (String[])ArrayUtil.array((Object[])new String[]{"good", "fool", "fooooood"}), (String[])ArrayUtil.array((Object[])new String[]{"evil", "genius", "hungry"}));

        private final StringSearchMode searchMode;
        private final String template;
        private final String[] matching;
        private final String[] nonMatching;

        private DataSet(StringSearchMode searchMode, String template, String[] matching, String[] nonMatching) {
            this.searchMode = searchMode;
            this.template = template;
            this.matching = matching;
            this.nonMatching = nonMatching;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum EntityTypes implements EntityControl
    {
        NODE{

            @Override
            public void createIndex(Transaction tx, String token, String propertyName, IndexType indexType) {
                tx.schema().indexFor(Label.label((String)token)).withIndexType(indexType).on(propertyName).create();
            }

            @Override
            public long createEntity(Transaction tx, String token, Map<String, Object> properties) {
                Node node = tx.createNode(new Label[]{Label.label((String)token)});
                properties.forEach((arg_0, arg_1) -> ((Node)node).setProperty(arg_0, arg_1));
                return node.getId();
            }

            @Override
            public void deleteEntity(Transaction tx, long id) {
                tx.getNodeById(id).delete();
            }

            @Override
            public void setProperty(Transaction tx, long id, String key, String value) {
                tx.getNodeById(id).setProperty(key, (Object)value);
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, String propertyName, String template, StringSearchMode searchMode) {
                LongHashSet found = new LongHashSet();
                try (Stream nodes = tx.findNodes(Label.label((String)token), propertyName, template, searchMode).stream();){
                    nodes.mapToLong(Entity::getId).forEach(arg_0 -> ((MutableLongSet)found).add(arg_0));
                }
                return found;
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public void createIndex(Transaction tx, String token, String propertyName, IndexType indexType) {
                tx.schema().indexFor(RelationshipType.withName((String)token)).withIndexType(indexType).on(propertyName).create();
            }

            @Override
            public long createEntity(Transaction tx, String token, Map<String, Object> properties) {
                Node from = tx.createNode();
                Node to = tx.createNode();
                Relationship relationship = from.createRelationshipTo(to, RelationshipType.withName((String)token));
                properties.forEach((arg_0, arg_1) -> ((Relationship)relationship).setProperty(arg_0, arg_1));
                return relationship.getId();
            }

            @Override
            public void deleteEntity(Transaction tx, long id) {
                tx.getRelationshipById(id).delete();
            }

            @Override
            public void setProperty(Transaction tx, long id, String key, String value) {
                tx.getRelationshipById(id).setProperty(key, (Object)value);
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, String propertyName, String template, StringSearchMode searchMode) {
                LongHashSet found = new LongHashSet();
                try (Stream relationships = tx.findRelationships(RelationshipType.withName((String)token), propertyName, template, searchMode).stream();){
                    relationships.mapToLong(Entity::getId).forEach(arg_0 -> ((MutableLongSet)found).add(arg_0));
                }
                return found;
            }
        };

    }
}

