/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.storageengine.api.PropertySelection;

public class TestAccessMode
implements AccessMode {
    private final boolean allowRead;
    private final boolean allowReadAll;
    private final boolean allowWrite;
    private final boolean allowSchema;
    private final boolean allowLoad;

    public TestAccessMode(boolean allowRead, boolean allowReadAll, boolean allowWrite, boolean allowSchema, boolean allowLoad) {
        this.allowRead = allowRead;
        this.allowReadAll = allowReadAll;
        this.allowWrite = allowWrite;
        this.allowSchema = allowSchema;
        this.allowLoad = allowLoad;
    }

    public boolean allowsWrites() {
        return this.allowWrite;
    }

    public PermissionState allowsTokenCreates(PrivilegeAction action) {
        return PermissionState.fromAllowList((boolean)this.allowWrite);
    }

    public boolean allowsSchemaWrites() {
        return this.allowSchema;
    }

    public PermissionState allowsSchemaWrites(PrivilegeAction action) {
        return PermissionState.fromAllowList((boolean)this.allowSchema);
    }

    public boolean allowsShowIndex() {
        return this.allowSchema;
    }

    public boolean allowsShowConstraint() {
        return this.allowSchema;
    }

    public boolean allowsTraverseAllLabels() {
        return this.allowReadAll;
    }

    public boolean allowsTraverseAllNodesWithLabel(int label) {
        return this.allowReadAll;
    }

    public boolean disallowsTraverseLabel(int label) {
        return !this.allowRead;
    }

    public boolean allowsTraverseNode(int ... labels) {
        return this.allowRead;
    }

    public IntSet getTraverseSecurityProperties(int[] labels) {
        return IntSets.immutable.empty();
    }

    public boolean hasApplicableTraverseAllowPropertyRules(int label) {
        return this.allowRead;
    }

    public boolean allowsTraverseNodeWithPropertyRules(ReadSecurityPropertyProvider propertyProvider, int ... labels) {
        return this.allowRead;
    }

    public boolean hasTraversePropertyRules() {
        return false;
    }

    public boolean allowsTraverseAllRelTypes() {
        return this.allowReadAll;
    }

    public boolean allowsTraverseRelType(int relType) {
        return this.allowRead;
    }

    public boolean disallowsTraverseRelType(int relType) {
        return !this.allowRead;
    }

    public boolean allowsReadPropertyAllLabels(int propertyKey) {
        return this.allowReadAll;
    }

    public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
        return !this.allowReadAll;
    }

    public boolean allowsReadNodeProperties(Supplier<TokenSet> labels, int[] propertyKeys, ReadSecurityPropertyProvider propertyProvider) {
        return this.allowRead;
    }

    public boolean allowsReadNodeProperties(Supplier<TokenSet> labels, int[] propertyKeys) {
        return this.allowRead;
    }

    public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
        return this.allowRead;
    }

    public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey) {
        return this.allowRead;
    }

    public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
        return this.allowReadAll;
    }

    public boolean allowsReadRelationshipProperty(RelTypeSupplier relType, int propertyKey) {
        return this.allowRead;
    }

    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.allowRead;
    }

    public boolean hasPropertyReadRules() {
        return false;
    }

    public boolean hasPropertyReadRules(int ... propertyKeys) {
        return false;
    }

    public IntSet getReadSecurityProperties(int propertyKey) {
        return IntSets.immutable.empty();
    }

    public IntSet getAllReadSecurityProperties() {
        return IntSets.immutable.empty();
    }

    public PropertySelection getSecurityPropertySelection(PropertySelection selection) {
        return PropertySelection.NO_PROPERTIES;
    }

    public PermissionState allowsExecuteProcedure(int procedureId) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowExecuteAdminProcedures() {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState shouldBoostProcedure(int procedureId) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsExecuteFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState shouldBoostFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsExecuteAggregatingFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState shouldBoostAggregatingFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsShowSetting(String setting) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public boolean allowsSetLabel(int labelId) {
        return this.allowWrite;
    }

    public boolean allowsRemoveLabel(int labelId) {
        return this.allowWrite;
    }

    public boolean allowsCreateNode(int[] labelIds) {
        return this.allowWrite;
    }

    public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        return this.allowWrite;
    }

    public boolean allowsCreateRelationship(int relType) {
        return this.allowWrite;
    }

    public boolean allowsDeleteRelationship(int relType) {
        return this.allowWrite;
    }

    public boolean allowsSetProperty(Supplier<TokenSet> labels, int propertyKey) {
        return this.allowWrite;
    }

    public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
        return this.allowWrite;
    }

    public PermissionState allowsLoadAllData() {
        return PermissionState.fromAllowList((boolean)this.allowLoad);
    }

    public PermissionState allowsLoadUri(URI url, InetAddress inetAddress) {
        return PermissionState.fromAllowList((boolean)this.allowLoad);
    }

    public String name() {
        return "Test";
    }
}

