/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.annotations.documented.ReporterFactories;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class IndexAccessorCompatibility
extends PropertyIndexProviderCompatibilityTestSuite.Compatibility {
    IndexAccessor accessor;
    private final Map<Long, Value[]> committedValues = new HashMap<Long, Value[]>();

    IndexAccessorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @BeforeEach
    void before() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        IndexPopulator populator = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY);
        populator.create();
        populator.close(true, CursorContext.NULL_CONTEXT);
        this.accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY);
    }

    @AfterEach
    void after() {
        try {
            boolean consistent = this.accessor.consistencyCheck(ReporterFactories.throwingReporterFactory(), CursorContextFactory.NULL_CONTEXT_FACTORY, Runtime.getRuntime().availableProcessors());
            Assertions.assertThat((boolean)consistent).isTrue();
        }
        finally {
            this.accessor.drop();
            this.accessor.close();
        }
    }

    ValueType[] randomSetOfSupportedTypes() {
        Object[] supportedTypes = this.testSuite.supportedValueTypes();
        return (ValueType[])this.random.randomValues().selection(supportedTypes, 2, supportedTypes.length, false);
    }

    ValueType[] randomSetOfSupportedAndSortableTypes() {
        Object[] types = (ValueType[])RandomValues.excluding((Object[])this.testSuite.supportedValueTypes(), type -> switch (type) {
            case ValueType.STRING, ValueType.STRING_ARRAY -> true;
            default -> {
                switch (type.valueGroup) {
                    case GEOMETRY: 
                    case GEOMETRY_ARRAY: 
                    case DURATION: 
                    case DURATION_ARRAY: {
                        yield true;
                    }
                }
                yield false;
            }
        });
        return (ValueType[])this.random.randomValues().selection(types, 2, types.length, false);
    }

    protected List<Long> query(PropertyIndexQuery ... predicates) throws Exception {
        List<Long> list = this.queryNoSort(predicates);
        Collections.sort(list);
        return list;
    }

    protected List<Long> queryNoSort(PropertyIndexQuery ... predicates) throws Exception {
        try (ValueIndexReader reader = this.accessor.newValueReader(IndexUsageTracking.NO_USAGE_TRACKING);){
            SimpleEntityValueClient nodeValueClient = new SimpleEntityValueClient();
            reader.query((IndexProgressor.EntityValueClient)nodeValueClient, QueryContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), predicates);
            LinkedList<Long> list = new LinkedList<Long>();
            while (nodeValueClient.next()) {
                long entityId = nodeValueClient.reference;
                if (!this.passesFilter(entityId, predicates)) continue;
                list.add(entityId);
            }
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected AutoCloseable query(SimpleEntityValueClient client, IndexOrder order, PropertyIndexQuery ... predicates) throws Exception {
        ValueIndexReader reader = this.accessor.newValueReader(IndexUsageTracking.NO_USAGE_TRACKING);
        reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, IndexQueryConstraints.constrained((IndexOrder)order, (boolean)false), predicates);
        return reader;
    }

    List<Long> assertInOrder(IndexOrder order, PropertyIndexQuery ... predicates) throws Exception {
        List<Long> actualIds;
        if (order == IndexOrder.NONE) {
            actualIds = this.query(predicates);
        } else {
            SimpleEntityValueClient client = new SimpleEntityValueClient();
            try (AutoCloseable ignore = this.query(client, order, predicates);){
                actualIds = IndexAccessorCompatibility.assertClientReturnValuesInOrder(client, order);
            }
        }
        return actualIds;
    }

    static List<Long> assertClientReturnValuesInOrder(SimpleEntityValueClient client, IndexOrder order) {
        ArrayList<Long> seenIds = new ArrayList<Long>();
        Value[] prevValues = null;
        int count = 0;
        while (client.next()) {
            ++count;
            seenIds.add(client.reference);
            Value[] values = client.values;
            if (order == IndexOrder.ASCENDING) {
                IndexAccessorCompatibility.assertLessThanOrEqualTo(prevValues, values);
            } else if (order == IndexOrder.DESCENDING) {
                IndexAccessorCompatibility.assertLessThanOrEqualTo(values, prevValues);
            } else {
                org.junit.jupiter.api.Assertions.fail((String)("Unexpected order " + order + " (count = " + count + ")"));
            }
            prevValues = values;
        }
        return seenIds;
    }

    private static void assertLessThanOrEqualTo(Value[] o1, Value[] o2) {
        if (o1 == null || o2 == null) {
            return;
        }
        int length = Math.min(o1.length, o2.length);
        for (int i = 0; i < length; ++i) {
            int compare = Values.COMPARATOR.compare(o1[i], o2[i]);
            ((AbstractIntegerAssert)Assertions.assertThat((int)compare).as("expected less than or equal to but was " + Arrays.toString(o1) + " and " + Arrays.toString(o2), new Object[0])).isLessThanOrEqualTo(0);
            if (compare == 0) continue;
            return;
        }
    }

    private boolean passesFilter(long entityId, PropertyIndexQuery[] predicates) {
        if (predicates.length == 1 && EnumSet.of(IndexQuery.IndexQueryType.ALL_ENTRIES, IndexQuery.IndexQueryType.EXISTS).contains(predicates[0].type())) {
            return true;
        }
        Value[] values = this.committedValues.get(entityId);
        for (int i = 0; i < values.length; ++i) {
            PropertyIndexQuery predicate = predicates[i];
            if (!EnumSet.of(ValueGroup.GEOMETRY, ValueGroup.GEOMETRY_ARRAY).contains(predicate.valueGroup()) && (predicate.valueGroup() != ValueGroup.NUMBER || this.testSuite.supportFullValuePrecisionForNumbers()) || predicates[i].acceptsValue(values[i])) continue;
            return false;
        }
        return true;
    }

    void updateAndCommit(Collection<ValueIndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);){
            block9: for (ValueIndexEntryUpdate<?> update : updates) {
                updater.process(update);
                switch (update.updateMode()) {
                    case ADDED: 
                    case CHANGED: {
                        this.committedValues.put(update.getEntityId(), update.values());
                        continue block9;
                    }
                    case REMOVED: {
                        this.committedValues.remove(update.getEntityId());
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Unknown update mode " + update.updateMode());
            }
        }
    }
}

