/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class IndexCRUDIT {
    private FileSystemAbstraction fs;
    private GraphDatabaseAPI db;
    private final IndexProvider mockedIndexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final ExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)"none", (IndexProvider)this.mockedIndexProvider);
    private final Label myLabel = Label.label((String)"MYLABEL");
    private DatabaseManagementService managementService;

    IndexCRUDIT() {
    }

    @Test
    void addingANodeWithPropertyShouldGetIndexed() throws Exception {
        String indexProperty = "indexProperty";
        GatheringIndexWriter writer = this.newWriter();
        IndexCRUDIT.createIndex(this.db, this.myLabel, indexProperty);
        int value1 = 12;
        String otherProperty = "otherProperty";
        int otherValue = 17;
        Node node = this.createNode(MapUtil.map((Object[])new Object[]{indexProperty, value1, otherProperty, otherValue}), this.myLabel);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            TokenRead tokenRead = ktx.tokenRead();
            int propertyKey1 = tokenRead.propertyKey(indexProperty);
            int label = tokenRead.nodeLabel(this.myLabel.name());
            LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{propertyKey1});
            Assertions.assertThat(writer.updatesCommitted).isEqualTo((Object)Iterators.asSet((Object[])new ValueIndexEntryUpdate[]{IndexEntryUpdate.add((long)node.getId(), () -> descriptor, (Value[])new Value[]{Values.of((Object)value1)})}));
            tx.commit();
        }
    }

    @Test
    void addingALabelToPreExistingNodeShouldGetIndexed() throws Exception {
        String indexProperty = "indexProperty";
        GatheringIndexWriter writer = this.newWriter();
        IndexCRUDIT.createIndex(this.db, this.myLabel, indexProperty);
        String otherProperty = "otherProperty";
        int value = 12;
        int otherValue = 17;
        Node node = this.createNode(MapUtil.map((Object[])new Object[]{indexProperty, value, otherProperty, otherValue}), new Label[0]);
        Assertions.assertThat((int)writer.updatesCommitted.size()).isEqualTo(0);
        try (Transaction tx = this.db.beginTx();){
            node = tx.getNodeById(node.getId());
            node.addLabel(this.myLabel);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            TokenRead tokenRead = ktx.tokenRead();
            int propertyKey1 = tokenRead.propertyKey(indexProperty);
            int label = tokenRead.nodeLabel(this.myLabel.name());
            LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{propertyKey1});
            Assertions.assertThat(writer.updatesCommitted).isEqualTo((Object)Iterators.asSet((Object[])new ValueIndexEntryUpdate[]{IndexEntryUpdate.add((long)node.getId(), () -> descriptor, (Value[])new Value[]{Values.of((Object)value)})}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private Node createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(labels);
            for (Map.Entry<String, Object> prop : properties.entrySet()) {
                node.setProperty(prop.getKey(), prop.getValue());
            }
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    @BeforeEach
    void before() {
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.getMinimumRequiredVersion()).thenReturn((Object)KernelVersion.EARLIEST);
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class), (PageCacheTracer)ArgumentMatchers.any(), (StorageEngineFactory)ArgumentMatchers.any(), (CursorContextFactory)ArgumentMatchers.any())).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Mockito.when((Object)this.mockedIndexProvider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).then(inv -> inv.getArgument(0));
        Mockito.when((Object)this.mockedIndexProvider.getIndexType()).thenReturn((Object)IndexType.LOOKUP);
        Mockito.when((Object)this.mockedIndexProvider.validatePrototype((IndexPrototype)ArgumentMatchers.any(IndexPrototype.class))).thenAnswer(i -> i.getArguments()[0]);
        this.managementService = new TestDatabaseManagementServiceBuilder().setFileSystem(this.fs).addExtension(this.mockedIndexProviderFactory).noOpSystemGraphInitializer().impermanent().build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private GatheringIndexWriter newWriter() throws IOException {
        GatheringIndexWriter writer = new GatheringIndexWriter();
        Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)writer);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)writer);
        return writer;
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    private static void createIndex(GraphDatabaseAPI db, Label label, String property) throws KernelException {
        try (TransactionImpl tx = (TransactionImpl)db.beginTx();){
            IndexingTestUtil.createNodePropIndexWithSpecifiedProvider(tx, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, label, property);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static class GatheringIndexWriter
    extends IndexAccessor.Adapter
    implements IndexPopulator {
        private final Set<IndexEntryUpdate<?>> updatesCommitted = new HashSet();
        private final Map<Object, Set<Long>> indexSamples = new HashMap<Object, Set<Long>>();

        private GatheringIndexWriter() {
        }

        public void create() {
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
            this.updatesCommitted.addAll(updates);
        }

        public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
            return this.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
            return new CollectingIndexUpdater(this.updatesCommitted::addAll);
        }

        public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        }

        public void markAsFailed(String failure) {
        }

        public void includeSample(IndexEntryUpdate<?> update) {
            this.addValueToSample(update.getEntityId(), ((ValueIndexEntryUpdate)update).values()[0]);
        }

        public IndexSample sample(CursorContext cursorContext) {
            long indexSize = 0L;
            for (Set<Long> nodeIds : this.indexSamples.values()) {
                indexSize += (long)nodeIds.size();
            }
            return new IndexSample(indexSize, (long)this.indexSamples.size(), indexSize);
        }

        private void addValueToSample(long nodeId, Object propertyValue) {
            Set nodeIds = this.indexSamples.computeIfAbsent(propertyValue, k -> new HashSet());
            nodeIds.add(nodeId);
        }
    }
}

