/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

class ProceduresKernelIT
extends KernelIntegrationTest {
    private static final QualifiedName PROC = new QualifiedName("example", "exampleProc");
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((QualifiedName)PROC).supportedCypherScopes(new CypherScope[]{CypherScope.CYPHER_5}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build();
    private final ProcedureSignature futureSignature = ProcedureSignature.procedureSignature((QualifiedName)PROC).supportedCypherScopes(new CypherScope[]{CypherScope.CYPHER_FUTURE}).in("firstName", (Neo4jTypes.AnyType)Neo4jTypes.NTString).in("lastName", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build();
    private final CallableProcedure procedure = ProceduresKernelIT.procedure(this.signature);
    private final CallableProcedure futureProcedure = ProceduresKernelIT.procedure(this.futureSignature);

    ProceduresKernelIT() {
    }

    @Test
    void shouldGetProcedureByName() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        ProcedureSignature found = this.procs().procedureGet(PROC, CypherScope.CYPHER_5).signature();
        Assertions.assertThat((Object)found).isEqualTo((Object)this.signature);
        this.commit();
    }

    @Test
    void shouldGetBuiltInProcedureByName() throws Throwable {
        QualifiedName qn = new QualifiedName("db", "labels");
        ProcedureSignature found = this.procs().procedureGet(qn, CypherScope.CYPHER_5).signature();
        Assertions.assertThat((Object)found).isEqualTo((Object)ProcedureSignature.procedureSignature((QualifiedName)qn).out("label", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build());
        this.commit();
    }

    @Test
    void shouldGetAllProcedures() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        QualifiedName proc2 = new QualifiedName("example", "exampleProc2");
        QualifiedName proc3 = new QualifiedName("example", "exampleProc3");
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((QualifiedName)proc2).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((QualifiedName)proc3).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        List signatures = this.newTransaction().procedures().proceduresGetAll(CypherScope.CYPHER_5).toList();
        Assertions.assertThat(signatures).contains((Object[])new ProcedureSignature[]{this.procedure.signature(), ProcedureSignature.procedureSignature((QualifiedName)proc2).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build(), ProcedureSignature.procedureSignature((QualifiedName)proc3).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()});
        this.commit();
    }

    @Test
    void shouldRefuseToRegisterNonVoidProcedureWithoutOutputs() throws ProcedureException {
        ProcedureException e = (ProcedureException)org.junit.jupiter.api.Assertions.assertThrows(ProcedureException.class, () -> this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName("example", "exampleProc2")).build())));
        Assertions.assertThat((String)e.getMessage()).isEqualTo("Procedures with zero output fields must be declared as VOID");
    }

    @Test
    void shouldCallReadOnlyProcedure() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator found = procs.procedureCallRead(procs.procedureGet(PROC, CypherScope.CYPHER_5).id(), new AnyValue[]{Values.longValue((long)1337L)}, ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)found)).contains((Object[])new AnyValue[][]{{Values.longValue((long)1337L)}});
        }
        this.commit();
    }

    @Test
    void registeredProcedureShouldGetRead() throws Throwable {
        this.internalKernel().registerProcedure((CallableProcedure)new CallableProcedure.BasicProcedure(this.signature){

            public ResourceRawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
                return ResourceRawIterator.of((Object[])new AnyValue[][]{{Values.stringValue((String)ctx.kernelTransaction().dataRead().toString())}});
            }
        });
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.signature.name(), CypherScope.CYPHER_5).id(), new AnyValue[]{Values.EMPTY_STRING}, ProcedureCallContext.EMPTY);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)((AnyValue[])Iterators.asList((RawIterator)stream).get(0))[0]);
        }
        this.commit();
    }

    @Test
    void shouldGetProceduresWithRightScope() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        this.internalKernel().registerProcedure(this.futureProcedure);
        List signatures = this.newTransaction().procedures().proceduresGetAll(CypherScope.CYPHER_5).toList();
        Assertions.assertThat(signatures).contains((Object[])new ProcedureSignature[]{this.procedure.signature()});
        this.commit();
    }

    private static CallableProcedure procedure(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public ResourceRawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) {
                return ResourceRawIterator.of((Object[])new AnyValue[][]{input});
            }
        };
    }
}

