/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ImpermanentDbmsExtension
public abstract class EntityTest {
    @Inject
    static GraphDatabaseAPI db;

    protected abstract long createEntity(Transaction var1);

    protected abstract Entity lookupEntity(Transaction var1, long var2);

    @Test
    void shouldListAllProperties() {
        Map listedProperties;
        long containerId;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("boolean", true);
        properties.put("short_string", "abc");
        properties.put("string", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        properties.put("long", Long.MAX_VALUE);
        properties.put("short_array", new long[]{1L, 2L, 3L, 4L});
        properties.put("array", new long[]{0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL, 0x7FFFFFFFFFFFFFFCL, 0x7FFFFFFFFFFFFFFBL, 0x7FFFFFFFFFFFFFFAL, 0x7FFFFFFFFFFFFFF9L, 0x7FFFFFFFFFFFFFF8L, 0x7FFFFFFFFFFFFFF7L, 0x7FFFFFFFFFFFFFF6L, 0x7FFFFFFFFFFFFFF5L, 0x7FFFFFFFFFFFFFF4L});
        try (Transaction tx = db.beginTx();){
            containerId = this.createEntity(tx);
            Entity container = this.lookupEntity(tx, containerId);
            for (Map.Entry entry : properties.entrySet()) {
                container.setProperty((String)entry.getKey(), entry.getValue());
            }
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            listedProperties = this.lookupEntity(tx, containerId).getAllProperties();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)properties.size(), (int)listedProperties.size());
        for (String key : properties.keySet()) {
            Assertions.assertThat(properties.get(key)).isEqualTo(listedProperties.get(key));
        }
    }

    static InternalTransaction mockedTransactionWithDepletedTokens() throws KernelException {
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransaction ktx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        TokenWrite tokenWrite = (TokenWrite)Mockito.mock(TokenWrite.class);
        Mockito.when((Object)ktx.tokenWrite()).thenReturn((Object)tokenWrite);
        Mockito.when((Object)tokenWrite.labelGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TokenCapacityExceededKernelException((Throwable)new Exception("Just some cause"), "Label")});
        Mockito.when((Object)tokenWrite.propertyKeyGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TokenCapacityExceededKernelException((Throwable)new Exception("Just some cause"), "PropertyKey")});
        Mockito.when((Object)tokenWrite.relationshipTypeGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TokenCapacityExceededKernelException((Throwable)new Exception("Just some cause"), "RelationshipType")});
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)ktx);
        return internalTransaction;
    }

    static InternalTransaction transactionWithTransientlyFailingTokenWrite() throws KernelException {
        KernelTransaction ktx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        TokenWrite tokenWrite = (TokenWrite)Mockito.mock(TokenWrite.class);
        Mockito.when((Object)ktx.tokenWrite()).thenReturn((Object)tokenWrite);
        TransactionFailureException transientFailure = new TransactionFailureException((Status)Status.Transaction.Outdated, (Throwable)new Exception("Just some cause"));
        ((TokenWrite)Mockito.doThrow((Throwable[])new Throwable[]{transientFailure}).when((Object)tokenWrite)).labelGetOrCreateForNames((String[])ArgumentMatchers.any(), (int[])ArgumentMatchers.any());
        Mockito.when((Object)tokenWrite.labelGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{transientFailure});
        Mockito.when((Object)tokenWrite.propertyKeyGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{transientFailure});
        Mockito.when((Object)tokenWrite.relationshipTypeGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{transientFailure});
        return new TransactionImpl((TokenHolders)Mockito.mock(TokenHolders.class), (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class), (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class), (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class), ktx, (ElementIdMapper)Mockito.mock(ElementIdMapper.class));
    }
}

