/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;

class TransactionTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    TransactionTest() {
    }

    @Test
    void shouldRollbackWhenTxIsNotSuccess() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
        }
        this.assertNoNode(nodeId);
    }

    @Test
    void shouldRollbackWhenTxIsFailed() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            tx.rollback();
        }
        this.assertNoNode(nodeId);
    }

    private void assertNoNode(long nodeId) throws TransactionFailureException {
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            tx.dataRead().singleNode(nodeId, cursor);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }
}

