/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class RestartIT {
    @Inject
    private TestDirectory testDir;

    RestartIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToReadExistingStoreOnRestart() throws IOException {
        this.testDir.cleanup();
        Path storeDir = this.testDir.absolutePath();
        DatabaseManagementService oldManagementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        oldManagementService.shutdown();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();
             ResourceIterable allNodes = tx.getAllNodes();){
            Assertions.assertThat((Iterable)allNodes).isEmpty();
        }
        finally {
            managementService.shutdown();
        }
    }
}

