/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;

public class WorkerContext<T extends AutoCloseable>
implements AutoCloseable {
    private final T cursor;
    private final ExecutionContext context;
    private final KernelTransaction owner;
    private final Statement statement;

    public WorkerContext(T cursor, ExecutionContext context, KernelTransaction owner, Statement statement) {
        this.cursor = cursor;
        this.context = context;
        this.owner = owner;
        this.statement = statement;
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.context, this.statement});
    }

    public T getCursor() {
        return this.cursor;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public KernelTransaction getTransaction() {
        return this.owner;
    }

    public void complete() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.cursor});
        this.context.complete();
    }
}

