/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
abstract class IndexProviderCompatabilityTestBase {
    @Inject
    private PageCache pageCache;
    @Inject
    RandomSupport random;
    @Inject
    FileSystemAbstraction fs;
    private TestDirectory testDirectory;
    private final IndexPrototype incompleteIndexPrototype;
    final IndexProviderCompatibilityTestSuite testSuite;
    private final JobScheduler jobScheduler;
    IndexProvider indexProvider;
    IndexDescriptor descriptor;
    TokenNameLookup tokenNameLookup;
    final IndexPopulator.PopulationWorkScheduler populationWorkScheduler;
    Config config;
    Path homePath;
    StorageEngineIndexingBehaviour storageEngineIndexingBehaviour;

    @BeforeEach
    void setup(TestInfo info) throws Exception {
        this.testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
        Class testClass = (Class)info.getTestClass().orElseThrow();
        String testName = ((Method)info.getTestMethod().orElseThrow()).getName().toLowerCase(Locale.ROOT);
        this.testDirectory.prepareDirectory(testClass, this.testSuite.getClass().getSimpleName());
        this.homePath = this.testDirectory.homePath(testName);
        boolean hasNodeBasedRelIndex = this.random.nextBoolean();
        this.storageEngineIndexingBehaviour = new TestStorageEngineIndexingBehaviour(hasNodeBasedRelIndex);
        Config.Builder configBuilder = Config.newBuilder();
        configBuilder.set(GraphDatabaseSettings.neo4j_home, (Object)this.homePath);
        this.testSuite.additionalConfig(configBuilder);
        this.additionalConfig(configBuilder);
        this.config = configBuilder.build();
        this.indexProvider = this.testSuite.createIndexProvider(this.pageCache, this.fs, this.homePath, this.config);
        this.descriptor = this.indexProvider.completeConfiguration(this.incompleteIndexPrototype.withName("index_17").materialise(17L), this.storageEngineIndexingBehaviour);
        this.jobScheduler.start();
    }

    @AfterEach
    void tearDown() throws Exception {
        if (this.jobScheduler != null) {
            this.jobScheduler.shutdown();
        }
        this.testDirectory.complete(false);
        this.testDirectory.close();
    }

    void additionalConfig(Config.Builder configBuilder) {
    }

    IndexProviderCompatabilityTestBase(IndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        this.testSuite = testSuite;
        this.incompleteIndexPrototype = prototype;
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return IndexProviderCompatabilityTestBase.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
            }
        };
        this.tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    }

    void withPopulator(IndexPopulator populator, ThrowingConsumer<IndexPopulator, Exception> runWithPopulator) throws Exception {
        this.withPopulator(populator, runWithPopulator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withPopulator(IndexPopulator populator, ThrowingConsumer<IndexPopulator, Exception> runWithPopulator, boolean closeSuccessfully) throws Exception {
        try {
            populator.create();
            runWithPopulator.accept((Object)populator);
            if (closeSuccessfully) {
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL_CONTEXT);
                this.testSuite.consistencyCheck(populator);
            }
        }
        finally {
            populator.close(closeSuccessfully, CursorContext.NULL_CONTEXT);
        }
    }

    private static class TestStorageEngineIndexingBehaviour
    implements StorageEngineIndexingBehaviour {
        private final boolean hasNodeBasedRelIndex;

        public TestStorageEngineIndexingBehaviour(boolean hasNodeBasedRelIndex) {
            this.hasNodeBasedRelIndex = hasNodeBasedRelIndex;
        }

        public boolean useNodeIdsInRelationshipTokenIndex() {
            return this.hasNodeBasedRelIndex;
        }

        public boolean requireCoordinationLocks() {
            return false;
        }

        public int nodesPerPage() {
            return 0;
        }

        public int relationshipsPerPage() {
            return 0;
        }
    }
}

