/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class BuiltInSchemaProceduresIT
extends KernelIntegrationTest {
    private final QualifiedName nodesProcedureName = new QualifiedName("db", "schema", "nodeTypeProperties");
    private final QualifiedName relsProcedureName = new QualifiedName("db", "schema", "relTypeProperties");

    BuiltInSchemaProceduresIT() {
    }

    @Test
    void testWeirdLabelName() throws Throwable {
        this.createNode(Collections.singletonList("This:is_a:label"), Collections.singletonList("color"), Collections.singletonList(Values.stringValue((String)"red")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`This:is_a:label`", Collections.singletonList("This:is_a:label"), "color", Collections.singletonList("String"), true)});
        }
    }

    @Test
    void testNodePropertiesRegardlessOfCreationOrder1() throws Throwable {
        this.createNode(Collections.singletonList("A"), Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createNode(Collections.singletonList("A"), Collections.singletonList("origin"), Collections.singletonList(Values.stringValue((String)"Kenya")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "color", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "size", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "origin", Collections.singletonList("String"), false)});
        }
    }

    @Test
    void testNodePropertiesRegardlessOfCreationOrder2() throws Throwable {
        this.createNode(Collections.singletonList("B"), Collections.singletonList("origin"), Collections.singletonList(Values.stringValue((String)"Kenya")));
        this.createNode(Collections.singletonList("B"), Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "color", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "size", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "origin", Collections.singletonList("String"), false)});
        }
    }

    @Test
    void testNodePropertiesRegardlessOfCreationOrder3() throws Throwable {
        this.createNode(Collections.singletonList("C"), Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createNode(Collections.singletonList("C"), Arrays.asList("origin", "active"), Arrays.asList(Values.stringValue((String)"Kenya"), Values.booleanValue((boolean)true)));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`C`", Collections.singletonList("C"), "color", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`C`", Collections.singletonList("C"), "size", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`C`", Collections.singletonList("C"), "origin", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`C`", Collections.singletonList("C"), "active", Collections.singletonList("Boolean"), false)});
        }
    }

    @Test
    void testRelsPropertiesRegardlessOfCreationOrder1() throws Throwable {
        long emptyNode = this.createEmptyNode();
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createRelationship(emptyNode, "R", emptyNode, Collections.singletonList("origin"), Collections.singletonList(Values.stringValue((String)"Kenya")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "color", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "size", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "origin", Collections.singletonList("String"), false)});
        }
    }

    @Test
    void testRelsPropertiesRegardlessOfCreationOrder2() throws Throwable {
        long emptyNode = this.createEmptyNode();
        this.createRelationship(emptyNode, "R", emptyNode, Collections.singletonList("origin"), Collections.singletonList(Values.stringValue((String)"Kenya")));
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "color", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "size", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "origin", Collections.singletonList("String"), false)});
        }
    }

    @Test
    void testRelsPropertiesRegardlessOfCreationOrder3() throws Throwable {
        long emptyNode = this.createEmptyNode();
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("origin", "active"), Arrays.asList(Values.stringValue((String)"Kenya"), Values.booleanValue((boolean)true)));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "color", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "size", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "origin", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "active", Collections.singletonList("Boolean"), false)});
        }
    }

    @Test
    void testNodesShouldNotDependOnOrderOfCreationWithOverlap() throws Throwable {
        this.createNode(Collections.singletonList("B"), Collections.singletonList("type"), Collections.singletonList(Values.stringValue((String)"B1")));
        this.createNode(Collections.singletonList("B"), Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B2"), Values.intValue((int)5)));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "type", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "size", Collections.singletonList("Integer"), false)});
        }
    }

    @Test
    void testNodesShouldNotDependOnOrderOfCreationWithOverlap2() throws Throwable {
        this.createNode(Collections.singletonList("B"), Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B2"), Values.intValue((int)5)));
        this.createNode(Collections.singletonList("B"), Collections.singletonList("type"), Collections.singletonList(Values.stringValue((String)"B1")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "type", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "size", Collections.singletonList("Integer"), false)});
        }
    }

    @Test
    void testRelsShouldNotDependOnOrderOfCreationWithOverlap() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "B", nodeId1, Collections.singletonList("type"), Collections.singletonList(Values.stringValue((String)"B1")));
        this.createRelationship(nodeId1, "B", nodeId1, Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B1"), Values.intValue((int)5)));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`B`", "type", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.relEntry(":`B`", "size", Collections.singletonList("Integer"), false)});
        }
    }

    @Test
    void testRelsShouldNotDependOnOrderOfCreationWithOverlap2() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "B", nodeId1, Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B1"), Values.intValue((int)5)));
        this.createRelationship(nodeId1, "B", nodeId1, Collections.singletonList("type"), Collections.singletonList(Values.stringValue((String)"B1")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`B`", "type", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.relEntry(":`B`", "size", Collections.singletonList("Integer"), false)});
        }
    }

    @Test
    void testWithAllDifferentNodes() throws Throwable {
        this.createNode(Arrays.asList("A", "B"), Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12)));
        this.createNode(Collections.singletonList("B"), Collections.singletonList("prop1"), Collections.singletonList(Values.TRUE));
        this.createEmptyNode();
        this.createNode(Collections.singletonList("C"), Collections.singletonList("prop1"), Collections.singletonList(Values.stringArray((String[])new String[]{"Test", "Success"})));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`A`:`B`", Arrays.asList("A", "B"), "prop1", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.nodeEntry(":`A`:`B`", Arrays.asList("A", "B"), "prop2", Collections.singletonList("Integer"), true), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "prop1", Collections.singletonList("Boolean"), true), BuiltInSchemaProceduresIT.nodeEntry(":`C`", Collections.singletonList("C"), "prop1", Collections.singletonList("StringArray"), true), BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), null, null, false)});
        }
    }

    @Test
    void testWithSimilarNodes() throws Throwable {
        this.createNode(Collections.singletonList("A"), Collections.singletonList("prop1"), Collections.singletonList(Values.stringValue((String)"Test")));
        this.createNode(Collections.singletonList("A"), Collections.singletonList("prop1"), Collections.singletonList(Values.stringValue((String)"Test2")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "prop1", Collections.singletonList("String"), true)});
        }
    }

    @Test
    void testWithSimilarNodesHavingDifferentPropertyValueTypes() throws Throwable {
        this.createNode(Collections.emptyList(), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createNode(Collections.emptyList(), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        this.createNode(Collections.emptyList(), Collections.singletonList("prop1"), Collections.singletonList(Values.stringValue((String)"Test")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), "prop1", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), "prop2", Arrays.asList("Integer", "Float"), false), BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), "prop3", Arrays.asList("String", "Boolean"), false)});
        }
    }

    @Test
    void testWithSimilarNodesShouldNotDependOnOrderOfCreation() throws Throwable {
        this.createEmptyNode();
        this.createNode(Collections.emptyList(), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createNode(Collections.emptyList(), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), "prop1", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), "prop2", Arrays.asList("Integer", "Float"), false), BuiltInSchemaProceduresIT.nodeEntry("", Collections.emptyList(), "prop3", Arrays.asList("String", "Boolean"), false)});
        }
    }

    @Test
    void testWithAllDifferentRelationships() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12)));
        this.createRelationship(nodeId1, "X", nodeId1, Collections.singletonList("prop1"), Collections.singletonList(Values.TRUE));
        this.createRelationship(nodeId1, "Z", nodeId1, Collections.emptyList(), Collections.emptyList());
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "prop1", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop2", Collections.singletonList("Integer"), true), BuiltInSchemaProceduresIT.relEntry(":`X`", "prop1", Collections.singletonList("Boolean"), true), BuiltInSchemaProceduresIT.relEntry(":`Z`", null, null, false)});
        }
    }

    @Test
    void testWithSimilarRelationships() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Collections.singletonList("prop1"), Collections.singletonList(Values.stringValue((String)"Test")));
        this.createRelationship(nodeId1, "R", nodeId1, Collections.singletonList("prop1"), Collections.singletonList(Values.stringValue((String)"Test2")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "prop1", Collections.singletonList("String"), true)});
        }
    }

    @Test
    void testSchemaWithRelationshipWithoutProperties() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "R", nodeId1, Collections.emptyList(), Collections.emptyList());
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "prop1", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop2", Collections.singletonList("Integer"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop3", Collections.singletonList("Boolean"), false)});
        }
    }

    @Test
    void testWithSimilarRelationshipsHavingDifferentPropertyValueTypes() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        this.createRelationship(nodeId1, "R", nodeId1, Collections.singletonList("prop1"), Collections.singletonList(Values.stringValue((String)"Test")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "prop1", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop2", Arrays.asList("Integer", "Float"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop3", Arrays.asList("String", "Boolean"), false)});
        }
    }

    @Test
    void testWithSimilarRelationshipsShouldNotDependOnOrderOfCreation() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Collections.emptyList(), Collections.emptyList());
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.relsProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.relEntry(":`R`", "prop1", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop2", Arrays.asList("Integer", "Float"), false), BuiltInSchemaProceduresIT.relEntry(":`R`", "prop3", Arrays.asList("String", "Boolean"), false)});
        }
    }

    @Test
    void testWithNullableProperties() throws Throwable {
        this.createNode(Collections.singletonList("A"), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createNode(Collections.singletonList("A"), Arrays.asList("prop1", "prop3"), Arrays.asList(Values.stringValue((String)"Test2"), Values.booleanValue((boolean)false)));
        this.createNode(Collections.singletonList("A"), Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test3"), Values.intValue((int)42)));
        this.createNode(Collections.singletonList("B"), Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test4"), Values.intValue((int)21)));
        this.createNode(Collections.singletonList("B"), Collections.emptyList(), Collections.emptyList());
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(this.nodesProcedureName, QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).contains((Object[])new AnyValue[][]{BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "prop1", Collections.singletonList("String"), true), BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "prop2", Collections.singletonList("Integer"), false), BuiltInSchemaProceduresIT.nodeEntry(":`A`", Collections.singletonList("A"), "prop3", Collections.singletonList("Boolean"), false), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "prop1", Collections.singletonList("String"), false), BuiltInSchemaProceduresIT.nodeEntry(":`B`", Collections.singletonList("B"), "prop2", Collections.singletonList("Integer"), false)});
        }
    }

    private static AnyValue[] nodeEntry(String escapedLabels, List<String> labels, String propertyName, List<String> propertyValueTypes, boolean mandatory) {
        return new AnyValue[]{Values.stringValue((String)escapedLabels), ValueUtils.asListValue(labels), Values.stringOrNoValue((String)propertyName), ValueUtils.of(propertyValueTypes), Values.booleanValue((boolean)mandatory)};
    }

    private static AnyValue[] relEntry(String labelsOrRelType, String propertyName, List<String> propertyValueTypes, boolean mandatory) {
        return new AnyValue[]{Values.stringOrNoValue((String)labelsOrRelType), Values.stringOrNoValue((String)propertyName), ValueUtils.of(propertyValueTypes), Values.booleanValue((boolean)mandatory)};
    }

    private long createEmptyNode() throws Throwable {
        return this.createNode(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private long createNode(List<String> labels, List<String> propKeys, List<Value> propValues) throws Throwable {
        assert (labels != null);
        assert (propKeys.size() == propValues.size());
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        for (String labelname : labels) {
            int labelId = transaction.tokenWrite().labelGetOrCreateForName(labelname);
            transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        }
        for (int i = 0; i < propKeys.size(); ++i) {
            String propKeyName = propKeys.get(i);
            Value propValue = propValues.get(i);
            int propKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(propKeyName);
            transaction.dataWrite().nodeSetProperty(nodeId, propKeyId, propValue);
        }
        this.commit();
        return nodeId;
    }

    private void createRelationship(long startNode, String type, long endNode, List<String> propKeys, List<Value> propValues) throws Throwable {
        assert (type != null && !type.isEmpty());
        assert (propKeys.size() == propValues.size());
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int typeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName(type);
        long relId = transaction.dataWrite().relationshipCreate(startNode, typeId, endNode);
        for (int i = 0; i < propKeys.size(); ++i) {
            String propKeyName = propKeys.get(i);
            Value propValue = propValues.get(i);
            int propKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(propKeyName);
            transaction.dataWrite().relationshipSetProperty(relId, propKeyId, propValue);
        }
        this.commit();
    }
}

