/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.locking;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class DynamicVerboseDeadlockIT {
    private static final Label LABEL = Label.label((String)"Label");
    private static final String KEY = "key";
    private static final String INDEX_NAME = "my_index";
    @Inject
    private GraphDatabaseAPI db;

    DynamicVerboseDeadlockIT() {
    }

    @Test
    void shouldDynamicallyToggleVerboseDeadlockMessages() throws InterruptedException {
        Assertions.assertThat((Throwable)this.produceDeadlock(false)).hasMessageNotContaining("WAITING_FOR_EXCLUSIVE");
        Assertions.assertThat((Throwable)this.produceDeadlock(true)).hasMessageContaining("WAITING_FOR_EXCLUSIVE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeadlockDetectedException produceDeadlock(boolean verboseDeadlocks) throws InterruptedException {
        ((Config)this.db.getDependencyResolver().resolveDependency(Config.class)).set(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, (Object)verboseDeadlocks);
        this.setUpData();
        CountDownLatch latch = new CountDownLatch(2);
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (int i = 0; i < 2; ++i) {
            tasks.add(() -> {
                try (Transaction tx = this.db.beginTx();){
                    IndexDefinition index = tx.schema().getIndexByName(INDEX_NAME);
                    latch.countDown();
                    latch.await();
                    index.drop();
                    tx.commit();
                }
                return null;
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            for (Future future : executor.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof DeadlockDetectedException) {
                DeadlockDetectedException dde = (DeadlockDetectedException)throwable;
                throwable = dde;
                return throwable;
            }
        }
        finally {
            executor.shutdown();
        }
        throw new RuntimeException("Was expecting a deadlock to occur");
    }

    private void setUpData() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on(KEY).withName(INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

