/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatabilityTestBase;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.ElementIdMapper;

class MinimalIndexAccessorCompatibility
extends IndexProviderCompatabilityTestBase {
    MinimalIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexPrototype indexPrototype) {
        super(testSuite, indexPrototype);
    }

    static abstract class ReadOnly
    extends MinimalIndexAccessorCompatibility {
        ReadOnly(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.indexPrototype());
        }

        @Override
        void additionalConfig(Config.Builder configBuilder) {
            configBuilder.set(GraphDatabaseSettings.read_only_database_default, (Object)true);
        }

        @Test
        void dropShouldBeBlockedIfReadOnly() {
            MinimalIndexAccessor minimalIndexAccessor = this.indexProvider.getMinimalIndexAccessor(this.descriptor, false);
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((MinimalIndexAccessor)minimalIndexAccessor).drop());
            Assertions.assertThat((Throwable)e).hasMessageContaining("read-only");
        }
    }

    static abstract class General
    extends MinimalIndexAccessorCompatibility {
        private MinimalIndexAccessor minimalIndexAccessor;

        General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.indexPrototype());
        }

        @BeforeEach
        void before() throws IOException {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.fs.mkdir(this.homePath);
            IndexPopulator populator = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, SchemaTestUtil.SIMPLE_NAME_LOOKUP, ElementIdMapper.PLACEHOLDER, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY);
            populator.create();
            populator.close(true, CursorContext.NULL_CONTEXT);
            this.minimalIndexAccessor = this.indexProvider.getMinimalIndexAccessor(this.descriptor, false);
        }

        @Test
        void indexDropperMustDropIndex() throws IOException {
            Path rootDirectory = this.indexProvider.directoryStructure().rootDirectory();
            Path[] files = this.fs.listFiles(rootDirectory);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)files.length);
            this.minimalIndexAccessor.drop();
            files = this.fs.listFiles(rootDirectory);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)files.length);
        }

        @Test
        void indexDropperMustProvideIndexConfiguration() {
            Map dropperConfiguration = this.minimalIndexAccessor.indexConfig();
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.descriptor.getIndexConfig().asMap(), (Object)dropperConfiguration);
        }
    }
}

