/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.TextIndexQueryTest;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.newapi.KernelRead;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TrigramIndexQueryTest
extends TextIndexQueryTest {
    @Override
    protected IndexProviderDescriptor getIndexProviderDescriptor() {
        return AllIndexProviderDescriptors.TEXT_V2_DESCRIPTOR;
    }

    @Test
    void countIndexEntitiesShouldFindExactEntity() throws Exception {
        try (ValueIndexReader valueIndexReader = ((KernelRead)this.read).newValueIndexReader(this.getIndex("some_node_text_index"));){
            long countIndexedEntities = valueIndexReader.countIndexedEntities(this.mikeNodeId, CursorContext.NULL_CONTEXT, new int[]{this.token.propertyKey("name")}, new Value[]{Values.stringValue((String)"Mike Smith")});
            Assertions.assertThat((long)countIndexedEntities).isEqualTo(1L);
        }
    }

    @Test
    void sadlyCountIndexEntitiesFindNotExactEntity() throws Exception {
        try (ValueIndexReader valueIndexReader = ((KernelRead)this.read).newValueIndexReader(this.getIndex("some_node_text_index"));){
            long countIndexedEntities = valueIndexReader.countIndexedEntities(this.mikeNodeId, CursorContext.NULL_CONTEXT, new int[]{this.token.propertyKey("name")}, new Value[]{Values.stringValue((String)"Smith")});
            Assertions.assertThat((long)countIndexedEntities).isEqualTo(1L);
        }
    }

    @Test
    void countIndexEntitiesDoesntFindOtherEntity() throws Exception {
        try (ValueIndexReader valueIndexReader = ((KernelRead)this.read).newValueIndexReader(this.getIndex("some_node_text_index"));){
            long countIndexedEntities = valueIndexReader.countIndexedEntities(this.noahNodeId, CursorContext.NULL_CONTEXT, new int[]{this.token.propertyKey("name")}, new Value[]{Values.stringValue((String)"Smith")});
            Assertions.assertThat((long)countIndexedEntities).isEqualTo(0L);
        }
    }
}

