/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.ControlledPopulationIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class IndexRestartIT {
    private static final String myKey = "number_of_bananas_owned";
    private static final Label myLabel = Label.label((String)"MyLabel");
    @Inject
    private TestDirectory directory;
    @Inject
    private FileSystemAbstraction fs;
    private GraphDatabaseService db;
    private TestDatabaseManagementServiceBuilder factory;
    private final ControlledPopulationIndexProvider provider = new ControlledPopulationIndexProvider();
    private DatabaseManagementService managementService;

    IndexRestartIT() {
    }

    @BeforeEach
    void before() {
        this.factory = new TestDatabaseManagementServiceBuilder(this.directory.homePath());
        this.factory.setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs));
        this.factory.addExtension(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)"test", (IndexProvider)this.provider));
        this.factory.setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false);
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldBeAbleToDropIndexWhileItIsPopulating() throws InterruptedException, KernelException {
        this.startDb();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 10; ++i) {
                tx.createNode(new Label[]{myLabel}).setProperty(myKey, (Object)i);
            }
            tx.commit();
        }
        Barrier.Control barrier = this.provider.installPopulationLatch(ControlledPopulationIndexProvider.PopulationLatchMethod.ADD_BATCH);
        IndexDefinition index = this.createIndex();
        barrier.await();
        this.dropIndex(index, barrier);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(IndexRestartIT.getIndexes(transaction, myLabel)).isEmpty();
            NotFoundException e = (NotFoundException)org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> IndexRestartIT.indexState(transaction, index));
            Assertions.assertThat((Throwable)e).hasMessageContaining(myLabel.name());
        }
    }

    @Test
    void shouldHandleRestartOfOnlineIndex() throws KernelException {
        this.startDb();
        this.createIndex();
        this.provider.awaitFullyPopulated();
        this.stopDb();
        this.provider.setInitialIndexState(InternalIndexState.ONLINE);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Iterable<IndexDefinition> indexes = IndexRestartIT.getIndexes(transaction, myLabel);
            for (IndexDefinition definition : indexes) {
                Assertions.assertThat((Comparable)IndexRestartIT.indexState(transaction, definition)).isEqualTo((Object)Schema.IndexState.ONLINE);
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.provider.populatorCallCount.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.provider.writerCallCount.get());
    }

    @Test
    void shouldHandleRestartIndexThatHasNotComeOnlineYet() throws KernelException {
        this.startDb();
        this.createIndex();
        this.stopDb();
        this.provider.setInitialIndexState(InternalIndexState.POPULATING);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Iterable<IndexDefinition> indexes = IndexRestartIT.getIndexes(transaction, myLabel);
            for (IndexDefinition definition : indexes) {
                Assertions.assertThat((Comparable)IndexRestartIT.indexState(transaction, definition)).isNotEqualTo((Object)Schema.IndexState.FAILED);
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.provider.populatorCallCount.get());
    }

    private IndexDefinition createIndex() throws KernelException {
        try (TransactionImpl tx = (TransactionImpl)this.db.beginTx();){
            IndexingTestUtil.createNodePropIndexWithSpecifiedProvider(tx, this.provider.getProviderDescriptor(), myLabel, myKey);
            tx.commit();
        }
        try (Transaction transaction = this.db.beginTx();){
            IndexDefinition indexDefinition = (IndexDefinition)Iterables.first(IndexRestartIT.getIndexes(transaction, myLabel));
            return indexDefinition;
        }
    }

    private void dropIndex(IndexDefinition index, Barrier.Control populationCompletionLatch) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexByName(index.getName()).drop();
            populationCompletionLatch.release();
            tx.commit();
        }
    }

    private void startDb() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.managementService = this.factory.noOpSystemGraphInitializer().build();
        this.db = this.managementService.database("neo4j");
    }

    private void stopDb() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    private static Iterable<IndexDefinition> getIndexes(Transaction transaction, Label label) {
        return transaction.schema().getIndexes(label);
    }

    private static Schema.IndexState indexState(Transaction transaction, IndexDefinition index) {
        return transaction.schema().getIndexState(index);
    }
}

