/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.TestRelType;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;
import org.neo4j.kernel.impl.event.VerifyingTransactionEventListener;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class TestTransactionEvents {
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseAPI db;
    private static final TimeUnit AWAIT_INDEX_UNIT = TimeUnit.SECONDS;
    private static final int AWAIT_INDEX_DURATION = 60;

    TestTransactionEvents() {
    }

    @Test
    void forbidToRegisterTransactionEventListenerOnSystemDatabase() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.dbms.registerTransactionEventListener("system", new DummyTransactionEventListener<Integer>(0)));
    }

    @Test
    void forbidToRegisterNullTransactionEventListener() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.dbms.registerTransactionEventListener("neo4j", null));
    }

    @Test
    void forbidToRegisterTransactionEventListenerForDatabaseNull() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.dbms.registerTransactionEventListener(null, new DummyTransactionEventListener<Integer>(0)));
    }

    @Test
    void testRegisterUnregisterListeners() {
        Integer value1 = 10;
        Double value2 = 3.5;
        DummyTransactionEventListener<Integer> listener1 = new DummyTransactionEventListener<Integer>(value1);
        DummyTransactionEventListener<Double> listener2 = new DummyTransactionEventListener<Double>(value2);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listener1));
        this.dbms.registerTransactionEventListener("neo4j", listener1);
        this.dbms.unregisterTransactionEventListener("neo4j", listener1);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listener1));
        this.dbms.registerTransactionEventListener("neo4j", listener1);
        this.dbms.registerTransactionEventListener("neo4j", listener2);
        this.dbms.unregisterTransactionEventListener("neo4j", listener1);
        this.dbms.unregisterTransactionEventListener("neo4j", listener2);
        this.dbms.registerTransactionEventListener("neo4j", listener1);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().delete();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)listener1.beforeCommit);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)listener1.afterCommit);
        org.junit.jupiter.api.Assertions.assertNull((Object)listener1.afterRollback);
        org.junit.jupiter.api.Assertions.assertEquals((Object)value1, listener1.receivedState);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)listener1.receivedTransactionData);
        this.dbms.unregisterTransactionEventListener("neo4j", listener1);
    }

    @Test
    void makeSureListenersCantBeRegisteredTwice() {
        DummyTransactionEventListener<Object> listener = new DummyTransactionEventListener<Object>(null);
        this.dbms.registerTransactionEventListener("neo4j", listener);
        this.dbms.registerTransactionEventListener("neo4j", listener);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().delete();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((Integer)0, (Integer)listener.beforeCommit);
        org.junit.jupiter.api.Assertions.assertEquals((Integer)1, (Integer)listener.afterCommit);
        org.junit.jupiter.api.Assertions.assertNull((Object)listener.afterRollback);
        this.dbms.unregisterTransactionEventListener("neo4j", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void onlyTransientErrorsShouldBeRethrown() {
        Transaction tx;
        DeadlockDetectedException transientException = new DeadlockDetectedException("transient error");
        ExceptionThrowingEventListener transientThrowingListener = new ExceptionThrowingEventListener((Exception)((Object)transientException), null, null);
        Exception otherException = new Exception("other error");
        ExceptionThrowingEventListener exceptionThrowingListener = new ExceptionThrowingEventListener(otherException, null, null);
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)transientThrowingListener);
        try {
            tx = this.db.beginTx();
            try {
                tx.createNode().delete();
                Assertions.assertThatThrownBy(() -> ((Transaction)tx).commit()).isEqualTo((Object)transientException);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)transientThrowingListener);
        }
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)exceptionThrowingListener);
        try {
            tx = this.db.beginTx();
            try {
                tx.createNode().delete();
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)tx).commit()).isNotEqualTo((Object)otherException)).isInstanceOf(TransactionFailureException.class)).hasRootCause((Throwable)otherException);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)exceptionThrowingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldGetCorrectTransactionDataUponCommit() {
        Throwable failure;
        Relationship rel2;
        Node node3;
        Relationship rel1;
        Node node1;
        Transaction tx;
        ExpectedTransactionData expectedData = new ExpectedTransactionData();
        VerifyingTransactionEventListener listener = new VerifyingTransactionEventListener(expectedData);
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)listener);
        try {
            tx = this.db.beginTx();
            try {
                node1 = tx.createNode();
                expectedData.expectedCreatedNodes.add(node1);
                Node node2 = tx.createNode();
                expectedData.expectedCreatedNodes.add(node2);
                rel1 = node1.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
                expectedData.expectedCreatedRelationships.add(rel1);
                node1.setProperty("name", (Object)"Mattias");
                expectedData.assignedProperty(node1, "name", (Object)"Mattias", null);
                node1.setProperty("last name", (Object)"Persson");
                expectedData.assignedProperty(node1, "last name", (Object)"Persson", null);
                node1.setProperty("counter", (Object)10);
                expectedData.assignedProperty(node1, "counter", (Object)10, null);
                rel1.setProperty("description", (Object)"A description");
                expectedData.assignedProperty(rel1, "description", (Object)"A description", null);
                rel1.setProperty("number", (Object)4.5);
                expectedData.assignedProperty(rel1, "number", (Object)4.5, null);
                node3 = tx.createNode();
                expectedData.expectedCreatedNodes.add(node3);
                rel2 = node3.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
                expectedData.expectedCreatedRelationships.add(rel2);
                node3.setProperty("name", (Object)"Node 3");
                expectedData.assignedProperty(node3, "name", (Object)"Node 3", null);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)listener.hasBeenCalled(), (String)"Should have been invoked");
            failure = listener.failure();
            if (failure != null) {
                throw new RuntimeException(failure);
            }
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listener);
        }
        expectedData = new ExpectedTransactionData();
        listener = new VerifyingTransactionEventListener(expectedData);
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)listener);
        try {
            tx = this.db.beginTx();
            try {
                Node newNode = tx.createNode();
                expectedData.expectedCreatedNodes.add(newNode);
                Node tempNode = tx.createNode();
                Relationship tempRel = tempNode.createRelationshipTo(node1, (RelationshipType)RelTypes.TXEVENT);
                tempNode.setProperty("something", (Object)"Some value");
                tempRel.setProperty("someproperty", (Object)101010);
                tempNode.removeProperty("nothing");
                node3 = tx.getNodeById(node3.getId());
                node3.setProperty("test", (Object)"hello");
                node3.setProperty("name", (Object)"No name");
                node3.delete();
                expectedData.expectedDeletedNodes.add(node3);
                expectedData.removedProperty(node3, "name", (Object)"Node 3");
                node1 = tx.getNodeById(node1.getId());
                node1.setProperty("new name", (Object)"A name");
                node1.setProperty("new name", (Object)"A better name");
                expectedData.assignedProperty(node1, "new name", (Object)"A better name", null);
                node1.setProperty("name", (Object)"Nothing");
                node1.setProperty("name", (Object)"Mattias Persson");
                expectedData.assignedProperty(node1, "name", (Object)"Mattias Persson", (Object)"Mattias");
                node1.removeProperty("counter");
                expectedData.removedProperty(node1, "counter", (Object)10);
                node1.removeProperty("last name");
                node1.setProperty("last name", (Object)"Hi");
                expectedData.assignedProperty(node1, "last name", (Object)"Hi", (Object)"Persson");
                rel2 = tx.getRelationshipById(rel2.getId());
                rel2.delete();
                expectedData.expectedDeletedRelationships.add(rel2);
                rel1 = tx.getRelationshipById(rel1.getId());
                rel1.removeProperty("number");
                expectedData.removedProperty(rel1, "number", (Object)4.5);
                rel1.setProperty("description", (Object)"Ignored");
                rel1.setProperty("description", (Object)"New");
                expectedData.assignedProperty(rel1, "description", (Object)"New", (Object)"A description");
                tempRel.delete();
                tempNode.delete();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)listener.hasBeenCalled(), (String)"Should have been invoked");
            failure = listener.failure();
            if (failure != null) {
                throw new RuntimeException(failure);
            }
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void makeSureBeforeAfterAreCalledCorrectly() {
        ArrayList<TransactionEventListener<Object>> listeners = new ArrayList<TransactionEventListener<Object>>();
        listeners.add(new FailingEventListener<Object>(new DummyTransactionEventListener<Object>(null), false));
        listeners.add(new FailingEventListener<Object>(new DummyTransactionEventListener<Object>(null), false));
        listeners.add(new FailingEventListener<Object>(new DummyTransactionEventListener<Object>(null), true));
        listeners.add(new FailingEventListener<Object>(new DummyTransactionEventListener<Object>(null), false));
        for (TransactionEventListener transactionEventListener : listeners) {
            this.dbms.registerTransactionEventListener("neo4j", transactionEventListener);
        }
        try {
            Assertions.assertThatThrownBy(() -> {
                try (Transaction tx = this.db.beginTx();){
                    tx.createNode().delete();
                    tx.commit();
                }
            }).isInstanceOf(TransactionFailureException.class);
            TestTransactionEvents.verifyListenerCalls(listeners, false);
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listeners.remove(2));
            for (TransactionEventListener transactionEventListener : listeners) {
                ((DummyTransactionEventListener)((FailingEventListener)transactionEventListener).source).reset();
            }
            try (Transaction transaction = this.db.beginTx();){
                transaction.createNode().delete();
                transaction.commit();
            }
            TestTransactionEvents.verifyListenerCalls(listeners, true);
        }
        finally {
            for (TransactionEventListener transactionEventListener : listeners) {
                this.dbms.unregisterTransactionEventListener("neo4j", transactionEventListener);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Test
    void shouldBeAbleToAccessExceptionThrownInEventHook() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    void deleteNodeRelTriggerPropertyRemoveEvents() {
        Relationship rel;
        Node node2;
        Node node1;
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode();
            node2 = tx.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
            node1.setProperty("test1", (Object)"stringvalue");
            node1.setProperty("test2", (Object)1L);
            rel.setProperty("test1", (Object)"stringvalue");
            rel.setProperty("test2", (Object)1L);
            rel.setProperty("test3", (Object)new int[]{1, 2, 3});
            tx.commit();
        }
        MyTxEventListener listener = new MyTxEventListener();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)listener);
        try (Transaction tx = this.db.beginTx();){
            tx.getRelationshipById(rel.getId()).delete();
            tx.getNodeById(node1.getId()).delete();
            tx.getNodeById(node2.getId()).delete();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"stringvalue", (Object)listener.nodeProps.get("test1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"stringvalue", (Object)listener.relProps.get("test1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)1L, (Object)listener.nodeProps.get("test2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)1L, (Object)listener.relProps.get("test2"));
        int[] intArray = (int[])listener.relProps.get("test3");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)intArray.length);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)intArray[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)intArray[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)intArray[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void makeSureListenerIsntCalledWhenTxRolledBack() {
        DummyTransactionEventListener<Integer> listener = new DummyTransactionEventListener<Integer>(10);
        this.dbms.registerTransactionEventListener("neo4j", listener);
        try {
            try (Transaction tx = this.db.beginTx();){
                tx.createNode().delete();
            }
            org.junit.jupiter.api.Assertions.assertNull((Object)listener.beforeCommit);
            org.junit.jupiter.api.Assertions.assertNull((Object)listener.afterCommit);
            org.junit.jupiter.api.Assertions.assertNull((Object)listener.afterRollback);
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", listener);
        }
    }

    @Test
    void modifiedPropertyCanByFurtherModifiedInBeforeCommit() {
        Node node;
        String key = "key";
        String value1 = "the old value";
        final String value2 = "the new value";
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.setProperty("key", (Object)"initial value");
            tx.commit();
        }
        TransactionEventListenerAdapter<Void> listener = new TransactionEventListenerAdapter<Void>(){

            public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                Node modifiedNode = (Node)((PropertyEntry)data.assignedNodeProperties().iterator().next()).entity();
                org.junit.jupiter.api.Assertions.assertEquals((Object)node, (Object)modifiedNode);
                modifiedNode.setProperty("key", value2);
                return null;
            }
        };
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)listener);
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).setProperty("key", (Object)value1);
            tx.commit();
        }
        try (Transaction transaction = this.db.beginTx();){
            Node n = transaction.getNodeById(node.getId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)value2, (Object)n.getProperty("key"));
        }
        this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listener);
    }

    @Test
    void nodeCanBecomeSchemaIndexableInBeforeCommitByAddingProperty() {
        Node node;
        Label label = Label.label((String)"Label");
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(label).on("indexed").create();
            tx.commit();
        }
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Object>(){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                Iterator nodes = data.createdNodes().iterator();
                if (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    node.setProperty("indexed", (Object)"value");
                }
                return null;
            }
        });
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(60L, AWAIT_INDEX_UNIT);
            node = tx.createNode(new Label[]{label});
            node.setProperty("random", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = tx.findNode(label, "indexed", (Object)"value");
            Assertions.assertThat((Object)node.getProperty("random")).isEqualTo((Object)42);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeCanBecomeSchemaIndexableInBeforeCommitByAddingLabel() {
        Node node;
        final Label label = Label.label((String)"Label");
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(label).on("indexed").create();
            tx.commit();
        }
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Object>(){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                Iterator nodes = data.createdNodes().iterator();
                if (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    node.addLabel(label);
                }
                return null;
            }
        });
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(60L, AWAIT_INDEX_UNIT);
            node = tx.createNode();
            node.setProperty("indexed", (Object)"value");
            node.setProperty("random", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = tx.findNode(label, "indexed", (Object)"value");
            Assertions.assertThat((Object)node.getProperty("random")).isEqualTo((Object)42);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAccessAssignedLabels() {
        ChangedLabels labels = new ChangedLabels();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)labels);
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = tx.createNode();
                Node node2 = tx.createNode();
                Node node3 = tx.createNode();
                labels.add(node1, "Foo");
                labels.add(node2, "Bar");
                labels.add(node3, "Baz");
                labels.add(node3, "Bar");
                labels.activate();
                tx.commit();
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)labels.isEmpty());
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)labels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAccessRemovedLabels() {
        ChangedLabels labels = new ChangedLabels();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)labels);
        try {
            Node node3;
            Node node2;
            Node node1;
            try (Transaction tx = this.db.beginTx();){
                node1 = tx.createNode();
                node2 = tx.createNode();
                node3 = tx.createNode();
                labels.add(node1, "Foo");
                labels.add(node2, "Bar");
                labels.add(node3, "Baz");
                labels.add(node3, "Bar");
                tx.commit();
            }
            labels.clear();
            tx = this.db.beginTx();
            try {
                labels.remove(tx.getNodeById(node1.getId()), "Foo");
                labels.remove(tx.getNodeById(node2.getId()), "Bar");
                labels.remove(tx.getNodeById(node3.getId()), "Baz");
                labels.remove(tx.getNodeById(node3.getId()), "Bar");
                labels.activate();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)labels.isEmpty());
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)labels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAccessRelationshipDataInAfterCommit() {
        final AtomicInteger accessCount = new AtomicInteger();
        final HashMap<Long, RelationshipData> expectedRelationshipData = new HashMap<Long, RelationshipData>();
        TransactionEventListenerAdapter<Void> listener = new TransactionEventListenerAdapter<Void>(){

            public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
                accessCount.set(0);
                try (Transaction tx = TestTransactionEvents.this.db.beginTx();){
                    for (Relationship relationship : data.createdRelationships()) {
                        this.accessData(tx.getRelationshipById(relationship.getId()));
                    }
                    for (PropertyEntry change : data.assignedRelationshipProperties()) {
                        this.accessData(tx.getRelationshipById(((Relationship)change.entity()).getId()));
                    }
                    for (PropertyEntry change : data.removedRelationshipProperties()) {
                        this.accessData((Relationship)change.entity());
                    }
                    tx.commit();
                }
            }

            private void accessData(Relationship relationship) {
                accessCount.incrementAndGet();
                RelationshipData expectancy = (RelationshipData)expectedRelationshipData.get(relationship.getId());
                org.junit.jupiter.api.Assertions.assertNotNull((Object)expectancy);
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectancy.startNode, (Object)relationship.getStartNode());
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectancy.type, (Object)relationship.getType().name());
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectancy.endNode, (Object)relationship.getEndNode());
            }
        };
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)listener);
        try {
            Relationship relationship;
            try (Transaction tx = this.db.beginTx();){
                relationship = tx.createNode().createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
                expectedRelationshipData.put(relationship.getId(), new RelationshipData(relationship));
                tx.commit();
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)accessCount.get());
            tx = this.db.beginTx();
            try {
                relationship = tx.getRelationshipById(relationship.getId());
                relationship.setProperty("name", (Object)"Smith");
                Relationship otherRelationship = tx.createNode().createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
                expectedRelationshipData.put(otherRelationship.getId(), new RelationshipData(otherRelationship));
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)accessCount.get());
            tx = this.db.beginTx();
            try {
                tx.getRelationshipById(relationship.getId()).delete();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)accessCount.get());
        }
        finally {
            this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)listener);
        }
    }

    @Test
    void shouldProvideTheCorrectRelationshipData() {
        long relId;
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"TYPE"));
        }
        RelationshipType livesIn = RelationshipType.withName((String)"LIVES_IN");
        try (Transaction tx = this.db.beginTx();){
            Node person = tx.createNode(new Label[]{Label.label((String)"Person")});
            Node city = tx.createNode(new Label[]{Label.label((String)"City")});
            Relationship rel = person.createRelationshipTo(city, livesIn);
            rel.setProperty("since", (Object)2009);
            relId = rel.getId();
            tx.commit();
        }
        final HashSet changedRelationships = new HashSet();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Void>(){

            public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                for (PropertyEntry entry : data.assignedRelationshipProperties()) {
                    changedRelationships.add(((Relationship)entry.entity()).getType().name());
                }
                return null;
            }
        });
        try (Transaction tx = this.db.beginTx();){
            Relationship rel = tx.getRelationshipById(relId);
            rel.setProperty("since", (Object)2010);
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)changedRelationships.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)changedRelationships.contains(livesIn.name()), (String)(String.valueOf(livesIn) + " not in " + String.valueOf(changedRelationships)));
    }

    @Test
    void shouldNotFireEventForReadOnlyTransaction() {
        Node root = this.createTree(3, 3);
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new ExceptionThrowingEventListener(new RuntimeException("Just failing")));
        try (Transaction tx = this.db.beginTx();){
            Iterables.count((Iterable)tx.traversalDescription().traverse(tx.getNodeById(root.getId())));
            tx.commit();
        }
    }

    @Test
    void shouldNotFireEventForNonDataTransactions() {
        final AtomicInteger counter = new AtomicInteger();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Void>(){

            public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                org.junit.jupiter.api.Assertions.assertTrue((data.createdNodes().iterator().hasNext() || data.createdRelationships().iterator().hasNext() ? 1 : 0) != 0, (String)"Expected only transactions that had nodes or relationships created");
                counter.incrementAndGet();
                return null;
            }
        });
        Label label = Label.label((String)"Label");
        String key = "key";
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)counter.get());
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{label});
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)counter.get());
        tx = this.db.beginTx();
        try {
            tx.createNode().setProperty(key, (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)counter.get());
        tx = this.db.beginTx();
        try {
            tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"A_TYPE"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)counter.get());
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(label).on(key).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().constraintFor(label).assertPropertyIsUnique("otherkey").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)counter.get());
    }

    @Test
    void shouldBeAbleToTouchDataOutsideTxDataInAfterCommit() {
        final Node node = this.createNode("one", "Two", "three", "Four");
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Object>(){

            public void afterCommit(TransactionData data, Object nothing, GraphDatabaseService databaseService) {
                try (Transaction tx = TestTransactionEvents.this.db.beginTx();){
                    Node listenerNode = tx.getNodeById(node.getId());
                    for (String key : listenerNode.getPropertyKeys()) {
                        listenerNode.getProperty(key);
                    }
                    tx.commit();
                }
            }
        });
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.getNodeById(node.getId()).setProperty("five", (Object)"Six");
            tx.commit();
        }
    }

    @Test
    void shouldAllowToStringOnCreatedRelationshipInAfterCommit() {
        Relationship relationship;
        Node endNode;
        Node startNode;
        MyRelTypes type = MyRelTypes.TEST;
        try (Transaction tx = this.db.beginTx();){
            startNode = tx.createNode();
            endNode = tx.createNode();
            relationship = startNode.createRelationshipTo(endNode, (RelationshipType)type);
            tx.commit();
        }
        final AtomicReference deletedToString = new AtomicReference();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Object>(){

            public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
                for (Relationship relationship : data.deletedRelationships()) {
                    deletedToString.set(relationship.toString());
                }
            }
        });
        try (Transaction tx = this.db.beginTx();){
            tx.getRelationshipById(relationship.getId()).delete();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertNotNull(deletedToString.get());
        Assertions.assertThat((String)((String)deletedToString.get())).contains(new CharSequence[]{type.name()});
        Assertions.assertThat((String)((String)deletedToString.get())).contains(new CharSequence[]{String.format("(%d)", startNode.getId())});
        Assertions.assertThat((String)((String)deletedToString.get())).contains(new CharSequence[]{String.format("(%d)", endNode.getId())});
    }

    @Test
    void shouldHaveTransactionIdInAfterCommit() {
        final AtomicBoolean called = new AtomicBoolean();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new TransactionEventListenerAdapter<Object>(){

            public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
                data.getTransactionId();
                called.set(true);
            }
        });
        long nodeId = 0L;
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode().getId();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)called.getAndSet(false));
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)called.getAndSet(false));
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(Label.label((String)"Label")).on("prop").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)called.getAndSet(false));
        tx = this.db.beginTx();
        try {
            tx.createNode().delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)called.getAndSet(false));
    }

    @Test
    void shouldGetCallToAfterRollbackEvenIfBeforeCommitFailed() {
        CapturingEventListener<Integer> firstWorkingListener = new CapturingEventListener<Integer>(() -> 5);
        String failureMessage = "Massive fail";
        CapturingEventListener<Integer> faultyListener = new CapturingEventListener<Integer>(() -> {
            throw new RuntimeException(failureMessage);
        });
        CapturingEventListener<Integer> otherWorkingListener = new CapturingEventListener<Integer>(() -> 10);
        this.dbms.registerTransactionEventListener("neo4j", firstWorkingListener);
        this.dbms.registerTransactionEventListener("neo4j", faultyListener);
        this.dbms.registerTransactionEventListener("neo4j", otherWorkingListener);
        boolean failed = false;
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, (String)failureMessage, (Class[])new Class[]{RuntimeException.class}));
            failed = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)failed);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstWorkingListener.beforeCommitCalled);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstWorkingListener.afterRollbackCalled);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)((Integer)firstWorkingListener.afterRollbackState));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)faultyListener.beforeCommitCalled);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)faultyListener.afterRollbackCalled);
        org.junit.jupiter.api.Assertions.assertNull(faultyListener.afterRollbackState);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherWorkingListener.beforeCommitCalled);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherWorkingListener.afterRollbackCalled);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)((Integer)otherWorkingListener.afterRollbackState));
    }

    @Test
    void shouldNotInvokeListenersForInternalTokenTransactions() {
        String databaseName = "neo4j";
        CommitCountingEventListener listener = new CommitCountingEventListener();
        this.dbms.registerTransactionEventListener(databaseName, (TransactionEventListener)listener);
        long lastClosedTxIdBefore = TestTransactionEvents.lastClosedTxId(databaseName, this.dbms);
        TestTransactionEvents.commitTxWithMultipleNewTokens(databaseName, this.dbms);
        long lastClosedTxIdAfter = TestTransactionEvents.lastClosedTxId(databaseName, this.dbms);
        Assertions.assertThat((long)lastClosedTxIdAfter).isGreaterThan(lastClosedTxIdBefore + 1L);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)listener.beforeCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)listener.afterCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterRollbackInvocations.get());
    }

    @Test
    void shouldInvokeInternalListenersForInternalTokenTransactions() {
        String databaseName = "neo4j";
        CommitCountingEventInternalListener listener = new CommitCountingEventInternalListener();
        this.dbms.registerTransactionEventListener(databaseName, (TransactionEventListener)listener);
        long lastClosedTxIdBefore = TestTransactionEvents.lastClosedTxId(databaseName, this.dbms);
        TestTransactionEvents.commitTxWithMultipleNewTokens(databaseName, this.dbms);
        long lastClosedTxIdAfter = TestTransactionEvents.lastClosedTxId(databaseName, this.dbms);
        Assertions.assertThat((long)lastClosedTxIdAfter).isGreaterThan(lastClosedTxIdBefore + 1L);
        long committedTransactions = lastClosedTxIdAfter - lastClosedTxIdBefore;
        org.junit.jupiter.api.Assertions.assertEquals((long)committedTransactions, (long)listener.beforeCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((long)committedTransactions, (long)listener.afterCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterRollbackInvocations.get());
    }

    @Test
    void shouldInvokeListenersForAllTransactionsOnSystemDatabase() {
        String databaseName = "system";
        CommitCountingEventListener listener = new CommitCountingEventListener();
        TestTransactionEvents.registerTransactionEventListenerForSystemDb(this.dbms, listener);
        long lastClosedTxIdBefore = TestTransactionEvents.lastClosedTxId(databaseName, this.dbms);
        TestTransactionEvents.commitTxWithMultipleNewTokens(databaseName, this.dbms);
        long lastClosedTxIdAfter = TestTransactionEvents.lastClosedTxId(databaseName, this.dbms);
        long committedTransactions = lastClosedTxIdAfter - lastClosedTxIdBefore;
        Assertions.assertThat((long)committedTransactions).isGreaterThan(1L);
        org.junit.jupiter.api.Assertions.assertEquals((long)committedTransactions, (long)listener.beforeCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((long)committedTransactions, (long)listener.afterCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterRollbackInvocations.get());
    }

    @Test
    void shouldNotInvokeListenerForReadOnlyTransaction() {
        String databaseName = "neo4j";
        CommitCountingEventListener listener = new CommitCountingEventListener();
        this.dbms.registerTransactionEventListener(databaseName, (TransactionEventListener)listener);
        TestTransactionEvents.commitReadOnlyTransaction(databaseName, this.dbms);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.beforeCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterRollbackInvocations.get());
    }

    @Test
    void shouldNotInvokeListenerForReadOnlySystemDatabaseTransaction() {
        CommitCountingEventListener listener = new CommitCountingEventListener();
        TestTransactionEvents.registerTransactionEventListenerForSystemDb(this.dbms, listener);
        TestTransactionEvents.commitReadOnlyTransaction("system", this.dbms);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.beforeCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterCommitInvocations.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)listener.afterRollbackInvocations.get());
    }

    private static void commitTxWithMultipleNewTokens(String databaseName, DatabaseManagementService managementService) {
        GraphDatabaseService db = managementService.database(databaseName);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE});
            node.createRelationshipTo(node, (RelationshipType)TestRelType.LOOP);
            tx.commit();
        }
    }

    private static void commitReadOnlyTransaction(String databaseName, DatabaseManagementService managementService) {
        GraphDatabaseService db = managementService.database(databaseName);
        try (Transaction tx = db.beginTx();
             ResourceIterable allNodes = tx.getAllNodes();
             ResourceIterator nodesIterator = allNodes.iterator();){
            while (nodesIterator.hasNext()) {
                org.junit.jupiter.api.Assertions.assertNotNull((Object)nodesIterator.next());
            }
            tx.commit();
        }
    }

    private static long lastClosedTxId(String databaseName, DatabaseManagementService managementService) {
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database(databaseName);
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }

    private static void registerTransactionEventListenerForSystemDb(DatabaseManagementService managementService, TransactionEventListener<Object> listener) {
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("system");
        GlobalTransactionEventListeners globalListeners = (GlobalTransactionEventListeners)db.getDependencyResolver().resolveDependency(GlobalTransactionEventListeners.class);
        globalListeners.registerTransactionEventListener("system", listener);
    }

    private static void verifyListenerCalls(List<TransactionEventListener<Object>> listeners, boolean txSuccess) {
        for (TransactionEventListener<Object> listener : listeners) {
            DummyTransactionEventListener realListener = (DummyTransactionEventListener)((FailingEventListener)listener).source;
            if (txSuccess) {
                org.junit.jupiter.api.Assertions.assertEquals((Integer)0, (Integer)realListener.beforeCommit);
                org.junit.jupiter.api.Assertions.assertEquals((Integer)1, (Integer)realListener.afterCommit);
                continue;
            }
            if (realListener.counter <= 0) continue;
            org.junit.jupiter.api.Assertions.assertEquals((Integer)0, (Integer)realListener.beforeCommit);
            org.junit.jupiter.api.Assertions.assertEquals((Integer)1, (Integer)realListener.afterRollback);
        }
    }

    private Node createNode(String ... properties) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            for (int i = 0; i < properties.length; ++i) {
                node.setProperty(properties[i++], (Object)properties[i]);
            }
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private Node createTree(int depth, int width) {
        try (Transaction tx = this.db.beginTx();){
            Node root = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            TestTransactionEvents.createTree(tx, root, depth, width, 0);
            tx.commit();
            Node node = root;
            return node;
        }
    }

    private static void createTree(Transaction tx, Node parent, int maxDepth, int width, int currentDepth) {
        if (currentDepth > maxDepth) {
            return;
        }
        for (int i = 0; i < width; ++i) {
            Node child = tx.createNode(new Label[]{TestLabels.LABEL_TWO});
            parent.createRelationshipTo(child, (RelationshipType)MyRelTypes.TEST);
            TestTransactionEvents.createTree(tx, child, maxDepth, width, currentDepth + 1);
        }
    }

    private static class DummyTransactionEventListener<T>
    implements TransactionEventListener<T> {
        private final T object;
        private TransactionData receivedTransactionData;
        private T receivedState;
        private int counter;
        private Integer beforeCommit;
        private Integer afterCommit;
        private Integer afterRollback;

        DummyTransactionEventListener(T object) {
            this.object = object;
        }

        public void afterCommit(TransactionData data, T state, GraphDatabaseService databaseService) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)data);
            this.receivedState = state;
            this.afterCommit = this.counter++;
        }

        public void afterRollback(TransactionData data, T state, GraphDatabaseService databaseService) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)data);
            this.receivedState = state;
            this.afterRollback = this.counter++;
        }

        public T beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)data);
            this.receivedTransactionData = data;
            this.beforeCommit = this.counter++;
            if (this.beforeCommit == 2) {
                new Exception("blabla").printStackTrace();
            }
            return this.object;
        }

        void reset() {
            this.receivedTransactionData = null;
            this.receivedState = null;
            this.counter = 0;
            this.beforeCommit = null;
            this.afterCommit = null;
            this.afterRollback = null;
        }
    }

    private static class ExceptionThrowingEventListener
    implements TransactionEventListener<Object> {
        private final Exception beforeCommitException;
        private final Exception afterCommitException;
        private final Exception afterRollbackException;

        ExceptionThrowingEventListener(Exception exceptionForAll) {
            this(exceptionForAll, exceptionForAll, exceptionForAll);
        }

        ExceptionThrowingEventListener(Exception beforeCommitException, Exception afterCommitException, Exception afterRollbackException) {
            this.beforeCommitException = beforeCommitException;
            this.afterCommitException = afterCommitException;
            this.afterRollbackException = afterRollbackException;
        }

        public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
            if (this.beforeCommitException != null) {
                throw this.beforeCommitException;
            }
            return null;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            if (this.afterCommitException != null) {
                throw new RuntimeException(this.afterCommitException);
            }
        }

        public void afterRollback(TransactionData data, Object state, GraphDatabaseService databaseService) {
            if (this.afterRollbackException != null) {
                throw new RuntimeException(this.afterRollbackException);
            }
        }
    }

    private static enum RelTypes implements RelationshipType
    {
        TXEVENT;

    }

    private static class FailingEventListener<T>
    implements TransactionEventListener<T> {
        private final TransactionEventListener<T> source;
        private final boolean willFail;

        FailingEventListener(TransactionEventListener<T> source, boolean willFail) {
            this.source = source;
            this.willFail = willFail;
        }

        public void afterCommit(TransactionData data, T state, GraphDatabaseService databaseService) {
            this.source.afterCommit(data, state, databaseService);
        }

        public void afterRollback(TransactionData data, T state, GraphDatabaseService databaseService) {
            this.source.afterRollback(data, state, databaseService);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
            try {
                Object object = this.source.beforeCommit(data, transaction, databaseService);
                return (T)object;
            }
            finally {
                if (this.willFail) {
                    throw new Exception("Just failing commit, that's all");
                }
            }
        }
    }

    private static class MyTxEventListener
    implements TransactionEventListener<Object> {
        Map<String, Object> nodeProps = new HashMap<String, Object>();
        Map<String, Object> relProps = new HashMap<String, Object>();

        private MyTxEventListener() {
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            for (PropertyEntry entry : data.removedNodeProperties()) {
                String key = entry.key();
                Object value = entry.previouslyCommittedValue();
                this.nodeProps.put(key, value);
            }
            for (PropertyEntry entry : data.removedRelationshipProperties()) {
                this.relProps.put(entry.key(), entry.previouslyCommittedValue());
            }
        }

        public void afterRollback(TransactionData data, Object state, GraphDatabaseService databaseService) {
        }

        public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            return null;
        }
    }

    private static final class ChangedLabels
    extends TransactionEventListenerAdapter<Void> {
        private final Map<Node, Set<String>> added = new HashMap<Node, Set<String>>();
        private final Map<Node, Set<String>> removed = new HashMap<Node, Set<String>>();
        private boolean active;

        private ChangedLabels() {
        }

        public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            if (this.active) {
                ChangedLabels.check(this.added, "added to", data.assignedLabels());
                ChangedLabels.check(this.removed, "removed from", data.removedLabels());
            }
            this.active = false;
            return null;
        }

        private static void check(Map<Node, Set<String>> expected, String change, Iterable<LabelEntry> changes) {
            for (LabelEntry entry : changes) {
                Set<String> labels = expected.get(entry.node());
                String message = String.format("':%s' should not be %s %s", entry.label().name(), change, entry.node());
                org.junit.jupiter.api.Assertions.assertNotNull(labels, (String)message);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)labels.remove(entry.label().name()), (String)message);
                if (!labels.isEmpty()) continue;
                expected.remove(entry.node());
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)expected.isEmpty(), (String)String.format("Expected more labels %s nodes: %s", change, expected));
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }

        public void add(Node node, String label) {
            node.addLabel(Label.label((String)label));
            ChangedLabels.put(this.added, node, label);
        }

        public void remove(Node node, String label) {
            node.removeLabel(Label.label((String)label));
            ChangedLabels.put(this.removed, node, label);
        }

        private static void put(Map<Node, Set<String>> changes, Node node, String label) {
            Set labels = changes.computeIfAbsent(node, k -> new HashSet());
            labels.add(label);
        }

        void activate() {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isEmpty());
            this.active = true;
        }

        public void clear() {
            this.added.clear();
            this.removed.clear();
            this.active = false;
        }
    }

    private static class RelationshipData {
        final Node startNode;
        final String type;
        final Node endNode;

        RelationshipData(Relationship relationship) {
            this.startNode = relationship.getStartNode();
            this.type = relationship.getType().name();
            this.endNode = relationship.getEndNode();
        }
    }

    private static class CapturingEventListener<T>
    implements TransactionEventListener<T> {
        private final Supplier<T> stateSource;
        boolean beforeCommitCalled;
        boolean afterCommitCalled;
        T afterCommitState;
        boolean afterRollbackCalled;
        T afterRollbackState;

        CapturingEventListener(Supplier<T> stateSource) {
            this.stateSource = stateSource;
        }

        public T beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            this.beforeCommitCalled = true;
            return this.stateSource.get();
        }

        public void afterCommit(TransactionData data, T state, GraphDatabaseService databaseService) {
            this.afterCommitCalled = true;
            this.afterCommitState = state;
        }

        public void afterRollback(TransactionData data, T state, GraphDatabaseService databaseService) {
            this.afterRollbackCalled = true;
            this.afterRollbackState = state;
        }
    }

    private static class CommitCountingEventListener
    extends CommitCountingEventBase
    implements TransactionEventListener<Object> {
        private CommitCountingEventListener() {
        }
    }

    private static class CommitCountingEventInternalListener
    extends CommitCountingEventBase
    implements InternalTransactionEventListener<Object> {
        private CommitCountingEventInternalListener() {
        }
    }

    private static class CommitCountingEventBase {
        final AtomicInteger beforeCommitInvocations = new AtomicInteger();
        final AtomicInteger afterCommitInvocations = new AtomicInteger();
        final AtomicInteger afterRollbackInvocations = new AtomicInteger();

        private CommitCountingEventBase() {
        }

        public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            this.beforeCommitInvocations.incrementAndGet();
            return null;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            this.afterCommitInvocations.incrementAndGet();
        }

        public void afterRollback(TransactionData data, Object state, GraphDatabaseService databaseService) {
            this.afterRollbackInvocations.incrementAndGet();
        }
    }
}

