/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.version.VersionStorageTracer;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogFileCreateEvent;
import org.neo4j.kernel.impl.transaction.log.LogFileFlushEvent;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.lock.LockTracer;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class HighestEverClosedTransactionIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private MetadataProvider metadataProvider;
    private PostCommitChecker postCommitCallback;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        this.postCommitCallback = new PostCommitChecker();
        TransactionPostCommitTracers testTracers = new TransactionPostCommitTracers(this.postCommitCallback);
        builder.setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)testTracers));
    }

    @Test
    void closeTransactionBumpHighestEverClosedInfo() {
        long initialId = this.metadataProvider.getHighestEverClosedTransaction().id();
        int numberOfTransactions = 10;
        for (int i = 0; i < numberOfTransactions; ++i) {
            try (Transaction transaction = this.db.beginTx();){
                transaction.createNode();
                transaction.commit();
                continue;
            }
        }
        Assertions.assertEquals((long)(initialId + (long)numberOfTransactions), (long)this.metadataProvider.getHighestEverClosedTransaction().id());
    }

    @Test
    void nonChunkedRolledBackTransactionDoesNotBumpHighestEverClosedInfo() {
        long initialId = this.metadataProvider.getHighestEverClosedTransaction().id();
        int numberOfTransactions = 10;
        for (int i = 0; i < numberOfTransactions; ++i) {
            try (Transaction transaction = this.db.beginTx();){
                transaction.createNode();
                transaction.rollback();
                continue;
            }
        }
        Assertions.assertEquals((long)initialId, (long)this.metadataProvider.getHighestEverClosedTransaction().id());
    }

    @Test
    void initialClosedAndHighestClosedTransactionAreAligned() {
        ClosedTransactionMetadata lastClosedTransaction = this.metadataProvider.getLastClosedTransaction();
        TransactionId highestClosedTransaction = this.metadataProvider.getHighestEverClosedTransaction();
        Assertions.assertEquals((Object)lastClosedTransaction.transactionId(), (Object)highestClosedTransaction);
    }

    @Test
    void highestEverClosedBatchIncrementedOnlyOnClose() {
        TransactionId initialHighestEver = this.metadataProvider.getHighestEverClosedTransaction();
        int numberOfTransactions = 10;
        for (int i = 0; i < numberOfTransactions; ++i) {
            try (Transaction transaction = this.db.beginTx();){
                transaction.createNode();
                TransactionId highestEverClosedTransaction = this.metadataProvider.getHighestEverClosedTransaction();
                this.postCommitCallback.setCheck(() -> Assertions.assertEquals((Object)highestEverClosedTransaction, (Object)this.metadataProvider.getHighestEverClosedTransaction()));
                transaction.commit();
                continue;
            }
        }
        TransactionId postTransactionHighestSeen = this.metadataProvider.getHighestEverClosedTransaction();
        Assertions.assertEquals((long)(initialHighestEver.id() + (long)numberOfTransactions), (long)postTransactionHighestSeen.id());
    }

    private static class PostCommitChecker
    implements Runnable {
        private volatile Runnable check;

        private PostCommitChecker() {
        }

        @Override
        public void run() {
            Runnable localCheck = this.check;
            if (localCheck != null) {
                localCheck.run();
            }
        }

        public void setCheck(Runnable check) {
            this.check = check;
        }
    }

    private static class TransactionPostCommitTracers
    implements Tracers {
        private final Runnable postCommitCallback;

        public TransactionPostCommitTracers(Runnable postCommitCallback) {
            this.postCommitCallback = postCommitCallback;
        }

        public PageCacheTracer getPageCacheTracer() {
            return PageCacheTracer.NULL;
        }

        public LockTracer getLockTracer() {
            return LockTracer.NONE;
        }

        public DatabaseTracer getDatabaseTracer(NamedDatabaseId namedDatabaseId) {
            return new DatabaseTransactionPostCommitTracer(this.postCommitCallback);
        }

        public VersionStorageTracer getVersionStorageTracer(NamedDatabaseId namedDatabaseId) {
            return VersionStorageTracer.NULL;
        }

        private static class DatabaseTransactionPostCommitTracer
        implements DatabaseTracer {
            private final Runnable postCommitCallback;

            public DatabaseTransactionPostCommitTracer(Runnable postCommitCallback) {
                this.postCommitCallback = postCommitCallback;
            }

            public LogFileCreateEvent createLogFile() {
                return LogFileCreateEvent.NULL;
            }

            public void openLogFile(Path filePath) {
            }

            public void closeLogFile(Path filePath) {
            }

            public LogAppendEvent logAppend() {
                return LogAppendEvent.NULL;
            }

            public LogFileFlushEvent flushFile() {
                return LogFileFlushEvent.NULL;
            }

            public long numberOfCheckPoints() {
                return 0L;
            }

            public long checkPointAccumulatedTotalTimeMillis() {
                return 0L;
            }

            public long lastCheckpointTimeMillis() {
                return 0L;
            }

            public long lastCheckpointPagesFlushed() {
                return 0L;
            }

            public long lastCheckpointIOs() {
                return 0L;
            }

            public long lastCheckpointIOLimit() {
                return 0L;
            }

            public long lastCheckpointIOLimitedTimes() {
                return 0L;
            }

            public long lastCheckpointIOLimitedMillis() {
                return 0L;
            }

            public long flushedBytes() {
                return 0L;
            }

            public TransactionEvent beginTransaction(CursorContext cursorContext, long transactionSequenceNumber) {
                return new TransactionEvent(){

                    public void setCommit(boolean commit) {
                    }

                    public void setRollback(boolean rollback) {
                    }

                    public TransactionWriteEvent beginCommitEvent() {
                        return new TransactionWriteEvent(){

                            public void close() {
                            }

                            public LogAppendEvent beginLogAppend() {
                                return LogAppendEvent.NULL;
                            }

                            public StoreApplyEvent beginStoreApply() {
                                postCommitCallback.run();
                                return StoreApplyEvent.NULL;
                            }

                            public void chunkAppended(int chunkNumber, long transactionSequenceNumber, long transactionId) {
                            }
                        };
                    }

                    public TransactionWriteEvent beginChunkWriteEvent() {
                        return TransactionWriteEvent.NULL;
                    }

                    public TransactionRollbackEvent beginRollback() {
                        return TransactionRollbackEvent.NULL;
                    }

                    public void close() {
                    }

                    public void setTransactionWriteState(String transactionWriteState) {
                    }

                    public void setReadOnly(boolean wasReadOnly) {
                    }

                    public void refreshVisibilityBoundary() {
                    }
                };
            }

            public TransactionWriteEvent beginAsyncCommit() {
                return TransactionWriteEvent.NULL;
            }

            public TransactionRollbackEvent beginAsyncRollback() {
                return TransactionRollbackEvent.NULL;
            }

            public long appendedBytes() {
                return 0L;
            }

            public long numberOfLogRotations() {
                return 0L;
            }

            public long logRotationAccumulatedTotalTimeMillis() {
                return 0L;
            }

            public long lastLogRotationTimeMillis() {
                return 0L;
            }

            public long numberOfFlushes() {
                return 0L;
            }

            public long lastTransactionLogAppendBatch() {
                return 0L;
            }

            public long batchesAppended() {
                return 0L;
            }

            public long rolledbackBatches() {
                return 0L;
            }

            public long rolledbackBatchedTransactions() {
                return 0L;
            }

            public LogCheckPointEvent beginCheckPoint() {
                return LogCheckPointEvent.NULL;
            }
        }
    }
}

