/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

@TestDirectoryExtension
class DatabaseTransactionShutdownIT {
    @Inject
    TestDirectory directory;
    FakeClock clock = Clocks.fakeClock();
    DatabaseManagementService dbms;
    GraphDatabaseAPI db;

    DatabaseTransactionShutdownIT() {
    }

    @BeforeEach
    void setUp() {
        this.dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ofMillis(0L)).setClock((SystemNanoClock)this.clock).build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        this.shutdownDbms();
    }

    @Test
    void shouldWaitForTransactionToDetectTerminationOnShutdown() throws Exception {
        Duration waitTime = (Duration)((Config)this.db.getDependencyResolver().resolveDependency(Config.class)).get(GraphDatabaseInternalSettings.shutdown_terminated_transaction_wait_timeout);
        try (OtherThreadExecutor executor = new OtherThreadExecutor("test");){
            Transaction tx = this.db.beginTx();
            KernelTransaction ktx = ((TransactionImpl)tx).kernelTransaction();
            tx.createNode();
            Future shutdownFuture = executor.executeDontWait(this::shutdownDbms);
            executor.waitUntilWaiting(details -> details.isAt(AbstractDatabase.class, "awaitAllClosingTransactions"));
            Assertions.assertThat((Optional)ktx.getTerminationMark()).isNotEmpty();
            Assertions.assertThatThrownBy(() -> ((Transaction)tx).createNode()).isInstanceOf(TransactionTerminatedException.class);
            this.clock.forward(waitTime.plusMillis(1L));
            shutdownFuture.get();
            Assertions.assertThatThrownBy(() -> ((Transaction)tx).close()).isInstanceOf(TransactionFailureException.class);
        }
    }

    @Test
    void shouldWaitForTransactionToDetectTerminationAndCloseOnShutdown() throws Exception {
        try (OtherThreadExecutor executor = new OtherThreadExecutor("test");){
            Transaction tx = this.db.beginTx();
            KernelTransaction ktx = ((TransactionImpl)tx).kernelTransaction();
            tx.createNode();
            Future shutdownFuture = executor.executeDontWait(this::shutdownDbms);
            executor.waitUntilWaiting(details -> details.isAt(AbstractDatabase.class, "awaitAllClosingTransactions"));
            Assertions.assertThat((Optional)ktx.getTerminationMark()).isNotEmpty();
            tx.close();
            shutdownFuture.get();
        }
    }

    private Void shutdownDbms() {
        if (this.dbms != null) {
            this.dbms.shutdown();
            this.dbms = null;
        }
        return null;
    }
}

