/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.javacompat.ResultRowImpl;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.index.schema.FailingNativeIndexProviderFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.values.storable.Values;

class DbIndexesFailureMessageIT
extends KernelIntegrationTest {
    DbIndexesFailureMessageIT() {
    }

    @Override
    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder) {
        return super.configure(databaseManagementServiceBuilder.setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false));
    }

    @Test
    void listAllIndexesWithFailedIndex() throws Throwable {
        KernelTransaction dataTransaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        String labelName = "Fail";
        String propertyKey = "foo";
        int failedLabel = dataTransaction.tokenWrite().labelGetOrCreateForName(labelName);
        int propertyKeyId1 = dataTransaction.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
        this.transaction.createNode(new Label[]{Label.label((String)labelName)}).setProperty(propertyKey, (Object)"some value");
        this.commit();
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)failedLabel, (int[])new int[]{propertyKeyId1});
        String indexName = "fail foo index";
        IndexDescriptor index = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FailingNativeIndexProviderFactory.DESCRIPTOR).withName(indexName));
        long indexId = index.getId();
        String indexProvider = index.getIndexProvider().name();
        SortedMap indexConfig = index.getIndexConfig().asMap();
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThatThrownBy(() -> tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES)).isInstanceOf(IllegalStateException.class);
        }
        tx = this.db.beginTx();
        try {
            Result results = tx.execute("SHOW INDEX YIELD * WHERE name = '" + index.getName() + "'");
            Assertions.assertThat((Iterator)results).hasNext();
            ResultRowImpl result = new ResultRowImpl(results.next());
            Assertions.assertThat((Iterator)results).isExhausted();
            ((ObjectAssert)Assertions.assertThat((Object)result.getNumber("id")).as("id", new Object[0])).isEqualTo((Object)indexId);
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("name")).as("name", new Object[0])).isEqualTo(indexName);
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("state")).as("state", new Object[0])).isEqualTo("FAILED");
            ((ObjectAssert)Assertions.assertThat((Object)result.getNumber("populationPercent")).as("populationPercent", new Object[0])).isEqualTo((Object)0.0);
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("owningConstraint")).as("owningConstraint", new Object[0])).isEqualTo(null);
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("type")).as("type", new Object[0])).isEqualTo("RANGE");
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("entityType")).as("entityType", new Object[0])).isEqualTo("NODE");
            ((ListAssert)((ListAssert)Assertions.assertThat((Object)result.get("labelsOrTypes")).asInstanceOf(InstanceOfAssertFactories.LIST)).as("labelsOrTypes", new Object[0])).containsExactly(new Object[]{labelName});
            ((ListAssert)((ListAssert)Assertions.assertThat((Object)result.get("properties")).asInstanceOf(InstanceOfAssertFactories.LIST)).as("properties", new Object[0])).containsExactly(new Object[]{propertyKey});
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("indexProvider")).as("indexProvider", new Object[0])).isEqualTo(indexProvider);
            ((MapAssert)Assertions.assertThat((Object)result.get("options")).extracting("indexConfig", InstanceOfAssertFactories.map(String.class, Object.class))).extractingFromEntries(entry -> Map.entry((String)entry.getKey(), Values.of(entry.getValue()))).as("indexConfig", new Object[0]).containsExactlyInAnyOrderElementsOf(indexConfig.entrySet());
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("failureMessage")).as("failureMessage", new Object[0])).startsWith((CharSequence)"java.lang.RuntimeException: Fail on update during population");
            ((AbstractStringAssert)Assertions.assertThat((String)result.getString("createStatement")).as("createStatement", new Object[0])).contains(new CharSequence[]{"CREATE RANGE INDEX", indexName, "FOR", labelName, "ON", propertyKey});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void indexDetailsWithNonExistingIndex() {
        try (Transaction tx = this.db.beginTx();){
            Result results = tx.execute("SHOW INDEX YIELD * WHERE name = 'MyIndex'");
            Assertions.assertThat((Iterator)results).isExhausted();
        }
    }

    @Override
    protected TestDatabaseManagementServiceBuilder createGraphDatabaseFactory(Path databaseRootDir) {
        return super.createGraphDatabaseFactory(databaseRootDir).noOpSystemGraphInitializer().addExtension((ExtensionFactory)new FailingNativeIndexProviderFactory(new FailingNativeIndexProviderFactory.FailureType[]{FailingNativeIndexProviderFactory.FailureType.POPULATION}));
    }
}

