/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.Subject;
import org.neo4j.internal.batchimport.cache.idmapping.string.Workers;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.Commands;
import org.neo4j.internal.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.CompleteTransaction;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.txid.IdStoreTransactionIdGenerator;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.CompleteCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.storage.RecordStorageEngineSupport;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
class IndexWorkSyncTransactionApplicationStressIT {
    private static final LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)0, (int[])new int[]{0});
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    private final RecordStorageEngineSupport storageEngineRule = new RecordStorageEngineSupport();
    private TransactionCommitmentFactory commitmentFactory;
    private IdStoreTransactionIdGenerator transactionIdGenerator;

    IndexWorkSyncTransactionApplicationStressIT() {
    }

    @BeforeEach
    void setUp() throws Throwable {
        this.storageEngineRule.before();
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        this.commitmentFactory = new TransactionCommitmentFactory((TransactionIdStore)transactionIdStore);
        this.transactionIdGenerator = new IdStoreTransactionIdGenerator((TransactionIdStore)transactionIdStore);
    }

    @AfterEach
    void tearDown() throws Throwable {
        this.storageEngineRule.after(false);
    }

    @Test
    void shouldApplyIndexUpdatesInWorkSyncedBatches() throws Exception {
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "2s"));
        int numThreads = Integer.getInteger(this.getClass().getName() + ".numThreads", Runtime.getRuntime().availableProcessors());
        CollectingIndexUpdateListener index = new CollectingIndexUpdateListener();
        RecordStorageEngine storageEngine = this.storageEngineRule.getWith((FileSystemAbstraction)this.fileSystem, this.pageCache, RecordDatabaseLayout.ofFlat((Path)this.directory.directory("neo4j"))).indexUpdateListener((IndexUpdateListener)index).build();
        try (StoreCursors storageCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            storageEngine.apply((StorageEngineTransaction)IndexWorkSyncTransactionApplicationStressIT.tx(Collections.singletonList(Commands.createIndexRule((IndexProviderDescriptor)AllIndexProviderDescriptors.RANGE_DESCRIPTOR, (long)1L, (LabelSchemaDescriptor)descriptor)), storageCursors, this.commitmentFactory, (TransactionIdGenerator)this.transactionIdGenerator), TransactionApplicationMode.EXTERNAL);
        }
        Workers workers = new Workers(this.getClass().getSimpleName());
        AtomicBoolean end = new AtomicBoolean();
        for (int i = 0; i < numThreads; ++i) {
            workers.start((Runnable)new Worker(i, end, storageEngine, 10, index, this.commitmentFactory, (TransactionIdGenerator)this.transactionIdGenerator));
        }
        Thread.sleep(duration);
        end.set(true);
        workers.awaitAndThrowOnError();
    }

    private static Value propertyValue(int id, int progress) {
        return Values.of((Object)(id + "_" + progress));
    }

    private static CompleteTransaction tx(List<StorageCommand> commands, StoreCursors storeCursors, TransactionCommitmentFactory commitmentFactory, TransactionIdGenerator transactionIdGenerator) {
        CompleteCommandBatch txRepresentation = new CompleteCommandBatch(commands, -1L, -1L, -1L, -1L, -1, LatestVersions.LATEST_KERNEL_VERSION, Subject.ANONYMOUS);
        CompleteTransaction tx = new CompleteTransaction((CommandBatch)txRepresentation, CursorContext.NULL_CONTEXT, storeCursors, commitmentFactory.newCommitment(), transactionIdGenerator);
        tx.batchAppended(2L, new LogPosition(1L, 2L), new LogPosition(3L, 4L), 1);
        return tx;
    }

    private static class CollectingIndexUpdateListener
    extends IndexUpdateListener.Adapter {
        private final ConcurrentMap<Value, Set<Long>> index = new ConcurrentHashMap<Value, Set<Long>>();

        private CollectingIndexUpdateListener() {
        }

        public void applyUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext, boolean parallel) {
            updates.forEach(rawUpdate -> {
                assert (rawUpdate.updateMode() == UpdateMode.ADDED);
                ValueIndexEntryUpdate update = (ValueIndexEntryUpdate)rawUpdate;
                this.index.computeIfAbsent(update.values()[0], value -> ConcurrentHashMap.newKeySet()).add(update.getEntityId());
            });
        }

        void assertHasIndexEntry(Value value, long entityId) {
            Assertions.assertTrue((boolean)this.index.getOrDefault(value, Collections.emptySet()).contains(entityId));
        }
    }

    private static class Worker
    implements Runnable {
        private final int id;
        private final AtomicBoolean end;
        private final RecordStorageEngine storageEngine;
        private final NodeStore nodeIds;
        private final int batchSize;
        private final CollectingIndexUpdateListener index;
        private final TransactionCommitmentFactory commitmentFactory;
        private final TransactionIdGenerator transactionIdGenerator;
        private int i;
        private int base;

        Worker(int id, AtomicBoolean end, RecordStorageEngine storageEngine, int batchSize, CollectingIndexUpdateListener index, TransactionCommitmentFactory commitmentFactory, TransactionIdGenerator transactionIdGenerator) {
            this.id = id;
            this.end = end;
            this.storageEngine = storageEngine;
            this.batchSize = batchSize;
            this.index = index;
            this.commitmentFactory = commitmentFactory;
            this.transactionIdGenerator = transactionIdGenerator;
            NeoStores neoStores = this.storageEngine.testAccessNeoStores();
            this.nodeIds = neoStores.getNodeStore();
        }

        @Override
        public void run() {
            try (RecordStorageReader reader = this.storageEngine.newReader();
                 RecordStorageCommandCreationContext creationContext = this.storageEngine.newCommandCreationContext(false);
                 StoreCursors storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
                creationContext.initialize(LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, CursorContext.NULL_CONTEXT, storeCursors, CommandCreationContext.NO_STARTTIME_OF_OLDEST_TRANSACTION, ResourceLocker.IGNORE, () -> LockTracer.NONE);
                TransactionQueue queue = new TransactionQueue(this.batchSize, tx -> {
                    this.storageEngine.apply(tx, TransactionApplicationMode.EXTERNAL);
                    this.verifyIndex(tx);
                    this.base += this.batchSize;
                });
                while (!this.end.get()) {
                    queue.queue((StorageEngineTransaction)this.createNodeAndProperty(this.i, (StorageReader)reader, (CommandCreationContext)creationContext, storeCursors, this.commitmentFactory, this.transactionIdGenerator));
                    ++this.i;
                }
                queue.applyTransactions();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private CompleteTransaction createNodeAndProperty(int progress, StorageReader reader, CommandCreationContext creationContext, StoreCursors storeCursors, TransactionCommitmentFactory commitmentFactory, TransactionIdGenerator transactionIdGenerator) throws Exception {
            TxState txState = new TxState();
            long nodeId = this.nodeIds.getIdGenerator().nextId(CursorContext.NULL_CONTEXT);
            txState.nodeDoCreate(nodeId);
            txState.nodeDoAddLabel(descriptor.getLabelId(), nodeId);
            txState.nodeDoAddProperty(nodeId, descriptor.getPropertyId(), IndexWorkSyncTransactionApplicationStressIT.propertyValue(this.id, progress));
            List commands = this.storageEngine.createCommands((ReadableTransactionState)txState, reader, creationContext, LockTracer.NONE, TxStateVisitor.NO_DECORATION, CursorContext.NULL_CONTEXT, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            return IndexWorkSyncTransactionApplicationStressIT.tx(commands, storeCursors, commitmentFactory, transactionIdGenerator);
        }

        private void verifyIndex(StorageEngineTransaction tx) throws Exception {
            NodeVisitor visitor = new NodeVisitor();
            int i = 0;
            while (tx != null) {
                tx.commandBatch().accept((Visitor)visitor.clear());
                Value propertyValue = IndexWorkSyncTransactionApplicationStressIT.propertyValue(this.id, this.base + i);
                this.index.assertHasIndexEntry(propertyValue, visitor.nodeId);
                tx = tx.next();
                ++i;
            }
        }
    }

    private static class NodeVisitor
    implements Visitor<StorageCommand, IOException> {
        long nodeId;

        private NodeVisitor() {
        }

        public boolean visit(StorageCommand element) {
            if (element instanceof Command.NodeCommand) {
                this.nodeId = ((Command.NodeCommand)element).getKey();
            }
            return false;
        }

        public NodeVisitor clear() {
            this.nodeId = -1L;
            return this;
        }
    }
}

