/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.token.TokenHolders;

@ExtendWith(value={RandomExtension.class})
@DbmsExtension
public class DynamicIndexStoreViewIT {
    private static final Label PERSON = Label.label((String)"person");
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"friend");
    @Inject
    private RandomSupport random;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private LockManager locks;
    @Inject
    private IndexingService indexingService;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private TokenHolders tokenHolders;
    @Inject
    private JobScheduler scheduler;
    private DynamicIndexStoreView storeView;

    @BeforeEach
    void setUp() {
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists((GraphDatabaseService)this.database);
        this.storeView = new DynamicIndexStoreView(new FullScanStoreView(this.lockService, (ReadableStorageEngine)this.storageEngine, Config.defaults(), this.scheduler), this.locks, this.lockService, Config.defaults(), indexDescriptor -> this.indexingService.getIndexProxy(indexDescriptor), (ReadableStorageEngine)this.storageEngine, (InternalLogProvider)NullLogProvider.getInstance());
    }

    @Test
    void shouldHandleConcurrentDeletionOfTokenIndexRightBeforeNodeScan() throws Exception {
        this.shouldHandleConcurrentDeletionOfTokenIndexRightBeforeScan(this::populateNodes, this::nodeStoreScan);
    }

    @Test
    void shouldHandleConcurrentDeletionOfTokenIndexRightBeforeRelationshipScan() throws Exception {
        this.shouldHandleConcurrentDeletionOfTokenIndexRightBeforeScan(this::populateRelationships, this::relationshipStoreScan);
    }

    private void shouldHandleConcurrentDeletionOfTokenIndexRightBeforeScan(LongSupplier entitiesCreator, Function<TokenScanConsumer, StoreScan> storeScanSupplier) throws Exception {
        entitiesCreator.getAsLong();
        TestTokenScanConsumer consumer = new TestTokenScanConsumer();
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("dropper");){
            Future dropFuture;
            try (StoreScan storeScan = storeScanSupplier.apply((TokenScanConsumer)consumer);){
                dropFuture = t2.executeDontWait(() -> {
                    IndexingTestUtil.dropTokenIndexes((GraphDatabaseService)this.database);
                    return null;
                });
                storeScan.run((StoreScan.ExternalUpdatesCheck)new ContainsExternalUpdates());
            }
            dropFuture.get();
        }
    }

    @Test
    void shouldHandleDeletionOfNodeTokenIndexBeforeScan() {
        this.shouldHandleDeletionOfTokenIndexBeforeScan(this::populateNodes, this::nodeStoreScan);
    }

    @Test
    void shouldHandleDeletionOfRelationshipTokenIndexBeforeScan() {
        this.shouldHandleDeletionOfTokenIndexBeforeScan(this::populateRelationships, this::relationshipStoreScan);
    }

    private void shouldHandleDeletionOfTokenIndexBeforeScan(LongSupplier expectedEntitiesScanned, Function<TokenScanConsumer, StoreScan> storeScanSupplier) {
        long entities = expectedEntitiesScanned.getAsLong();
        TestTokenScanConsumer consumer = new TestTokenScanConsumer();
        IndexingTestUtil.dropTokenIndexes((GraphDatabaseService)this.database);
        try (StoreScan storeScan = storeScanSupplier.apply((TokenScanConsumer)consumer);){
            storeScan.run((StoreScan.ExternalUpdatesCheck)new ContainsExternalUpdates());
            DynamicIndexStoreViewIT.assertScanCompleted(storeScan, consumer, entities);
        }
    }

    @Test
    void nodeLookupIndexDropShouldAwaitStoreScanFinish() throws Exception {
        this.lookupIndexDropShouldAwaitStoreScanFinish(this::populateNodes, this::nodeStoreScan);
    }

    @Test
    void relationshipLookupIndexDropShouldAwaitStoreScanFinish() throws Exception {
        this.lookupIndexDropShouldAwaitStoreScanFinish(this::populateRelationships, this::relationshipStoreScan);
    }

    private void lookupIndexDropShouldAwaitStoreScanFinish(LongSupplier entitiesCreator, Function<TokenScanConsumer, StoreScan> storeScanSupplier) throws Exception {
        long entities = entitiesCreator.getAsLong();
        final Barrier.Control barrier = new Barrier.Control();
        TestTokenScanConsumer consumer = new TestTokenScanConsumer(new TestTokenScanConsumer.Monitor(){
            private final AtomicBoolean first = new AtomicBoolean(true);

            public void recordAdded(long entityId, int[] tokens) {
                if (this.first.getAndSet(false)) {
                    barrier.reached();
                }
            }
        });
        StoreScan storeScan = storeScanSupplier.apply((TokenScanConsumer)consumer);
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("T2");
             OtherThreadExecutor t3 = new OtherThreadExecutor("T3");){
            Future scan = t2.executeDontWait(() -> {
                storeScan.run((StoreScan.ExternalUpdatesCheck)new ContainsExternalUpdates());
                return null;
            });
            barrier.await();
            Future drop = t3.executeDontWait(() -> {
                IndexingTestUtil.dropTokenIndexes((GraphDatabaseService)this.database);
                return null;
            });
            t3.waitUntilWaiting(waitDetails -> waitDetails.isAt(Operations.class, "indexDrop"));
            barrier.release();
            scan.get();
            storeScan.close();
            drop.get();
        }
        DynamicIndexStoreViewIT.assertScanCompleted(storeScan, consumer, entities);
    }

    private static void assertScanCompleted(StoreScan storeScan, TestTokenScanConsumer consumer, long entities) {
        Assertions.assertThat((float)storeScan.getProgress().getProgress()).isEqualTo(1.0f);
        Assertions.assertThat((long)consumer.consumedEntities()).isEqualTo(entities);
    }

    private StoreScan nodeStoreScan(TokenScanConsumer consumer) {
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)new DefaultPageCacheTracer(), FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        return this.storeView.visitNodes(this.getLabelIds(), PropertySelection.ALL_PROPERTIES, null, consumer, false, true, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private StoreScan relationshipStoreScan(TokenScanConsumer consumer) {
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)new DefaultPageCacheTracer(), FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        return this.storeView.visitRelationships(this.getRelationTypeIds(), PropertySelection.ALL_PROPERTIES, null, consumer, false, true, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private int[] getLabelIds() {
        return new int[]{this.tokenHolders.labelTokens().getIdByName(PERSON.name())};
    }

    private int[] getRelationTypeIds() {
        return new int[]{this.tokenHolders.relationshipTypeTokens().getIdByName(FRIEND.name())};
    }

    private long populateNodes() {
        long nodes = Configuration.DEFAULT.batchSize() + 100;
        try (Transaction tx = this.database.beginTx();){
            int i = 0;
            while ((long)i < nodes) {
                tx.createNode(new Label[]{PERSON});
                ++i;
            }
            tx.commit();
        }
        return nodes;
    }

    private long populateRelationships() {
        long relations = Configuration.DEFAULT.batchSize() + 100;
        try (Transaction tx = this.database.beginTx();){
            int i = 0;
            while ((long)i < relations) {
                tx.createNode(new Label[]{PERSON}).createRelationshipTo(tx.createNode(new Label[]{PERSON}), FRIEND);
                ++i;
            }
            tx.commit();
        }
        return relations;
    }

    private class ContainsExternalUpdates
    implements StoreScan.ExternalUpdatesCheck {
        private ContainsExternalUpdates() {
        }

        public boolean needToApplyExternalUpdates() {
            return DynamicIndexStoreViewIT.this.random.nextBoolean();
        }

        public void applyExternalUpdates(long id) {
        }
    }
}

