/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;

public class SchemaAcceptanceTestBase {
    protected final String propertyKey = "my_property_key";
    protected final String secondPropertyKey = "my_second_property_key";
    protected final String propertyKeyWithBackticks = "``backticked_property_key";
    protected final Label label = Label.label((String)"MY_LABEL");
    protected final Label labelWithBackticks = Label.label((String)"``BACKTICK`LABEL`");
    protected final RelationshipType relType = RelationshipType.withName((String)"relType");

    protected static <EXCEPTION extends Throwable, CAUSE extends Throwable> void assertExpectedException(EXCEPTION exception, Class<CAUSE> expectedCause, String ... expectedMessageParts) {
        Throwable cause = exception.getCause();
        org.junit.jupiter.api.Assertions.assertEquals(expectedCause, cause.getClass(), (String)("Expected cause to be of type " + expectedCause + " but was " + cause.getClass()));
        Assertions.assertThat((String)exception.getMessage()).contains((CharSequence[])expectedMessageParts);
    }

    protected void dropIndexBackedConstraintAndCreateSimilarInSameTxMustThrow(GraphDatabaseService db, ConstraintCreateOperation initial, ConstraintCreateOperation similar) {
        String nameA = "nameA";
        String nameB = "nameB";
        try (Transaction tx = db.beginTx();){
            initial.createConstraint(tx.schema(), "my_property_key", nameA);
            tx.commit();
        }
        UnsupportedOperationException e = (UnsupportedOperationException)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            try (Transaction tx = db.beginTx();){
                tx.schema().getConstraintByName(nameA).drop();
                similar.createConstraint(tx.schema(), "my_property_key", nameB);
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining(String.format("Trying to create constraint '%s' in same transaction as dropping '%s'. This is not supported because they are both backed by similar indexes. Please drop constraint in a separate transaction before creating the new one.", nameB, nameA));
    }

    protected void dropIndexBackedConstraintAndCreateSlightlyDifferentInSameTxMustSucceed(GraphDatabaseService db, ConstraintCreateOperation initial, ConstraintCreateOperation similar) {
        String nameA = "nameA";
        String nameB = "nameB";
        try (Transaction tx = db.beginTx();){
            initial.createConstraint(tx.schema(), "my_property_key", nameA);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().getConstraintByName(nameA).drop();
            similar.createConstraint(tx.schema(), "my_second_property_key", nameB);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getConstraintByName(nameA));
            tx.schema().getConstraintByName(nameB);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @FunctionalInterface
    protected static interface ConstraintCreateOperation {
        public ConstraintDefinition createConstraint(Schema var1, String var2, String var3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum SchemaTxStrategy {
        SEPARATE_TX{

            @Override
            public <EXCEPTION extends Throwable> EXCEPTION execute(GraphDatabaseService db, Consumer<Schema> firstSchemaRule, Consumer<Schema> secondSchemaRule, Class<EXCEPTION> expectedException) {
                try (Transaction tx = db.beginTx();){
                    firstSchemaRule.accept(tx.schema());
                    tx.commit();
                }
                return (EXCEPTION)org.junit.jupiter.api.Assertions.assertThrows(expectedException, () -> {
                    try (Transaction tx = db.beginTx();){
                        secondSchemaRule.accept(tx.schema());
                        tx.commit();
                    }
                });
            }
        }
        ,
        SAME_TX{

            @Override
            public <EXCEPTION extends Throwable> EXCEPTION execute(GraphDatabaseService db, Consumer<Schema> firstSchemaRule, Consumer<Schema> secondSchemaRule, Class<EXCEPTION> expectedException) {
                return (EXCEPTION)org.junit.jupiter.api.Assertions.assertThrows(expectedException, () -> {
                    try (Transaction tx = db.beginTx();){
                        firstSchemaRule.accept(tx.schema());
                        secondSchemaRule.accept(tx.schema());
                        tx.commit();
                    }
                });
            }
        };


        public abstract <EXCEPTION extends Throwable> EXCEPTION execute(GraphDatabaseService var1, Consumer<Schema> var2, Consumer<Schema> var3, Class<EXCEPTION> var4);
    }
}

