/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.assertj.core.util.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ConcurrentCreateDropIndexIT {
    private final int threads = Runtime.getRuntime().availableProcessors();
    private static final String KEY = "key";
    @Inject
    private GraphDatabaseAPI db;

    ConcurrentCreateDropIndexIT() {
    }

    @BeforeEach
    void createTokens() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < this.threads; ++i) {
                tx.createNode(new Label[]{ConcurrentCreateDropIndexIT.label(i)}).setProperty(KEY, (Object)i);
            }
            tx.commit();
        }
    }

    @Test
    void concurrentCreatingOfIndexesShouldNotInterfere() throws Throwable {
        Race race = new Race();
        for (int i2 = 0; i2 < this.threads; ++i2) {
            race.addContestant(this.indexCreate(i2), 1);
        }
        race.go();
        try (Transaction tx = this.db.beginTx();){
            List<IndexDefinition> indexes = IntStream.range(0, this.threads).mapToObj(i -> (IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes(ConcurrentCreateDropIndexIT.label(i)))).toList();
            HashSet<String> labels = new HashSet<String>();
            for (IndexDefinition index : indexes) {
                Assertions.assertTrue((boolean)labels.add(((Label)Iterables.single((Iterable)index.getLabels())).name()));
            }
            tx.commit();
        }
    }

    @Test
    void concurrentDroppingOfIndexesShouldNotInterfere() throws Throwable {
        long initialIndexCount;
        ArrayList<IndexDefinition> indexes = new ArrayList<IndexDefinition>();
        try (Transaction tx = this.db.beginTx();){
            initialIndexCount = Streams.stream((Iterable)tx.schema().getIndexes()).count();
            for (int i = 0; i < this.threads; ++i) {
                indexes.add(ConcurrentCreateDropIndexIT.indexCreate(tx, i));
            }
            tx.commit();
        }
        Race race = new Race();
        for (IndexDefinition index : indexes) {
            race.addContestant(this.indexDrop(index), 1);
        }
        race.go();
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertEquals((long)initialIndexCount, (long)Iterables.asList((Iterable)tx.schema().getIndexes()).size());
            tx.commit();
        }
    }

    @Test
    void concurrentMixedCreatingAndDroppingOfIndexesShouldNotInterfere() throws Throwable {
        ArrayList<IndexDefinition> indexesToDrop = new ArrayList<IndexDefinition>();
        int creates = this.threads / 2;
        int drops = this.threads - creates;
        try (Transaction tx = this.db.beginTx();){
            for (int i2 = 0; i2 < drops; ++i2) {
                indexesToDrop.add(ConcurrentCreateDropIndexIT.indexCreate(tx, i2));
            }
            tx.commit();
        }
        Race race = new Race();
        HashSet<String> expectedIndexedLabels = new HashSet<String>();
        for (int i3 = 0; i3 < creates; ++i3) {
            expectedIndexedLabels.add(ConcurrentCreateDropIndexIT.label(drops + i3).name());
            race.addContestant(this.indexCreate(drops + i3), 1);
        }
        for (IndexDefinition index : indexesToDrop) {
            race.addContestant(this.indexDrop(index), 1);
        }
        race.go();
        try (Transaction tx = this.db.beginTx();){
            List<IndexDefinition> indexes = IntStream.range(drops, drops + creates).mapToObj(i -> (IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes(ConcurrentCreateDropIndexIT.label(i)))).toList();
            for (IndexDefinition index : indexes) {
                Assertions.assertTrue((boolean)expectedIndexedLabels.remove(((Label)Iterables.single((Iterable)index.getLabels())).name()));
            }
            tx.commit();
        }
    }

    @Test
    void concurrentCreatingUniquenessConstraint() throws Throwable {
        Race race = new Race().withMaxDuration(10L, TimeUnit.SECONDS);
        Label label = ConcurrentCreateDropIndexIT.label(0);
        race.addContestants(10, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(label).assertPropertyIsUnique(KEY).create();
                tx.commit();
            }
            catch (ConstraintViolationException | TransientFailureException throwable) {
                // empty catch block
            }
        }, 300);
        race.go();
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)tx.schema().getConstraints(label));
            Assertions.assertNotNull((Object)constraint);
            IndexDefinition index = (IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes(label));
            Assertions.assertNotNull((Object)index);
            tx.commit();
        }
    }

    @Test
    void concurrentCreatingUniquenessConstraintOnNonUniqueData() throws Throwable {
        Label label = ConcurrentCreateDropIndexIT.label(0);
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                tx.createNode(new Label[]{label}).setProperty(KEY, (Object)"A");
            }
            tx.commit();
        }
        Race race = new Race().withMaxDuration(10L, TimeUnit.SECONDS);
        race.addContestants(3, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(label).assertPropertyIsUnique(KEY).create();
                tx.commit();
            }
            catch (ConstraintViolationException | TransientFailureException throwable) {
                // empty catch block
            }
        }, 100);
        race.go();
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.singleOrNull((Iterable)tx.schema().getConstraints(label));
            Assertions.assertNull((Object)constraint);
            IndexDefinition index = (IndexDefinition)Iterables.singleOrNull((Iterable)tx.schema().getIndexes(label));
            Assertions.assertNull((Object)index);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void concurrentCreatingAndAwaitingIndexesOnline() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> indexCreate = executor.submit(() -> {
                try (Transaction tx = this.db.beginTx();){
                    ConcurrentCreateDropIndexIT.indexCreate(tx, 0);
                    tx.commit();
                }
            });
            while (!indexCreate.isDone()) {
                Transaction tx = this.db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                    tx.commit();
                }
                finally {
                    if (tx == null) continue;
                    tx.close();
                }
            }
            indexCreate.get();
        }
        finally {
            executor.shutdown();
        }
    }

    private Runnable indexCreate(int labelIndex) {
        return () -> {
            try (Transaction tx = this.db.beginTx();){
                ConcurrentCreateDropIndexIT.indexCreate(tx, labelIndex);
                tx.commit();
            }
        };
    }

    private static IndexDefinition indexCreate(Transaction tx, int labelIndex) {
        return tx.schema().indexFor(ConcurrentCreateDropIndexIT.label(labelIndex)).on(KEY).create();
    }

    private Runnable indexDrop(IndexDefinition index) {
        return () -> {
            while (true) {
                try (Transaction tx = this.db.beginTx();){
                    tx.schema().getIndexByName(index.getName()).drop();
                    tx.commit();
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        };
    }

    private static Label label(int i) {
        return Label.label((String)("L" + i));
    }
}

