/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.ByteUnit;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class DiagnosticsLoggingTest {
    DiagnosticsLoggingTest() {
    }

    @Test
    void shouldSeeExpectedDiagnostics() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().setInternalLogProvider((InternalLogProvider)logProvider).impermanent().setConfig(GraphDatabaseInternalSettings.dump_configuration, (Object)true).setConfig(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)4L)).setConfig(GraphDatabaseInternalSettings.dump_diagnostics, (Object)true).build();
        try {
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Network information", "Local timezone", "Page cache: 4.00MiB"});
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"EXTERNAL_STORE_UUID"}).containsMessages(new String[]{"DATABASE_ID"}).containsMessages(new String[]{"LEGACY_STORE_VERSION"}).containsMessages(new String[]{"STORE_ID"});
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Transaction log", "TimeZone version: "});
        }
        finally {
            managementService.shutdown();
        }
    }
}

