/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

class TestNeo4j
extends AbstractNeo4jTestCase {
    TestNeo4j() {
    }

    @Test
    void testBasicNodeRelationships() {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            ResourceIterator iterator;
            Node firstNode = transaction.createNode();
            Assertions.assertNotNull((Object)firstNode, (String)"Failure creating first node");
            Node secondNode = transaction.createNode();
            Assertions.assertNotNull((Object)secondNode, (String)"Failure creating second node");
            Relationship rel = firstNode.createRelationshipTo(secondNode, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertNotNull((Object)rel, (String)"Relationship is null");
            RelationshipType relType = rel.getType();
            Assertions.assertNotNull((Object)relType, (String)"Relationship's type is is null");
            try (ResourceIterable relationships = firstNode.getRelationships(new RelationshipType[]{relType});){
                iterator = relationships.iterator();
                try {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
            }
            relationships = secondNode.getRelationships(new RelationshipType[]{relType});
            try {
                iterator = relationships.iterator();
                try {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
            }
            finally {
                if (relationships != null) {
                    relationships.close();
                }
            }
            ResourceIterable allRels = firstNode.getRelationships();
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            allRels = firstNode.getRelationships(new RelationshipType[]{relType});
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            allRels = secondNode.getRelationships();
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            allRels = secondNode.getRelationships(new RelationshipType[]{relType});
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            Object[] relNodes = rel.getNodes();
            Assertions.assertEquals((int)2, (int)relNodes.length, (String)"A relationship should always be connected to exactly two nodes");
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInArray(firstNode, relNodes), (String)"Relationship says that it isn't connected to firstNode");
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInArray(secondNode, relNodes), (String)"Relationship says that it isn't connected to secondNode");
            Assertions.assertEquals((Object)rel.getOtherNode(firstNode), (Object)secondNode, (String)"The other node should be secondNode but it isn't");
            Assertions.assertEquals((Object)rel.getOtherNode(secondNode), (Object)firstNode, (String)"The other node should be firstNode but it isn't");
            rel.delete();
            secondNode.delete();
            firstNode.delete();
            transaction.commit();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean objectExistsInIterable(Relationship rel, ResourceIterable<Relationship> allRels) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean objectExistsInArray(Object obj, Object[] objArray) {
        for (Object o : objArray) {
            if (!o.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Test
    void testRandomPropertyName() {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.createNode();
            String key = "random_" + new Random(System.currentTimeMillis()).nextLong();
            node1.setProperty(key, (Object)"value");
            Assertions.assertEquals((Object)"value", (Object)node1.getProperty(key));
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testNodeChangePropertyArray() {
        Node node;
        try (Transaction tx = this.getGraphDb().beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = this.getGraphDb().beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("test", (Object)new String[]{"value1"});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.getGraphDb().beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("test", (Object)new String[]{"value1", "value2"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.getGraphDb().beginTx();
        try {
            String[] value = (String[])tx.getNodeById(node.getId()).getProperty("test");
            Assertions.assertEquals((int)1, (int)value.length);
            Assertions.assertEquals((Object)"value1", (Object)value[0]);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testGetAllNodes() {
        long highId = this.getIdGenerator((IdType)RecordIdType.NODE).getHighestPossibleIdInUse();
        if (highId >= 0L && highId < 10000L) {
            ResourceIterable allNodes;
            Node newNode;
            long count;
            boolean found = false;
            try (Transaction transaction = this.getGraphDb().beginTx();){
                count = Iterables.count((Iterable)transaction.getAllNodes());
                newNode = transaction.createNode();
                transaction.commit();
            }
            long oldCount = count;
            count = 0L;
            try (Transaction transaction = this.getGraphDb().beginTx();){
                allNodes = transaction.getAllNodes();
                try {
                    for (Node node : allNodes) {
                        ++count;
                        if (!node.equals(newNode)) continue;
                        found = true;
                    }
                }
                finally {
                    if (allNodes != null) {
                        allNodes.close();
                    }
                }
                Assertions.assertTrue((boolean)found);
                Assertions.assertEquals((long)count, (long)(oldCount + 1L));
                allNodes = transaction.getAllNodes();
                try (ResourceIterator allNodesIterator = allNodes.iterator();){
                    Assertions.assertNotNull((Object)allNodesIterator.next());
                }
                finally {
                    if (allNodes != null) {
                        allNodes.close();
                    }
                }
                transaction.getNodeById(newNode.getId()).delete();
                transaction.commit();
            }
            found = false;
            transaction = this.getGraphDb().beginTx();
            try {
                allNodes = transaction.getAllNodes();
                try {
                    count = 0L;
                    for (Node node : allNodes) {
                        ++count;
                        if (!node.equals(newNode)) continue;
                        found = true;
                    }
                    Assertions.assertFalse((boolean)found);
                    Assertions.assertEquals((long)count, (long)oldCount);
                    transaction.commit();
                }
                finally {
                    if (allNodes != null) {
                        allNodes.close();
                    }
                }
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    @Test
    void testMultipleShutdown() {
        this.getManagementService().shutdown();
        this.getManagementService().shutdown();
    }
}

