/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexScanPartitionedScanTestSuite;

abstract class RelationshipPropertyIndexScanPartitionedScanTestSuite
extends PropertyIndexScanPartitionedScanTestSuite<RelationshipValueIndexCursor> {
    RelationshipPropertyIndexScanPartitionedScanTestSuite(PropertyIndexPartitionedScanTestSuite.TestIndexType index) {
        super(index);
    }

    public final PartitionedScanFactories.RelationshipPropertyIndexScan getFactory() {
        return PartitionedScanFactories.RelationshipPropertyIndexScan.FACTORY;
    }

    @Nested
    class WithData
    extends PropertyIndexScanPartitionedScanTestSuite.WithData<RelationshipValueIndexCursor> {
        WithData() {
            super(RelationshipPropertyIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> setupDatabase() {
            boolean numberOfRelTypes = true;
            int numberOfPropKeys = 2;
            int numberOfProperties = 4096;
            int relTypeId = this.createTokens(1, this.factory.getTokenSupplier())[0];
            int[] propKeyIds = this.createTokens(2, this.factory.getPropKeySupplier());
            PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> data = this.createData(4096, relTypeId, propKeyIds);
            this.createIndexes(RelationshipPropertyIndexScanPartitionedScanTestSuite.this.createIndexPrototypes(relTypeId, propKeyIds));
            return data;
        }

        @Override
        protected PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> createData(int numberOfProperties, int relTypeId, int[] propKeyIds) {
            PartitionedScanTestSuite.EntityIdsMatchingQuery<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> relsInIndex = new PartitionedScanTestSuite.EntityIdsMatchingQuery<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery>();
            PrimitiveIterator.OfInt propValues = this.random.ints((long)numberOfProperties).iterator();
            int numberOfCreatedProperties = 0;
            try (KernelTransaction tx = this.beginTx();){
                Write write = tx.dataWrite();
                while (propValues.hasNext()) {
                    PropertyIndexPartitionedScanTestSuite.PropertyRecord[] assignedProperties = new PropertyIndexPartitionedScanTestSuite.PropertyRecord[propKeyIds.length];
                    long relId = write.relationshipCreate(write.nodeCreate(), relTypeId, write.nodeCreate());
                    for (int i = 0; i < propKeyIds.length; ++i) {
                        if (!propValues.hasNext()) continue;
                        PropertyIndexPartitionedScanTestSuite.PropertyRecord prop = PropertyIndexPartitionedScanTestSuite.createRandomPropertyRecord(this.random, propKeyIds[i], propValues.next());
                        write.relationshipSetProperty(relId, prop.id(), prop.value());
                        ++numberOfCreatedProperties;
                        assignedProperties[i] = prop;
                        relsInIndex.getOrCreate(new PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery(this.factory.getIndexName(relTypeId, prop.id()))).add(relId);
                    }
                    if (!Arrays.stream(assignedProperties).allMatch(Objects::nonNull)) continue;
                    relsInIndex.getOrCreate(new PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery(this.factory.getIndexName(relTypeId, propKeyIds))).add(relId);
                }
                tx.commit();
            }
            catch (KernelException e) {
                throw new AssertionError("failed to create database", e);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCreatedProperties).as("node properties created", new Object[0])).isEqualTo(numberOfProperties);
            return new PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery>(relsInIndex);
        }
    }

    @Nested
    class WithoutData
    extends PropertyIndexScanPartitionedScanTestSuite.WithoutData<RelationshipValueIndexCursor> {
        WithoutData() {
            super(RelationshipPropertyIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> setupDatabase() {
            boolean numberOfRelTypes = true;
            int numberOfPropKeys = 2;
            int relTypeId = this.createTokens(1, this.factory.getTokenSupplier())[0];
            int[] propKeyIds = this.createTokens(2, this.factory.getPropKeySupplier());
            PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> data = this.emptyQueries(relTypeId, propKeyIds);
            this.createIndexes(RelationshipPropertyIndexScanPartitionedScanTestSuite.this.createIndexPrototypes(relTypeId, propKeyIds));
            return data;
        }
    }
}

