/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import blue.strategic.parquet.Dehydrator;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.LocalOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.internal.batchimport.DefaultAdditionalIds;
import org.neo4j.internal.batchimport.ParallelBatchImporter;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.parquet.ParquetInput;
import org.neo4j.internal.batchimport.input.parquet.ParquetMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class ParquetInputBatchImportIT {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    private static final int GENERATED_NODE_COUNT = 4096;
    private static final int GENERATED_RELATIONSHIP_COUNT = 12288;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private RandomSupport random;
    @Inject
    private RecordDatabaseLayout databaseLayout;
    private static final Supplier<ZoneId> testDefaultTimeZone = () -> ZoneId.of("Asia/Shanghai");

    ParquetInputBatchImportIT() {
    }

    @Test
    void shouldImportDataComingFromParquetFiles() throws Exception {
        Config dbConfig = Config.newBuilder().set(GraphDatabaseSettings.db_timezone, (Object)LogTimeZone.SYSTEM).set(GraphDatabaseSettings.dense_node_threshold, (Object)5).build();
        try (ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();){
            ParallelBatchImporter importer = new ParallelBatchImporter((DatabaseLayout)this.databaseLayout, this.fileSystem, PageCacheTracer.NULL, ParquetInputBatchImportIT.smallBatchSizeConfig(), (LogService)NullLogService.getInstance(), ExecutionMonitor.INVISIBLE, DefaultAdditionalIds.EMPTY, (LogTailMetadata)new EmptyLogTailMetadata(dbConfig), dbConfig, Monitor.NO_MONITOR, (JobScheduler)scheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, CursorContextFactory.NULL_CONTEXT_FACTORY);
            Groups groups = new Groups();
            Group group = groups.getOrCreate(null);
            List<InputEntity> nodeData = this.randomNodeData(group);
            List<InputEntity> relationshipData = this.randomRelationshipData(nodeData, group);
            importer.doImport(ParquetInputBatchImportIT.parquet(this.nodeDataAsFile(nodeData), this.relationshipDataAsFile(relationshipData), IdType.STRING, groups));
            this.verifyImportedData(nodeData, relationshipData);
        }
    }

    static Input parquet(Path nodes, Path relationships, IdType idType, Groups groups) {
        Path[] nodeArray = List.of(nodes).toArray(new Path[0]);
        Path[] relationshipArray = List.of(relationships).toArray(new Path[0]);
        return new ParquetInput(Map.of(Set.of(""), Collections.singletonList(nodeArray)), Map.of("", Collections.singletonList(relationshipArray)), idType, Character.valueOf(';'), groups, new ParquetMonitor(System.out));
    }

    private static org.neo4j.csv.reader.Configuration lowBufferSize(org.neo4j.csv.reader.Configuration actual) {
        return actual.toBuilder().withBufferSize(10000).build();
    }

    private List<InputEntity> randomNodeData(Group group) {
        ArrayList<InputEntity> nodes = new ArrayList<InputEntity>();
        for (int i = 0; i < 4096; ++i) {
            InputEntity node = new InputEntity();
            node.id((Object)UUID.randomUUID().toString(), group);
            node.property("name", (Object)("Node " + i));
            node.property("pointA", (Object)("\"   { x : -4.2, y : " + i % 90 + ", crs: WGS-84 } \""));
            node.property("pointB", (Object)("\" { x : -8, y : " + i + " } \""));
            node.property("date", (Object)LocalDate.of(2018, i % 12 + 1, i % 28 + 1));
            node.property("time", (Object)OffsetTime.of(1, i % 60, 0, 0, ZoneOffset.ofHours(9)));
            node.property("dateTime", (Object)ZonedDateTime.of(2011, 9, 11, 8, i % 60, 0, 0, ZoneId.of("Europe/Stockholm")));
            node.property("dateTime2", (Object)LocalDateTime.of(2011, 9, 11, 8, i % 60, 0, 0));
            node.property("localTime", (Object)LocalTime.of(1, i % 60, 0));
            node.property("localDateTime", (Object)LocalDateTime.of(2011, 9, 11, 8, i % 60));
            node.property("duration", (Object)Period.of(2, -3, i % 30));
            node.property("floatArray", (Object)new float[]{1.0f, 2.0f, 3.0f});
            node.property("dateArray", (Object)new LocalDate[]{LocalDate.of(2018, i % 12 + 1, i % 28 + 1)});
            node.property("pointArray", (Object)("\" { x : -8, y : " + i + " } \""));
            node.labels(ParquetInputBatchImportIT.randomLabels(this.random.random()));
            nodes.add(node);
        }
        return nodes;
    }

    private static String[] randomLabels(Random random) {
        String[] labels = new String[random.nextInt(3)];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "Label" + random.nextInt(4);
        }
        return labels;
    }

    private static Configuration smallBatchSizeConfig() {
        return Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)100);
    }

    private Path relationshipDataAsFile(List<InputEntity> relationshipData) throws IOException {
        Path file = this.testDirectory.file("relationships.parquet");
        PrimitiveType startId = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(":START_ID");
        PrimitiveType endId = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(":END_ID");
        Type type = (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(":TYPE");
        ParquetWriter writer = ((BasicParquetWriterBuilder)new BasicParquetWriterBuilder((OutputFile)new TestOutputFile(file)).withRowGroupSize(1024L)).withType(new MessageType("Some Data", new Type[]{startId, endId, type})).withDehydrator((record, valueWriter) -> {
            Object[] relationship = (Object[])record;
            valueWriter.write(":START_ID", relationship[0]);
            valueWriter.write(":END_ID", relationship[1]);
            valueWriter.write(":TYPE", relationship[2]);
        }).build();
        for (InputEntity relationshipDatum : relationshipData) {
            writer.write((Object)new Object[]{relationshipDatum.startId(), relationshipDatum.endId(), relationshipDatum.type()});
        }
        writer.close();
        return file;
    }

    private Path nodeDataAsFile(List<InputEntity> nodeData) throws IOException {
        Path file = this.testDirectory.file("nodes.parquet");
        List<String> knownProperties = List.of("name");
        Type idType = (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(":ID");
        Type labelsType = (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(":LABEL");
        Type nameType = (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name");
        ParquetWriter writer = ((BasicParquetWriterBuilder)new BasicParquetWriterBuilder((OutputFile)new TestOutputFile(file)).withRowGroupSize(1024L)).withType(new MessageType("Some Data", new Type[]{idType, labelsType, nameType})).withDehydrator((record, valueWriter) -> {
            InputEntity node = (InputEntity)record;
            valueWriter.write(":ID", node.id());
            valueWriter.write(":LABEL", (Object)String.join((CharSequence)";", node.labels()));
            node.propertiesAsMap().forEach((name, value) -> {
                if (knownProperties.contains(name)) {
                    valueWriter.write(name, value);
                }
            });
        }).build();
        for (InputEntity nodeDatum : nodeData) {
            writer.write((Object)nodeDatum);
        }
        writer.close();
        return file;
    }

    private List<InputEntity> randomRelationshipData(List<InputEntity> nodeData, Group group) {
        ArrayList<InputEntity> relationships = new ArrayList<InputEntity>();
        for (int i = 0; i < 12288; ++i) {
            InputEntity relationship = new InputEntity();
            relationship.startId(nodeData.get(this.random.nextInt(nodeData.size())).id(), group);
            relationship.endId(nodeData.get(this.random.nextInt(nodeData.size())).id(), group);
            relationship.type("TYPE_" + this.random.nextInt(3));
            relationships.add(relationship);
        }
        return relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyImportedData(List<InputEntity> nodeData, List<InputEntity> relationshipData) {
        HashMap<String, InputEntity> expectedNodes = new HashMap<String, InputEntity>();
        HashMap<String, String[]> expectedNodeNames = new HashMap<String, String[]>();
        HashMap<String, Map<String, Consumer<Object>>> expectedNodePropertyVerifiers = new HashMap<String, Map<String, Consumer<Object>>>();
        AutoCreatingHashMap expectedRelationships = new AutoCreatingHashMap(AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.values(AtomicInteger.class))));
        AutoCreatingHashMap expectedNodeCounts = new AutoCreatingHashMap(AutoCreatingHashMap.values(AtomicLong.class));
        AutoCreatingHashMap expectedRelationshipCounts = new AutoCreatingHashMap(AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.values(AtomicLong.class))));
        ParquetInputBatchImportIT.buildUpExpectedData(nodeData, relationshipData, expectedNodes, expectedNodeNames, expectedNodePropertyVerifiers, (Map<String, Map<String, Map<String, AtomicInteger>>>)expectedRelationships, (Map<String, AtomicLong>)expectedNodeCounts, (Map<String, Map<String, Map<String, AtomicLong>>>)expectedRelationshipCounts);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();
             ResourceIterable allNodes = tx.getAllNodes();){
            for (Node node : allNodes) {
                String name = (String)node.getProperty("name");
                Object[] labels = (String[])expectedNodeNames.remove(name);
                org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])labels), ParquetInputBatchImportIT.names(node.getLabels()));
                Map expectedPropertyVerifiers = (Map)expectedNodePropertyVerifiers.remove(name);
                Map map = node.getAllProperties();
                map.remove("id");
                for (Map.Entry actualProperty : map.entrySet()) {
                    Consumer v = (Consumer)expectedPropertyVerifiers.get(actualProperty.getKey());
                    if (v == null) continue;
                    v.accept(actualProperty.getValue());
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expectedNodeNames.size());
            try (ResourceIterable allRelationships = tx.getAllRelationships();){
                for (Relationship relationship : allRelationships) {
                    String startNodeName = (String)relationship.getStartNode().getProperty("name");
                    Map inner = (Map)expectedRelationships.get(startNodeName);
                    String string = (String)relationship.getEndNode().getProperty("name");
                    Map innerInner = (Map)inner.get(string);
                    String type = relationship.getType().name();
                    int countAfterwards = ((AtomicInteger)innerInner.get(type)).decrementAndGet();
                    Assertions.assertThat((int)countAfterwards).isGreaterThanOrEqualTo(0);
                    if (countAfterwards != 0) continue;
                    innerInner.remove(type);
                    if (!innerInner.isEmpty()) continue;
                    inner.remove(string);
                    if (!inner.isEmpty()) continue;
                    expectedRelationships.remove(startNodeName);
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expectedRelationships.size());
            RecordStorageEngine storageEngine = (RecordStorageEngine)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = storageEngine.testAccessNeoStores();
            CountsStore counts = storageEngine.countsAccessor();
            Function<String, Integer> labelTranslationTable = ParquetInputBatchImportIT.translationTable(neoStores.getLabelTokenStore(), -1, storageEngine);
            for (Pair pair : ParquetInputBatchImportIT.allNodeCounts(labelTranslationTable, (Map<String, AtomicLong>)expectedNodeCounts)) {
                org.junit.jupiter.api.Assertions.assertEquals((long)((Long)pair.other()), (long)counts.nodeCount(((Integer)pair.first()).intValue(), CursorContext.NULL_CONTEXT), (String)("Label count mismatch for label " + pair.first()));
            }
            Function<String, Integer> relationshipTypeTranslationTable = ParquetInputBatchImportIT.translationTable(neoStores.getRelationshipTypeTokenStore(), -1, storageEngine);
            for (Pair<RelationshipCountKey, Long> count : ParquetInputBatchImportIT.allRelationshipCounts(labelTranslationTable, relationshipTypeTranslationTable, (Map<String, Map<String, Map<String, AtomicLong>>>)expectedRelationshipCounts)) {
                RelationshipCountKey key = (RelationshipCountKey)count.first();
                org.junit.jupiter.api.Assertions.assertEquals((long)((Long)count.other()), (long)counts.relationshipCount(key.startLabel, key.type, key.endLabel, CursorContext.NULL_CONTEXT), (String)("Label count mismatch for label " + key));
            }
            tx.commit();
        }
        finally {
            managementService.shutdown();
        }
    }

    private static Iterable<Pair<RelationshipCountKey, Long>> allRelationshipCounts(Function<String, Integer> labelTranslationTable, Function<String, Integer> relationshipTypeTranslationTable, Map<String, Map<String, Map<String, AtomicLong>>> counts) {
        ArrayList<Pair<RelationshipCountKey, Long>> result = new ArrayList<Pair<RelationshipCountKey, Long>>();
        for (Map.Entry<String, Map<String, Map<String, AtomicLong>>> startLabel : counts.entrySet()) {
            for (Map.Entry<String, Map<String, AtomicLong>> type : startLabel.getValue().entrySet()) {
                for (Map.Entry<String, AtomicLong> endLabel : type.getValue().entrySet()) {
                    RelationshipCountKey key = new RelationshipCountKey(labelTranslationTable.apply(startLabel.getKey()), relationshipTypeTranslationTable.apply(type.getKey()), labelTranslationTable.apply(endLabel.getKey()));
                    result.add((Pair<RelationshipCountKey, Long>)Pair.of((Object)key, (Object)endLabel.getValue().longValue()));
                }
            }
        }
        return result;
    }

    private static Iterable<Pair<Integer, Long>> allNodeCounts(Function<String, Integer> labelTranslationTable, Map<String, AtomicLong> counts) {
        ArrayList<Pair<Integer, Long>> result = new ArrayList<Pair<Integer, Long>>();
        for (Map.Entry<String, AtomicLong> count : counts.entrySet()) {
            result.add((Pair<Integer, Long>)Pair.of((Object)labelTranslationTable.apply(count.getKey()), (Object)count.getValue().get()));
        }
        counts.put(null, new AtomicLong(counts.size()));
        return result;
    }

    private static Function<String, Integer> translationTable(TokenStore<?> tokenStore, int anyValue, RecordStorageEngine storageEngine) {
        HashMap<String, Integer> translationTable = new HashMap<String, Integer>();
        try (StoreCursors storeCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            for (NamedToken token : tokenStore.getTokens(storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE)) {
                translationTable.put(token.name(), token.id());
            }
            Function<String, Integer> function = from -> from == null ? anyValue : (Integer)translationTable.get(from);
            return function;
        }
    }

    private static Set<String> names(Iterable<Label> labels) {
        HashSet<String> names = new HashSet<String>();
        for (Label label : labels) {
            names.add(label.name());
        }
        return names;
    }

    private static void buildUpExpectedData(List<InputEntity> nodeData, List<InputEntity> relationshipData, Map<String, InputEntity> expectedNodes, Map<String, String[]> expectedNodeNames, Map<String, Map<String, Consumer<Object>>> expectedNodePropertyVerifiers, Map<String, Map<String, Map<String, AtomicInteger>>> expectedRelationships, Map<String, AtomicLong> nodeCounts, Map<String, Map<String, Map<String, AtomicLong>>> relationshipCounts) {
        for (InputEntity node : nodeData) {
            expectedNodes.put((String)node.id(), node);
            expectedNodeNames.put(ParquetInputBatchImportIT.nameOf(node), node.labels());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasIntPropertyKeyIds);
            TreeMap<String, Consumer<Object>> propertyVerifiers = new TreeMap<String, Consumer<Object>>();
            for (int i = 0; i < node.propertyCount(); ++i) {
                Consumer<Object> verify;
                Object expectedValue = node.propertyValue(i);
                if (expectedValue instanceof TemporalAmount) {
                    verify = actualValue -> {
                        LocalDateTime referenceTemporal = LocalDateTime.of(0, 1, 1, 0, 0);
                        LocalDateTime expected = referenceTemporal.plus((TemporalAmount)expectedValue);
                        LocalDateTime actual = referenceTemporal.plus((TemporalAmount)actualValue);
                        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
                    };
                } else if (expectedValue instanceof Temporal) {
                    LocalDate expectedDate = ((Temporal)expectedValue).query(TemporalQueries.localDate());
                    LocalTime expectedTime = ((Temporal)expectedValue).query(TemporalQueries.localTime());
                    ZoneId expectedZoneId = ((Temporal)expectedValue).query(TemporalQueries.zone());
                    verify = actualValue -> {
                        LocalDate actualDate = ((Temporal)actualValue).query(TemporalQueries.localDate());
                        LocalTime actualTime = ((Temporal)actualValue).query(TemporalQueries.localTime());
                        ZoneId actualZoneId = ((Temporal)actualValue).query(TemporalQueries.zone());
                        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDate, (Object)actualDate);
                        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTime, (Object)actualTime);
                        if (expectedZoneId == null) {
                            if (actualZoneId != null) {
                                org.junit.jupiter.api.Assertions.assertEquals((Object)testDefaultTimeZone.get(), (Object)actualZoneId);
                            }
                        } else {
                            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedZoneId, (Object)actualZoneId);
                        }
                    };
                } else {
                    verify = expectedValue instanceof float[] ? actualValue -> org.junit.jupiter.api.Assertions.assertArrayEquals((float[])((float[])expectedValue), (float[])((float[])actualValue)) : (expectedValue.getClass().isArray() ? actualValue -> org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])((Object[])expectedValue), (Object[])((Object[])actualValue)) : actualValue -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue, (Object)actualValue));
                }
                propertyVerifiers.put((String)node.propertyKey(i), verify);
            }
            Consumer<Object> verifyPointA = actualValue -> {
                PointValue v = (PointValue)actualValue;
                double actualY = ((Coordinate)v.getCoordinates().get(0)).getCoordinate()[1];
                double expectedY = ParquetInputBatchImportIT.indexOf(node) % 90;
                String message = actualValue + " does not have y=" + expectedY;
                org.junit.jupiter.api.Assertions.assertEquals((double)expectedY, (double)actualY, (double)0.1, (String)message);
                message = actualValue + " does not have crs=wgs-84";
                org.junit.jupiter.api.Assertions.assertEquals((Object)CoordinateReferenceSystem.WGS_84.getName(), (Object)v.getCoordinateReferenceSystem().getName(), (String)message);
            };
            propertyVerifiers.put("pointA", verifyPointA);
            Consumer<Object> verifyPointB = actualValue -> {
                PointValue v = (PointValue)actualValue;
                double actualY = ((Coordinate)v.getCoordinates().get(0)).getCoordinate()[1];
                double expectedY = ParquetInputBatchImportIT.indexOf(node);
                String message = actualValue + " does not have y=" + expectedY;
                org.junit.jupiter.api.Assertions.assertEquals((double)expectedY, (double)actualY, (double)0.1, (String)message);
                message = actualValue + " does not have crs=cartesian";
                org.junit.jupiter.api.Assertions.assertEquals((Object)CoordinateReferenceSystem.CARTESIAN.getName(), (Object)v.getCoordinateReferenceSystem().getName(), (String)message);
            };
            propertyVerifiers.put("pointB", verifyPointB);
            Consumer<Object> verifyPointArray = actualValue -> verifyPointB.accept(((PointValue[])actualValue)[0]);
            propertyVerifiers.put("pointArray", verifyPointArray);
            expectedNodePropertyVerifiers.put(ParquetInputBatchImportIT.nameOf(node), propertyVerifiers);
            ParquetInputBatchImportIT.countNodeLabels(nodeCounts, node.labels());
        }
        for (InputEntity relationship : relationshipData) {
            InputEntity startNode = expectedNodes.get(relationship.startId());
            InputEntity endNode = expectedNodes.get(relationship.endId());
            expectedRelationships.get(ParquetInputBatchImportIT.nameOf(startNode)).get(ParquetInputBatchImportIT.nameOf(endNode)).get(relationship.stringType).incrementAndGet();
            relationshipCounts.get(null).get(null).get(null).incrementAndGet();
            relationshipCounts.get(null).get(relationship.stringType).get(null).incrementAndGet();
            for (String startNodeLabelName : Iterators.asSet((Object[])startNode.labels())) {
                Map<String, Map<String, AtomicLong>> startLabelCounts = relationshipCounts.get(startNodeLabelName);
                startLabelCounts.get(null).get(null).incrementAndGet();
                Map<String, AtomicLong> typeCounts = startLabelCounts.get(relationship.stringType);
                typeCounts.get(null).incrementAndGet();
            }
            for (String endNodeLabelName : Iterators.asSet((Object[])endNode.labels())) {
                relationshipCounts.get(null).get(null).get(endNodeLabelName).incrementAndGet();
                relationshipCounts.get(null).get(relationship.stringType).get(endNodeLabelName).incrementAndGet();
            }
        }
    }

    private static void countNodeLabels(Map<String, AtomicLong> nodeCounts, String[] labels) {
        HashSet<String> seen = new HashSet<String>();
        for (String labelName : labels) {
            if (!seen.add(labelName)) continue;
            nodeCounts.get(labelName).incrementAndGet();
        }
    }

    private static String nameOf(InputEntity node) {
        return (String)node.properties()[1];
    }

    private static int indexOf(InputEntity node) {
        return Integer.parseInt(((String)node.properties()[1]).split("\\s")[1]);
    }

    private static class BasicParquetWriterBuilder<T>
    extends ParquetWriter.Builder<T, BasicParquetWriterBuilder<T>> {
        private MessageType schema;
        private Dehydrator<T> dehydrator;

        BasicParquetWriterBuilder(OutputFile file) {
            super(file);
        }

        public BasicParquetWriterBuilder<T> withType(MessageType schema) {
            this.schema = schema;
            return this;
        }

        public BasicParquetWriterBuilder<T> withDehydrator(Dehydrator<T> dehydrator) {
            this.dehydrator = dehydrator;
            return this;
        }

        protected BasicParquetWriterBuilder<T> self() {
            return this;
        }

        protected WriteSupport<T> getWriteSupport(org.apache.hadoop.conf.Configuration conf) {
            return new BasicWriteSupport<T>(this.schema, this.dehydrator);
        }
    }

    private static class TestOutputFile
    extends LocalOutputFile {
        TestOutputFile(Path file) {
            super(file);
        }

        public long defaultBlockSize() {
            return 4096L;
        }

        public boolean supportsBlockSize() {
            return true;
        }
    }

    private static class RelationshipCountKey {
        private final int startLabel;
        private final int type;
        private final int endLabel;

        RelationshipCountKey(int startLabel, int type, int endLabel) {
            this.startLabel = startLabel;
            this.type = type;
            this.endLabel = endLabel;
        }

        public String toString() {
            return String.format("[start:%d, type:%d, end:%d]", this.startLabel, this.type, this.endLabel);
        }
    }

    private static class BasicWriteSupport<T>
    extends WriteSupport<T> {
        private final MessageType schema;
        private final Dehydrator<T> dehydrator;
        private RecordConsumer recordConsumer;

        BasicWriteSupport(MessageType schema, Dehydrator<T> dehydrator) {
            this.schema = schema;
            this.dehydrator = dehydrator;
        }

        public WriteSupport.WriteContext init(org.apache.hadoop.conf.Configuration configuration) {
            return new WriteSupport.WriteContext(this.schema, Map.of("parquet.block.size", "4096"));
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(T record) {
            this.recordConsumer.startMessage();
            this.dehydrator.dehydrate(record, this::writeField);
            this.recordConsumer.endMessage();
        }

        private void writeField(String name, Object value) {
            int fieldIndex = this.schema.getFieldIndex(name);
            PrimitiveType type = this.schema.getType(fieldIndex).asPrimitiveType();
            this.recordConsumer.startField(name, fieldIndex);
            switch (type.getPrimitiveTypeName()) {
                case INT32: {
                    this.recordConsumer.addInteger(((Number)value).intValue());
                    break;
                }
                case INT64: {
                    this.recordConsumer.addLong(((Number)value).longValue());
                    break;
                }
                case BOOLEAN: {
                    this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
                    break;
                }
                case FLOAT: {
                    this.recordConsumer.addFloat(((Number)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    this.recordConsumer.addDouble(((Number)value).doubleValue());
                    break;
                }
                case BINARY: {
                    if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                        this.recordConsumer.addBinary(Binary.fromString((String)(value instanceof String ? (String)value : value.toString())));
                        break;
                    }
                    if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation) {
                        this.recordConsumer.addBinary(Binary.fromString((String)(value instanceof String ? (String)value : value.toString())));
                        break;
                    }
                    if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                        byte[] unscaled = decimal.unscaledValue().toByteArray();
                        this.recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])unscaled));
                        break;
                    }
                    throw new UnsupportedOperationException("writing of %s logical types is not supported.".formatted(type.getLogicalTypeAnnotation()));
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
                        UUID uuid = value instanceof UUID ? (UUID)value : UUID.fromString(value.toString());
                        ByteBuffer buffer = ByteBuffer.allocate(16);
                        buffer.putLong(uuid.getMostSignificantBits());
                        buffer.putLong(uuid.getLeastSignificantBits());
                        this.recordConsumer.addBinary(Binary.fromConstantByteBuffer((ByteBuffer)buffer));
                        break;
                    }
                    if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                        byte[] unscaled = decimal.unscaledValue().toByteArray();
                        ByteBuffer buffer = ByteBuffer.allocate(type.getTypeLength()).order(ByteOrder.BIG_ENDIAN);
                        buffer.position(type.getTypeLength() - unscaled.length);
                        buffer.put(unscaled);
                        this.recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])buffer.array()));
                        break;
                    }
                    throw new UnsupportedOperationException("writing of %s logical types is not supported.".formatted(type.getLogicalTypeAnnotation()));
                }
                default: {
                    throw new UnsupportedOperationException("writing of %s primitive types is not supported.".formatted(type.getPrimitiveTypeName()));
                }
            }
            this.recordConsumer.endField(name, fieldIndex);
        }
    }
}

