/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={OtherThreadExtension.class})
public class StaleTransactionIT {
    private AssertableLogProvider logProvider = new AssertableLogProvider();
    private FakeClock clock = new FakeClock();
    @Inject
    private GraphDatabaseFacade db;
    @Inject
    private KernelTransactions transactions;
    @Inject
    private Database database;
    @Inject
    private OtherThread otherThread;

    @ExtensionCallback
    protected void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.transaction_monitor_check_interval, (Object)Duration.ofMillis(100L)).setClock((SystemNanoClock)this.clock).setInternalLogProvider((InternalLogProvider)this.logProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testStaleTransactionLogged() throws InterruptedException, ExecutionException {
        CountDownLatch testStopLatch = new CountDownLatch(1);
        CountDownLatch staleTransactionStartLatch = new CountDownLatch(1);
        AtomicReference kernelTxRef = new AtomicReference();
        Future future = this.otherThread.execute(() -> {
            try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
                kernelTxRef.set(tx.kernelTransaction());
                staleTransactionStartLatch.countDown();
                testStopLatch.await();
            }
            return null;
        });
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)staleTransactionStartLatch.await(1L, TimeUnit.MINUTES)).as("other thread should have started transaction", new Object[0])).isTrue();
            Assertions.assertThat(kernelTxRef).doesNotHaveValue(null);
            KernelTransaction kernelTx = (KernelTransaction)kernelTxRef.get();
            kernelTx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed);
            this.clock.forward(10L, TimeUnit.MINUTES);
            Assert.assertEventually(() -> kernelTx.getTerminationMark().map(TerminationMark::isMarkedAsStale).orElse(false), stale -> stale, (long)1L, (TimeUnit)TimeUnit.MINUTES);
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessagesOnce(new String[]{"has been marked for termination for", "may have been leaked"});
        }
        finally {
            testStopLatch.countDown();
            future.get();
        }
    }
}

