/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
@Timeout(value=20L)
class CompositeIndexingIT {
    @Inject
    private GraphDatabaseAPI graphDatabaseAPI;
    private IndexDescriptor index;
    private int labelId;
    private int relTypeId;
    private int[] propIds;

    CompositeIndexingIT() {
    }

    @BeforeEach
    void setup() throws Exception {
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            TokenWrite tokenWrite = ktx.tokenWrite();
            tokenWrite.labelGetOrCreateForName("Label0");
            this.labelId = tokenWrite.labelGetOrCreateForName("Label1");
            tokenWrite.relationshipTypeGetOrCreateForName("Type0");
            tokenWrite.relationshipTypeGetOrCreateForName("Type1");
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("Type2");
            this.propIds = new int[10];
            for (int i = 0; i < this.propIds.length; ++i) {
                this.propIds[i] = tokenWrite.propertyKeyGetOrCreateForName("prop" + i);
            }
            tx.commit();
        }
    }

    void setup(PrototypeFactory prototypeFactory) throws Exception {
        IndexPrototype prototype = prototypeFactory.build(this.labelId, this.relTypeId, this.propIds);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            if (prototype.isUnique()) {
                ConstraintDescriptor constraint = ktx.schemaWrite().uniquePropertyConstraintCreate(prototype);
                this.index = ktx.schemaRead().indexGetForName(constraint.getName());
            } else {
                this.index = ktx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)prototype.schema()));
            }
            tx.commit();
        }
        tx = this.graphDatabaseAPI.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @AfterEach
    void clean() throws Exception {
        if (this.index == null) {
            return;
        }
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            if (this.index.isUnique()) {
                Iterator constraints = ktx.schemaRead().constraintsGetForSchema(this.index.schema());
                while (constraints.hasNext()) {
                    ktx.schemaWrite().constraintDrop((ConstraintDescriptor)constraints.next(), false);
                }
            } else {
                ktx.schemaWrite().indexDrop(this.index);
            }
            tx.commit();
        }
        tx = this.graphDatabaseAPI.beginTx();
        try (ResourceIterable allNodes = tx.getAllNodes();){
            for (Node node : allNodes) {
                Iterables.forEach((Iterable)node.getRelationships(), Entity::delete);
                node.delete();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<Params> params() {
        return Stream.of(new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1], propIds[2]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1], propIds[2], propIds[3], propIds[4]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1], propIds[2], propIds[3], propIds[4], propIds[5], propIds[6], propIds[7]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1], propIds[2]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propIds[1], propIds[2], propIds[3], propIds[4], propIds[5], propIds[6], propIds[7]})), EntityControl.NODE), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1]})), EntityControl.RELATIONSHIP), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1], propIds[2]})), EntityControl.RELATIONSHIP), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1], propIds[2], propIds[3], propIds[4]})), EntityControl.RELATIONSHIP), new Params((labelId, relTypeId, propIds) -> IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1], propIds[2], propIds[3], propIds[4], propIds[5], propIds[6], propIds[7]})), EntityControl.RELATIONSHIP), new Params((labelId, relTypeId, propIds) -> IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1]})), EntityControl.RELATIONSHIP), new Params((labelId, relTypeId, propIds) -> IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1], propIds[2]})), EntityControl.RELATIONSHIP), new Params((labelId, relTypeId, propIds) -> IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propIds[1], propIds[2], propIds[3], propIds[4], propIds[5], propIds[6], propIds[7]})), EntityControl.RELATIONSHIP));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeEntityAddedByPropertyToIndexInTranslation(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            long entity = entityControl.createEntity(ktx, this.index);
            Set<Long> found = entityControl.seek(ktx, this.index);
            Assertions.assertThat(found).containsExactly((Object[])new Long[]{entity});
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeEntityAddedByTokenToIndexInTransaction(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            long entity = entityControl.createEntityReverse(ktx, this.index);
            Set<Long> found = entityControl.seek(ktx, this.index);
            Assertions.assertThat(found).containsExactly((Object[])new Long[]{entity});
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeEntityThatWasDeletedInTransaction(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        long entity = this.createEntity(entityControl);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            entityControl.deleteEntity(ktx, entity);
            Assertions.assertThat(entityControl.seek(ktx, this.index)).isEmpty();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeEntityThatHasItsTokenRemovedInTransaction(Params params) throws Exception {
        EntityControl entityControl = params.entityControl;
        if (entityControl == EntityControl.RELATIONSHIP) {
            return;
        }
        this.setup(params.prototypeFactory);
        long entity = this.createEntity(entityControl);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            entityControl.removeToken(ktx, entity, this.labelId);
            Assertions.assertThat(entityControl.seek(ktx, this.index)).isEmpty();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeEntityThatHasAPropertyRemovedInTransaction(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        long entity = this.createEntity(entityControl);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            entityControl.removeProperty(ktx, entity, this.index.schema().getPropertyIds()[0]);
            Assertions.assertThat(entityControl.seek(ktx, this.index)).isEmpty();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeAllEntitiesAddedInTransaction(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        if (!this.index.isUnique()) {
            try (Transaction tx = this.graphDatabaseAPI.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                long entity1 = entityControl.createEntity(ktx, this.index);
                long entity2 = entityControl.createEntity(ktx, this.index);
                long entity3 = entityControl.createEntity(ktx, this.index);
                Assertions.assertThat(entityControl.seek(ktx, this.index)).contains((Object[])new Long[]{entity1, entity2, entity3});
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeAllEntitiesAddedBeforeTransaction(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        if (!this.index.isUnique()) {
            long entity1 = this.createEntity(entityControl);
            long entity2 = this.createEntity(entityControl);
            long entity3 = this.createEntity(entityControl);
            try (Transaction tx = this.graphDatabaseAPI.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                Assertions.assertThat(entityControl.seek(ktx, this.index)).contains((Object[])new Long[]{entity1, entity2, entity3});
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeEntitiesLackingOneProperty(Params params) throws Exception {
        this.setup(params.prototypeFactory);
        EntityControl entityControl = params.entityControl;
        long entity = this.createEntity(entityControl);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            entityControl.createEntity(ktx, this.index, true);
            Assertions.assertThat(entityControl.seek(ktx, this.index)).containsExactly((Object[])new Long[]{entity});
        }
    }

    private long createEntity(EntityControl entityControl) throws KernelException {
        long id;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            id = entityControl.createEntity(ktx, this.index);
            tx.commit();
        }
        return id;
    }

    private static PropertyIndexQuery[] exactQuery(IndexDescriptor index) {
        int[] propertyIds = index.schema().getPropertyIds();
        PropertyIndexQuery[] query = new PropertyIndexQuery[propertyIds.length];
        for (int i = 0; i < query.length; ++i) {
            int propID = propertyIds[i];
            query[i] = PropertyIndexQuery.exact((int)propID, (Object)Values.of((Object)propID));
        }
        return query;
    }

    @FunctionalInterface
    private static interface PrototypeFactory {
        public IndexPrototype build(int var1, int var2, int[] var3);
    }

    private static class Params {
        PrototypeFactory prototypeFactory;
        EntityControl entityControl;

        Params(PrototypeFactory prototypeFactory, EntityControl entityControl) {
            this.prototypeFactory = prototypeFactory;
            this.entityControl = entityControl;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum EntityControl {
        NODE{

            @Override
            long createEntity(KernelTransaction ktx, IndexDescriptor index, boolean excludeFirstProperty) throws KernelException {
                Write write = ktx.dataWrite();
                long nodeID = write.nodeCreate();
                write.nodeAddLabel(nodeID, index.schema().getLabelId());
                for (int propID : index.schema().getPropertyIds()) {
                    if (excludeFirstProperty) {
                        excludeFirstProperty = false;
                        continue;
                    }
                    write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
                }
                return nodeID;
            }

            @Override
            long createEntityReverse(KernelTransaction ktx, IndexDescriptor index) throws KernelException {
                Write write = ktx.dataWrite();
                long nodeID = write.nodeCreate();
                for (int propID : index.schema().getPropertyIds()) {
                    write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
                }
                write.nodeAddLabel(nodeID, index.schema().getLabelId());
                return nodeID;
            }

            @Override
            public void deleteEntity(KernelTransaction ktx, long id) throws InvalidTransactionTypeKernelException {
                ktx.dataWrite().nodeDelete(id);
            }

            @Override
            public void removeToken(KernelTransaction ktx, long entityId, int labelId) throws InvalidTransactionTypeKernelException, EntityNotFoundException {
                ktx.dataWrite().nodeRemoveLabel(entityId, labelId);
            }

            @Override
            public void removeProperty(KernelTransaction ktx, long entity, int propertyId) throws KernelException {
                ktx.dataWrite().nodeRemoveProperty(entity, propertyId);
            }

            @Override
            Set<Long> seek(KernelTransaction ktx, IndexDescriptor index) throws KernelException {
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                HashSet<Long> result = new HashSet<Long>();
                try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                    ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), CompositeIndexingIT.exactQuery(index));
                    while (cursor.next()) {
                        result.add(cursor.nodeReference());
                    }
                }
                return result;
            }
        }
        ,
        RELATIONSHIP{

            @Override
            long createEntity(KernelTransaction ktx, IndexDescriptor index, boolean excludeFirstProperty) throws KernelException {
                Write write = ktx.dataWrite();
                long from = write.nodeCreate();
                long to = write.nodeCreate();
                long rel = write.relationshipCreate(from, index.schema().getRelTypeId(), to);
                for (int propID : index.schema().getPropertyIds()) {
                    if (excludeFirstProperty) {
                        excludeFirstProperty = false;
                        continue;
                    }
                    write.relationshipSetProperty(rel, propID, (Value)Values.intValue((int)propID));
                }
                return rel;
            }

            @Override
            long createEntityReverse(KernelTransaction ktx, IndexDescriptor index) throws KernelException {
                return this.createEntity(ktx, index, false);
            }

            @Override
            public void deleteEntity(KernelTransaction ktx, long id) throws InvalidTransactionTypeKernelException {
                ktx.dataWrite().relationshipDelete(id);
            }

            @Override
            public void removeToken(KernelTransaction ktx, long entityId, int relTypeId) {
                throw new IllegalStateException("Not supported");
            }

            @Override
            public void removeProperty(KernelTransaction ktx, long entity, int propertyId) throws KernelException {
                ktx.dataWrite().relationshipRemoveProperty(entity, propertyId);
            }

            @Override
            Set<Long> seek(KernelTransaction ktx, IndexDescriptor index) throws KernelException {
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                HashSet<Long> result = new HashSet<Long>();
                try (RelationshipValueIndexCursor cursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                    ktx.dataRead().relationshipIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), CompositeIndexingIT.exactQuery(index));
                    while (cursor.next()) {
                        result.add(cursor.relationshipReference());
                    }
                }
                return result;
            }
        };


        long createEntity(KernelTransaction ktx, IndexDescriptor index) throws KernelException {
            return this.createEntity(ktx, index, false);
        }

        abstract long createEntity(KernelTransaction var1, IndexDescriptor var2, boolean var3) throws KernelException;

        abstract long createEntityReverse(KernelTransaction var1, IndexDescriptor var2) throws KernelException;

        abstract Set<Long> seek(KernelTransaction var1, IndexDescriptor var2) throws KernelException;

        public abstract void deleteEntity(KernelTransaction var1, long var2) throws KernelException;

        public abstract void removeToken(KernelTransaction var1, long var2, int var4) throws KernelException;

        public abstract void removeProperty(KernelTransaction var1, long var2, int var4) throws KernelException;
    }
}

