/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DatabaseIndexStatsIT {
    private final Label NODE_LABEL = Label.label((String)"Label");
    private final String PROPERTY_KEY = "prop";
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private GraphDatabaseFacade db;
    private DatabaseManagementService managementService;

    DatabaseIndexStatsIT() {
    }

    @BeforeEach
    void before() {
        this.startDb();
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP", "FULLTEXT"})
    void shouldTrackIndexCreationAndQueriesSinceStart(IndexType indexType) {
        DatabaseIndexStats stats = (DatabaseIndexStats)this.db.getDependencyResolver().resolveDependency(DatabaseIndexStats.class);
        this.forceReporting();
        LogAssertions.assertThat((long)stats.getPopulationCount(indexType)).isEqualTo(0L);
        LogAssertions.assertThat((long)stats.getQueryCount(indexType)).isEqualTo(0L);
        String index = this.createIndex(indexType);
        this.forceReporting();
        LogAssertions.assertThat((long)stats.getPopulationCount(indexType)).isEqualTo(1L);
        LogAssertions.assertThat((long)stats.getQueryCount(indexType)).isEqualTo(0L);
        this.query(index);
        this.forceReporting();
        LogAssertions.assertThat((long)stats.getPopulationCount(indexType)).isEqualTo(1L);
        LogAssertions.assertThat((long)stats.getQueryCount(indexType)).isEqualTo(1L);
        this.query(index);
        this.forceReporting();
        LogAssertions.assertThat((long)stats.getPopulationCount(indexType)).isEqualTo(1L);
        LogAssertions.assertThat((long)stats.getQueryCount(indexType)).isEqualTo(2L);
        this.restart();
        stats = (DatabaseIndexStats)this.db.getDependencyResolver().resolveDependency(DatabaseIndexStats.class);
        this.forceReporting();
        LogAssertions.assertThat((long)stats.getPopulationCount(indexType)).isEqualTo(0L);
        LogAssertions.assertThat((long)stats.getQueryCount(indexType)).isEqualTo(0L);
    }

    private String createIndex(IndexType indexType) {
        String indexName;
        try (Transaction tx = this.db.beginTx();){
            indexName = tx.schema().indexFor(this.NODE_LABEL).on("prop").withIndexType(indexType.toPublicApi()).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((org.neo4j.graphdb.schema.IndexType)indexType.toPublicApi())).create().getName();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(indexName, 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexName;
    }

    private void forceReporting() {
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        indexingService.reportUsageStatistics();
    }

    private void query(String indexName) {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((TransactionImpl)tx).kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
            IndexReadSession session = ktx.dataRead().indexReadSession(index);
            try (NodeValueIndexCursor nodes = ktx.cursors().allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, ktx.memoryTracker());){
                ktx.dataRead().nodeIndexScan(session, nodes, IndexQueryConstraints.unconstrained());
            }
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void startDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setInternalLogProvider((InternalLogProvider)this.logProvider).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs)).setConfig(GraphDatabaseSettings.index_background_sampling_enabled, (Object)false).build();
        this.db = (GraphDatabaseFacade)this.managementService.database("neo4j");
    }

    private void restart() {
        this.managementService.shutdown();
        this.startDb();
    }
}

