/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssert;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.PageCacheTracerAssertions;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
class IndexPopulationJobTest {
    private static final CursorContextFactory CONTEXT_FACTORY = new CursorContextFactory(PageCacheTracer.NULL, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private GraphDatabaseAPI db;
    private static final Label FIRST = Label.label((String)"FIRST");
    private static final Label SECOND = Label.label((String)"SECOND");
    private static final String name = "name";
    private static final String age = "age";
    private static final RelationshipType likes = RelationshipType.withName((String)"likes");
    private static final RelationshipType knows = RelationshipType.withName((String)"knows");
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    private Kernel kernel;
    private TokenNameLookup tokens;
    private TokenHolders tokenHolders;
    private IndexStoreView indexStoreView;
    private DatabaseSchemaState stateHolder;
    private int labelId;
    private IndexStatisticsStore indexStatisticsStore;
    private JobScheduler jobScheduler;
    private StorageEngine storageEngine;

    IndexPopulationJobTest() {
    }

    @BeforeEach
    void before() throws Exception {
        this.kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        this.tokens = (TokenNameLookup)this.db.getDependencyResolver().resolveDependency(TokenNameLookup.class);
        this.tokenHolders = (TokenHolders)this.db.getDependencyResolver().resolveDependency(TokenHolders.class);
        this.stateHolder = new DatabaseSchemaState((InternalLogProvider)NullLogProvider.getInstance());
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        this.indexStoreView = ((IndexStoreViewFactory)this.db.getDependencyResolver().resolveDependency(IndexStoreViewFactory.class)).createTokenIndexStoreView(arg_0 -> ((IndexingService)indexingService).getIndexProxy(arg_0));
        this.indexStatisticsStore = (IndexStatisticsStore)this.db.getDependencyResolver().resolveDependency(IndexStatisticsStore.class);
        this.jobScheduler = (JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class);
        this.storageEngine = (StorageEngine)this.db.getDependencyResolver().resolveDependency(StorageEngine.class);
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            this.labelId = tx.tokenWrite().labelGetOrCreateForName(FIRST.name());
            tx.tokenWrite().labelGetOrCreateForName(SECOND.name());
            tx.commit();
        }
    }

    @Test
    void shouldPopulateIndexWithOneNode() throws Exception {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        IndexPopulator actualPopulator = this.indexPopulator(false);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        int label = this.tokenHolders.labelTokens().getIdByName(FIRST.name());
        int prop = this.tokenHolders.propertyKeyTokens().getIdByName(name);
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{prop});
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, IndexPrototype.forSchema((SchemaDescriptor)descriptor));
        job.run();
        ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, () -> descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)1, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void tracePageCacheAccessIndexWithOneNodePopulation() throws KernelException {
        String value = "value";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        IndexPopulator actualPopulator = this.indexPopulator(false);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        int label = this.tokenHolders.labelTokens().getIdByName(FIRST.name());
        int prop = this.tokenHolders.propertyKeyTokens().getIdByName(name);
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{prop});
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, IndexPrototype.forSchema((SchemaDescriptor)descriptor), contextFactory);
        job.run();
        ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, () -> descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)1, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
        PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.db).record(PageCacheTracerAssertions.pins((long)12L).faults(2L)).block(PageCacheTracerAssertions.pins((long)11L).faults(2L)).matches((PageCacheCounters)pageCacheTracer);
    }

    @Test
    void shouldPopulateIndexWithOneRelationship() {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        long relationship = this.createRelationship(MapUtil.map((Object[])new Object[]{name, age}), likes, nodeId, nodeId);
        int relType = this.tokenHolders.relationshipTypeTokens().getIdByName(likes.name());
        int propertyId = this.tokenHolders.propertyKeyTokens().getIdByName(name);
        IndexPrototype descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relType, (int[])new int[]{propertyId}));
        IndexPopulator actualPopulator = this.indexPopulator(descriptor);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor);
        job.run();
        ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)relationship, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)age)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)1, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void tracePageCacheAccessIndexWithOneRelationship() {
        String value = "value";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        long relationship = this.createRelationship(MapUtil.map((Object[])new Object[]{name, age}), likes, nodeId, nodeId);
        int rel = this.tokenHolders.relationshipTypeTokens().getIdByName(likes.name());
        int prop = this.tokenHolders.propertyKeyTokens().getIdByName(name);
        IndexPrototype descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)rel, (int[])new int[]{prop}));
        IndexPopulator actualPopulator = this.indexPopulator(descriptor);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor, contextFactory);
        job.run();
        ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)relationship, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)age)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)1, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
        PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.db).record(PageCacheTracerAssertions.pins((long)12L).faults(2L)).block(PageCacheTracerAssertions.pins((long)11L).faults(2L)).matches((PageCacheCounters)pageCacheTracer);
    }

    @Test
    void shouldFlushSchemaStateAfterPopulation() throws Exception {
        String value = "Taylor";
        this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        this.stateHolder.put((Object)"key", (Object)"original_value");
        IndexPopulator populator = this.indexPopulator(false);
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.NODE, this.indexPrototype(FIRST, name, false));
        job.run();
        String result = (String)this.stateHolder.get((Object)"key");
        Assertions.assertNull((Object)result);
    }

    @Test
    void shouldPopulateIndexWithASmallDataset() throws Exception {
        String value = "Mattias";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        this.createNode(MapUtil.map((Object[])new Object[]{name, value}), SECOND);
        this.createNode(MapUtil.map((Object[])new Object[]{age, 31}), FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{age, 35, name, value}), FIRST);
        IndexPopulator actualPopulator = this.indexPopulator(false);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        int label = this.tokenHolders.labelTokens().getIdByName(FIRST.name());
        int prop = this.tokenHolders.propertyKeyTokens().getIdByName(name);
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{prop});
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, IndexPrototype.forSchema((SchemaDescriptor)descriptor));
        job.run();
        ValueIndexEntryUpdate update1 = IndexEntryUpdate.add((long)node1, () -> descriptor, (Value[])new Value[]{Values.of((Object)value)});
        ValueIndexEntryUpdate update2 = IndexEntryUpdate.add((long)node4, () -> descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Arrays.asList(update1, update2), populator.includedSamples);
        Assertions.assertEquals((int)1, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void shouldPopulateRelationshipIndexWithASmallDataset() {
        String value = "Philip J.Fry";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), SECOND);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{age, 31}), FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{age, 35, name, value}), FIRST);
        long rel1 = this.createRelationship(MapUtil.map((Object[])new Object[]{name, value}), likes, node1, node3);
        this.createRelationship(MapUtil.map((Object[])new Object[]{name, value}), knows, node3, node1);
        this.createRelationship(MapUtil.map((Object[])new Object[]{age, 31}), likes, node2, node1);
        long rel4 = this.createRelationship(MapUtil.map((Object[])new Object[]{age, 35, name, value}), likes, node4, node4);
        int rel = this.tokenHolders.relationshipTypeTokens().getIdByName(likes.name());
        int prop = this.tokenHolders.propertyKeyTokens().getIdByName(name);
        IndexPrototype descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)rel, (int[])new int[]{prop}));
        IndexPopulator actualPopulator = this.indexPopulator(descriptor);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor);
        job.run();
        ValueIndexEntryUpdate update1 = IndexEntryUpdate.add((long)rel1, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        ValueIndexEntryUpdate update2 = IndexEntryUpdate.add((long)rel4, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Arrays.asList(update1, update2), populator.includedSamples);
        Assertions.assertEquals((int)1, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void shouldIndexConcurrentUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        String changedValue = "changed";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value1}), FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{name, value2}), FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{name, value3}), FIRST);
        long changeNode = node1;
        int propertyKeyId = this.getPropertyKeyForName(name);
        IndexDescriptor index = TestIndexDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{propertyKeyId});
        NodeChangingWriter populator = new NodeChangingWriter(changeNode, value1, changedValue, index);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, index);
        populator.setJob(job);
        job.run();
        Set expected = Iterators.asSet((Object[])new Pair[]{Pair.of((Object)node1, (Object)value1), Pair.of((Object)node2, (Object)value2), Pair.of((Object)node3, (Object)value3), Pair.of((Object)node1, (Object)changedValue)});
        Assertions.assertEquals((Object)expected, populator.added);
    }

    @Test
    void shouldRemoveViaConcurrentIndexUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value1}), FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{name, value2}), FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{name, value3}), FIRST);
        int propertyKeyId = this.getPropertyKeyForName(name);
        IndexDescriptor index = TestIndexDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{propertyKeyId});
        NodeDeletingWriter populator = new NodeDeletingWriter(node2, value2, index);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, index);
        populator.setJob(job);
        job.run();
        Map expectedAdded = MapUtil.genericMap((Object[])new Object[]{node1, value1, node2, value2, node3, value3});
        Assertions.assertEquals((Object)expectedAdded, populator.added);
        Map expectedRemoved = MapUtil.genericMap((Object[])new Object[]{node2, value2});
        Assertions.assertEquals((Object)expectedRemoved, populator.removed);
    }

    @Test
    void shouldTransitionToFailedStateIfPopulationJobCrashes() throws Exception {
        IndexPopulator failingPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("BORK BORK")}).when((Object)failingPopulator)).add((Collection)ArgumentMatchers.any(Collection.class), (CursorContext)ArgumentMatchers.any(CursorContext.class));
        FlippableIndexProxy index = new FlippableIndexProxy();
        this.createNode(MapUtil.map((Object[])new Object[]{name, "Taylor"}), FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(failingPopulator, index, EntityType.NODE, this.indexPrototype(FIRST, name, false));
        job.run();
        LogAssertions.assertThat((Comparable)index.getState()).isEqualTo((Object)InternalIndexState.FAILED);
    }

    @Test
    void shouldBeAbleToStopPopulationJob() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "Mattias"}), FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        ControlledStoreScan storeScan = new ControlledStoreScan();
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(int[].class), (PropertySelection)ArgumentMatchers.any(PropertySelection.class), (PropertyScanConsumer)ArgumentMatchers.any(), (TokenScanConsumer)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (CursorContextFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)storeScan);
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, storeView, (InternalLogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.indexPrototype(FIRST, name, false));
        JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
        job.setHandle(jobHandle);
        try (OtherThreadExecutor populationJobRunner = new OtherThreadExecutor("Population job test runner");){
            Future runFuture = populationJobRunner.executeDontWait(() -> {
                job.run();
                return null;
            });
            storeScan.latch.waitForAllToStart();
            job.stop();
            job.awaitCompletion(0L, TimeUnit.SECONDS);
            storeScan.latch.waitForAllToFinish();
            runFuture.get();
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).close(ArgumentMatchers.eq((boolean)false), (CursorContext)ArgumentMatchers.any());
        ((FlippableIndexProxy)Mockito.verify((Object)index, (VerificationMode)Mockito.never())).flip((Callable)ArgumentMatchers.any());
        ((JobHandle)Mockito.verify((Object)jobHandle)).cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)index.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        IndexPopulator populator = this.indexPopulator(false);
        try {
            IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (InternalLogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, false));
            job.run();
            LogAssert populationLog = LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class);
            populationLog.forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Index population started: [%s]", "type='RANGE', schema=(:FIRST {name})"});
            populationLog.forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"TIME/PHASE Final: SCAN["});
        }
        finally {
            populator.close(true, CursorContext.NULL_CONTEXT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void logConstraintJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)index.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        IndexPopulator populator = this.indexPopulator(false);
        try {
            IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (InternalLogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, true));
            job.run();
            LogAssert populationLog = LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class);
            populationLog.forLevel(AssertableLogProvider.Level.INFO).containsMessageWithArgumentsContaining("Index population started: [%s]", new Object[]{"type='RANGE', schema=(:FIRST {name})"});
            populationLog.forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"TIME/PHASE Final: SCAN["});
        }
        finally {
            populator.close(true, CursorContext.NULL_CONTEXT);
        }
    }

    @Test
    void shouldLogJobFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (InternalLogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, false));
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).create();
        job.run();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.ERROR).containsMessageWithException("Failed to populate index: [Index(", (Throwable)failure).containsMessageWithException("type='RANGE', schema=(:FIRST {name})", (Throwable)failure);
    }

    @Test
    void shouldFlipToFailedUsingFailedIndexProxyFactory() throws Exception {
        FlippableIndexProxy proxy = (FlippableIndexProxy)Mockito.spy((Object)new FlippableIndexProxy());
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, proxy, EntityType.NODE, this.indexPrototype(FIRST, name, false), CONTEXT_FACTORY);
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        job.run();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        ((FlippableIndexProxy)Mockito.verify((Object)proxy)).flipTo((IndexProxy)ArgumentMatchers.any(FailedIndexProxy.class));
    }

    @Test
    void shouldCloseAndFailOnFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (InternalLogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, false));
        String failureMessage = "not successful";
        IllegalStateException failure = new IllegalStateException(failureMessage);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).create();
        job.run();
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(ArgumentMatchers.contains((String)failureMessage));
    }

    @Test
    void shouldCloseMultiPopulatorOnSuccessfulPopulation() {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        TrackingMultipleIndexPopulator populator = new TrackingMultipleIndexPopulator(IndexStoreView.EMPTY, (InternalLogProvider)logProvider, EntityType.NODE, (SchemaState)new DatabaseSchemaState((InternalLogProvider)logProvider), this.jobScheduler, this.tokens);
        IndexPopulationJob populationJob = new IndexPopulationJob((MultipleIndexPopulator)populator, IndexMonitor.NO_MONITOR, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, EntityType.NODE, Config.defaults());
        populationJob.run();
        Assertions.assertTrue((boolean)populator.closed);
    }

    @Test
    void shouldCloseMultiPopulatorOnFailedPopulation() {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexStoreView.Adaptor failingStoreView = new IndexStoreView.Adaptor(){

            public StoreScan visitNodes(int[] labelIds, PropertySelection propertySelection, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
                return new StoreScan(){

                    public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
                        throw new RuntimeException("Just failing");
                    }

                    public void stop() {
                    }

                    public PopulationProgress getProgress() {
                        return null;
                    }
                };
            }
        };
        TrackingMultipleIndexPopulator populator = new TrackingMultipleIndexPopulator((IndexStoreView)failingStoreView, (InternalLogProvider)logProvider, EntityType.NODE, (SchemaState)new DatabaseSchemaState((InternalLogProvider)logProvider), this.jobScheduler, this.tokens);
        IndexPopulationJob populationJob = new IndexPopulationJob((MultipleIndexPopulator)populator, IndexMonitor.NO_MONITOR, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, EntityType.NODE, Config.defaults());
        populationJob.run();
        Assertions.assertTrue((boolean)populator.closed);
    }

    private IndexPopulator indexPopulator(boolean constraint) throws KernelException {
        IndexPrototype prototype = this.indexPrototype(FIRST, name, constraint);
        return this.indexPopulator(prototype);
    }

    private IndexPopulator indexPopulator(IndexPrototype prototype) {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexProvider indexProvider = ((IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class)).getDefaultProvider();
        IndexDescriptor indexDescriptor = prototype.withName("index_21").materialise(21L);
        indexDescriptor = indexProvider.completeConfiguration(indexDescriptor, this.storageEngine.indexingBehaviour());
        return indexProvider.getPopulator(indexDescriptor, samplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.storageEngine.getOpenOptions(), this.storageEngine.indexingBehaviour());
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType type, IndexDescriptor indexDescriptor) {
        return this.newIndexPopulationJob(populator, flipper, type, CONTEXT_FACTORY, indexDescriptor);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType type, CursorContextFactory contextFactory, IndexDescriptor indexDescriptor) {
        return this.newIndexPopulationJob(populator, flipper, this.indexStoreView, (InternalLogProvider)NullLogProvider.getInstance(), type, contextFactory, indexDescriptor);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, InternalLogProvider logProvider, EntityType type, IndexPrototype prototype) {
        return this.newIndexPopulationJob(populator, flipper, storeView, logProvider, type, CONTEXT_FACTORY, prototype.withName("index_0").materialise(0L));
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType entityType, IndexPrototype indexPrototype) {
        return this.newIndexPopulationJob(populator, flipper, this.indexStoreView, (InternalLogProvider)NullLogProvider.getInstance(), entityType, indexPrototype);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType entityType, IndexPrototype descriptor, CursorContextFactory contextFactory) {
        return this.newIndexPopulationJob(populator, flipper, this.indexStoreView, (InternalLogProvider)NullLogProvider.getInstance(), entityType, contextFactory, descriptor.withName("index_0").materialise(0L));
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, InternalLogProvider logProvider, EntityType type, CursorContextFactory contextFactory, IndexDescriptor descriptor) {
        flipper.setFlipTarget((IndexProxyFactory)Mockito.mock(IndexProxyFactory.class));
        MultipleIndexPopulator multiPopulator = new MultipleIndexPopulator(storeView, logProvider, type, (SchemaState)this.stateHolder, this.jobScheduler, this.tokens, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults());
        IndexPopulationJob job = new IndexPopulationJob(multiPopulator, IndexMonitor.NO_MONITOR, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, EntityType.NODE, Config.defaults());
        ValueIndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(descriptor, this.indexStatisticsStore, this.tokens);
        job.addPopulator(populator, (IndexProxyStrategy)indexProxyStrategy, flipper);
        return job;
    }

    private IndexPrototype indexPrototype(Label label, String propertyKey, boolean constraint) throws KernelException {
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            int labelId = tx.tokenWrite().labelGetOrCreateForName(label.name());
            int propertyKeyId = tx.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
            IndexPrototype descriptor = constraint ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR) : IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            tx.commit();
            IndexPrototype indexPrototype = descriptor;
            return indexPrototype;
        }
    }

    private long createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    private long createRelationship(Map<String, Object> properties, RelationshipType relType, long fromNode, long toNode) {
        try (Transaction tx = this.db.beginTx();){
            Node node1 = tx.getNodeById(fromNode);
            Node node2 = tx.getNodeById(toNode);
            Relationship relationship = node1.createRelationshipTo(node2, relType);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                relationship.setProperty(property.getKey(), property.getValue());
            }
            tx.commit();
            long l = relationship.getId();
            return l;
        }
    }

    private int getPropertyKeyForName(String name) throws TransactionFailureException {
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            int result = tx.tokenRead().propertyKey(name);
            tx.commit();
            int n = result;
            return n;
        }
    }

    private static class TrackingIndexPopulator
    extends IndexPopulator.Delegating {
        private volatile boolean created;
        private final List<Collection<? extends IndexEntryUpdate<?>>> adds = new ArrayList();
        private volatile Boolean closeCall;
        private final List<IndexEntryUpdate<?>> includedSamples = new ArrayList();
        private volatile boolean resultSampled;

        TrackingIndexPopulator(IndexPopulator delegate) {
            super(delegate);
        }

        public void create() throws IOException {
            this.created = true;
            super.create();
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) throws IndexEntryConflictException {
            this.adds.add(updates);
            super.add(updates, cursorContext);
        }

        public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
            this.closeCall = populationCompletedSuccessfully;
            super.close(populationCompletedSuccessfully, cursorContext);
        }

        public void includeSample(IndexEntryUpdate<?> update) {
            this.includedSamples.add(update);
            super.includeSample(update);
        }

        public IndexSample sample(CursorContext cursorContext) {
            this.resultSampled = true;
            return super.sample(cursorContext);
        }
    }

    private static class NodeChangingWriter
    extends IndexPopulator.Adapter {
        private final Set<Pair<Long, Object>> added = new HashSet<Pair<Long, Object>>();
        private IndexPopulationJob job;
        private final long nodeToChange;
        private final Value newValue;
        private final Value previousValue;
        private final IndexDescriptor index;

        NodeChangingWriter(long nodeToChange, Object previousValue, Object newValue, IndexDescriptor index) {
            this.nodeToChange = nodeToChange;
            this.previousValue = Values.of((Object)previousValue);
            this.newValue = Values.of((Object)newValue);
            this.index = index;
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
            for (IndexEntryUpdate<?> update : updates) {
                this.add((ValueIndexEntryUpdate)update);
            }
        }

        void add(ValueIndexEntryUpdate<?> update) {
            if (update.getEntityId() == 2L) {
                this.job.update((IndexEntryUpdate)IndexEntryUpdate.change((long)this.nodeToChange, (SchemaDescriptorSupplier)this.index, (Value)this.previousValue, (Value)this.newValue));
            }
            this.added.add((Pair<Long, Object>)Pair.of((Object)update.getEntityId(), (Object)update.values()[0].asObjectCopy()));
        }

        public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
            return new IndexUpdater(){

                public void process(IndexEntryUpdate<?> update) {
                    ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
                    switch (valueUpdate.updateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            added.add((Pair<Long, Object>)Pair.of((Object)valueUpdate.getEntityId(), (Object)valueUpdate.values()[0].asObjectCopy()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(valueUpdate.updateMode().name());
                        }
                    }
                }

                public void close() {
                }
            };
        }

        void setJob(IndexPopulationJob job) {
            this.job = job;
        }
    }

    private static class NodeDeletingWriter
    extends IndexPopulator.Adapter {
        private final Map<Long, Object> added = new HashMap<Long, Object>();
        private final Map<Long, Object> removed = new HashMap<Long, Object>();
        private final long nodeToDelete;
        private IndexPopulationJob job;
        private final Value valueToDelete;
        private final IndexDescriptor index;

        NodeDeletingWriter(long nodeToDelete, Object valueToDelete, IndexDescriptor index) {
            this.nodeToDelete = nodeToDelete;
            this.valueToDelete = Values.of((Object)valueToDelete);
            this.index = index;
        }

        void setJob(IndexPopulationJob job) {
            this.job = job;
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
            for (IndexEntryUpdate<?> update : updates) {
                this.add((ValueIndexEntryUpdate)update);
            }
        }

        void add(ValueIndexEntryUpdate<?> update) {
            if (update.getEntityId() == 2L) {
                this.job.update((IndexEntryUpdate)IndexEntryUpdate.remove((long)this.nodeToDelete, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{this.valueToDelete}));
            }
            this.added.put(update.getEntityId(), update.values()[0].asObjectCopy());
        }

        public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
            return new IndexUpdater(){

                public void process(IndexEntryUpdate<?> update) {
                    ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
                    switch (valueUpdate.updateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            added.put(valueUpdate.getEntityId(), valueUpdate.values()[0].asObjectCopy());
                            break;
                        }
                        case REMOVED: {
                            removed.put(valueUpdate.getEntityId(), valueUpdate.values()[0].asObjectCopy());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(valueUpdate.updateMode().name());
                        }
                    }
                }

                public void close() {
                }
            };
        }
    }

    private static class ControlledStoreScan
    implements StoreScan {
        private final DoubleLatch latch = new DoubleLatch();

        private ControlledStoreScan() {
        }

        public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
            this.latch.startAndWaitForAllToStartAndFinish();
        }

        public void stop() {
            this.latch.finish();
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.single((long)42L, (long)100L);
        }
    }

    private static class TrackingMultipleIndexPopulator
    extends MultipleIndexPopulator {
        private volatile boolean closed;

        TrackingMultipleIndexPopulator(IndexStoreView storeView, InternalLogProvider logProvider, EntityType type, SchemaState schemaState, JobScheduler jobScheduler, TokenNameLookup tokens) {
            super(storeView, logProvider, type, schemaState, jobScheduler, tokens, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults());
        }

        public void close() {
            this.closed = true;
            super.close();
        }
    }
}

