/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.integrationtest.ProcedureITBase;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

class SystemBuiltInProceduresIT
extends KernelIntegrationTest
implements ProcedureITBase {
    SystemBuiltInProceduresIT() {
    }

    @Override
    public String getDatabaseName() {
        return "system";
    }

    @Test
    void databaseInfo() throws ProcedureException {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(new QualifiedName("db", "info"), QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            List procedureResult = Iterators.asList((RawIterator)stream);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)procedureResult.isEmpty());
            Object[] dbInfoRow = (AnyValue[])procedureResult.get(0);
            Assertions.assertThat((Object[])dbInfoRow).contains((Object[])new AnyValue[]{Values.stringValue((String)"system")});
            Assertions.assertThat((Object[])dbInfoRow).hasSize(3);
        }
    }

    @Test
    void dbmsInfo() throws ProcedureException {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(new QualifiedName("dbms", "info"), QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            List procedureResult = Iterators.asList((RawIterator)stream);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)procedureResult.isEmpty());
            Object[] dbmsInfoRow = (AnyValue[])procedureResult.get(0);
            Assertions.assertThat((Object[])dbmsInfoRow).contains((Object[])new AnyValue[]{Values.stringValue((String)"system")});
            Assertions.assertThat((Object[])dbmsInfoRow).hasSize(3);
        }
    }

    @Test
    void listAllLabels() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.labels").hasNext());
        }
    }

    @Test
    void listPropertyKeys() throws Throwable {
        TokenWrite ops = this.tokenWriteInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.propertyKeys").hasNext());
        }
    }

    @Test
    void listRelationshipTypes() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType = transaction.tokenWrite().relationshipTypeGetOrCreateForName("MyRelType");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().relationshipCreate(startNodeId, relType, endNodeId);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.relationshipTypes").hasNext());
        }
    }

    @Test
    void listAllComponentsShouldWork() throws Throwable {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            ResourceRawIterator stream = procs.procedureCallRead(procs.procedureGet(new QualifiedName("dbms", "components"), QueryLanguage.CYPHER_5).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"Neo4j Kernel"), VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)Version.getNeo4jVersion())}), Values.stringValue((String)"community")}});
        }
        this.commit();
    }

    @Test
    void awaitIndexes() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int labelId2 = transaction.tokenWrite().labelGetOrCreateForName("Age");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int propertyKeyId2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("bar");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor ageFooDescriptor = SchemaDescriptors.forLabel((int)labelId2, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor personFooBarDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1, propertyKeyId2});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)ageFooDescriptor).withName("constraint name"));
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooBarDescriptor).withName("person foo bar index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.awaitIndexes(10)").hasNext());
        }
    }

    @Test
    void awaitIndex() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.awaitIndex('person foo index',10)").hasNext());
        }
    }

    @Test
    void resampleIndex() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.resampleIndex('person foo index')").hasNext());
        }
    }

    @Test
    void resampleOutdatedIndexes() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.resampleOutdatedIndexes").hasNext());
        }
    }

    @Test
    void awaitEventuallyConsistentIndexRefresh() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh").hasNext());
        }
    }

    @Test
    void queryNodes() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.index.fulltext.queryNodes('businessNameIndex', 'pizza')").hasNext());
        }
    }

    @Test
    void queryRelationships() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.index.fulltext.queryRelationships('businessNameIndex', 'pizza')").hasNext());
        }
    }

    @Test
    void nodeTypeProperties() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        long nodeId = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().nodeCreate();
        int propId = transaction.tokenWrite().propertyKeyGetOrCreateForName("greeting");
        transaction.dataWrite().nodeSetProperty(nodeId, propId, (Value)Values.stringValue((String)"Hi!"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.schema.nodeTypeProperties").hasNext());
        }
    }

    @Test
    void relTypeProperties() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int type = transaction.tokenWrite().relationshipTypeGetOrCreateForName("REL");
        int propId = transaction.tokenWrite().propertyKeyGetOrCreateForName("greeting");
        long nodeId = transaction.dataWrite().nodeCreate();
        long relId = transaction.dataWrite().relationshipCreate(nodeId, type, nodeId);
        transaction.dataWrite().relationshipCreate(nodeId, type, nodeId);
        transaction.dataWrite().relationshipSetProperty(relId, propId, (Value)Values.stringValue((String)"Hi!"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.schema.relTypeProperties").hasNext());
        }
    }

    @Test
    void schemaVisualization() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int type = transaction.tokenWrite().relationshipTypeGetOrCreateForName("REL");
        int propId = transaction.tokenWrite().propertyKeyGetOrCreateForName("greeting");
        long nodeId = transaction.dataWrite().nodeCreate();
        long relId = transaction.dataWrite().relationshipCreate(nodeId, type, nodeId);
        transaction.dataWrite().relationshipCreate(nodeId, type, nodeId);
        transaction.dataWrite().relationshipSetProperty(relId, propId, (Value)Values.stringValue((String)"Hi!"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.schema.visualization").hasNext());
        }
    }

    @Test
    void stats() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.collect('QUERIES')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.clear('QUERIES')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.retrieve('TOKENS')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.retrieveAllAnonymized('myGraphToken')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.status").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.stop('QUERIES')").hasNext());
        }
        this.db.executeTransactionally("CREATE USER bar SET PASSWORD 'password' CHANGE NOT REQUIRED");
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.collect('QUERIES')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.clear('QUERIES')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.retrieve('TOKENS')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.retrieveAllAnonymized('myGraphToken')").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.status").hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.stats.stop('QUERIES')").hasNext());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void prepareForReplanningShouldHaveEmptyResult() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.execute("CALL db.prepareForReplanning").hasNext());
        }
    }

    @Test
    void checkCommunityProceduresThatAreNotAllowedOnSystem() {
        Transaction tx;
        List<String> queries = List.of("CALL db.createLabel('Foo')", "CALL db.createProperty('bar')", "CALL db.createRelationshipType('BAZ')", "CALL tx.setMetaData( { User: 'Sascha' } )");
        GraphDatabaseAPI defaultDb = this.openDatabase("neo4j");
        for (String q : queries) {
            tx = defaultDb.beginTx();
            try {
                tx.execute(q).close();
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        for (String q : queries) {
            tx = this.db.beginTx();
            try {
                RuntimeException exception = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> tx.execute(q));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)exception.getMessage().startsWith("Not a recognised system command or procedure. This Cypher command can only be executed in a user database:"), (String)("Wrong error message for '" + q + "' => " + exception.getMessage()));
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    @Test
    void failWhenCallingNonExistingProcedures() {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            org.junit.jupiter.api.Assertions.assertThrows(ProcedureException.class, () -> procs.procedureCallDbms(-1, new AnyValue[0], ProcedureCallContext.EMPTY));
        }
    }

    @Test
    void failWhenCallingNonSystemProcedures() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CALL db.createLabel('foo')");
            }
        });
    }
}

