/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
public abstract class RelationshipWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    protected static final RelationshipType TYPE = RelationshipType.withName((String)"R");
    @Inject
    private RandomSupport random;

    @Test
    void shouldCreateRelationship() throws Exception {
        long r;
        long n2;
        long n1;
        try (Transaction tx = this.graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            List relationships = Iterables.asList((Iterable)tx.getNodeById(n1).getRelationships());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            org.junit.jupiter.api.Assertions.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCreateRelationshipBetweenInTransactionNodes() throws Exception {
        long r;
        long n1;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            List relationships = Iterables.asList((Iterable)tx.getNodeById(n1).getRelationships());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            org.junit.jupiter.api.Assertions.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldRollbackRelationshipOnFailure() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = this.graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.rollback();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteRelationship() throws Exception {
        long r;
        long n1;
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            n1 = node1.getId();
            r = node1.createRelationshipTo(node2, TYPE).getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r), (String)"should delete relationship");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotDeleteRelationshipThatDoesNotExist() throws Exception {
        long relationship = 0L;
        try (KernelTransaction tx = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.rollback();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteRelationshipAddedInTransaction() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = this.graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAddPropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            relationshipId = node1.createRelationshipTo(node2, TYPE).getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldUpdatePropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship r = node1.createRelationshipTo(node2, TYPE);
            r.setProperty(propertyKey, (Object)42);
            relationshipId = r.getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldRemovePropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, TYPE);
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldRemoveNonExistingPropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, TYPE);
            relationshipId = proxy.getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldRemovePropertyFromRelationshipTwice() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, TYPE);
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.intValue((int)42));
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldUpdatePropertyToRelationshipInTransaction() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            relationshipId = node1.createRelationshipTo(node2, TYPE).getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"));
            tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"world"));
            tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.intValue((int)1337));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)1337);
        }
    }

    @Test
    void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        TextValue theValue = Values.stringValue((String)"The Value");
        try (Transaction ctx = this.graphDb.beginTx();){
            Node node1 = ctx.createNode();
            Node node2 = ctx.createNode();
            Relationship r = node1.createRelationshipTo(node2, TYPE);
            r.setProperty(propertyKey, theValue.asObject());
            relationshipId = r.getId();
            ctx.commit();
        }
        KernelTransaction tx = this.beginTransaction();
        int property = tx.token().propertyKeyGetOrCreateForName(propertyKey);
        tx.dataWrite().relationshipSetProperty(relationshipId, property, (Value)theValue);
        Assertions.assertThat((long)tx.commit()).isEqualTo(0L);
    }

    @Test
    void relationshipApplyChangesShouldAddProperty() throws Exception {
        int key;
        long relationship = this.createRelationship(TYPE);
        String keyName = "key";
        IntValue value = Values.intValue((int)123);
        try (KernelTransaction tx = this.beginTransaction();){
            key = tx.tokenWrite().propertyKeyGetOrCreateForName(keyName);
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)value));
            tx.commit();
        }
        this.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)arg_0 -> this.lambda$relationshipApplyChangesShouldAddProperty$0(relationship, key, (Value)value, arg_0)));
    }

    @Test
    void relationshipApplyChangesShouldChangeProperty() throws Exception {
        int key;
        String keyName = "key";
        TextValue changedValue = Values.stringValue((String)"value");
        long relationship = this.createRelationshipWithProperty(TYPE, keyName, 123);
        try (KernelTransaction tx = this.beginTransaction();){
            key = tx.tokenRead().propertyKey(keyName);
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)changedValue));
            tx.commit();
        }
        this.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)arg_0 -> this.lambda$relationshipApplyChangesShouldChangeProperty$1(relationship, key, (Value)changedValue, arg_0)));
    }

    @Test
    void relationshipApplyChangesShouldRemoveProperty() throws Exception {
        String keyName = "key";
        long relationship = this.createRelationshipWithProperty(TYPE, keyName, 123);
        try (KernelTransaction tx = this.beginTransaction();){
            int key = tx.tokenRead().propertyKey(keyName);
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)Values.NO_VALUE));
            tx.commit();
        }
        this.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                ktx.dataRead().singleRelationship(relationship, relationshipCursor);
                relationshipCursor.next();
                this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.empty());
            }
        }));
    }

    @Test
    void relationshipApplyChangesShouldSetAndRemoveMultipleProperties() throws Exception {
        long relationship;
        int[] keys = new int[10];
        MutableIntObjectMap initialProperties = IntObjectMaps.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();){
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = tx.tokenWrite().propertyKeyGetOrCreateForName("key" + i);
            }
            long sourceNode = tx.dataWrite().nodeCreate();
            long targetNode = tx.dataWrite().nodeCreate();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName(TYPE.name());
            relationship = tx.dataWrite().relationshipCreate(sourceNode, type, targetNode);
            for (int key2 : this.random.selection(keys, 0, keys.length, false)) {
                Value value2 = this.random.nextValue();
                initialProperties.put(key2, (Object)value2);
                tx.dataWrite().relationshipSetProperty(relationship, key2, value2);
            }
            tx.commit();
        }
        MutableIntObjectMap propertyChanges = IntObjectMaps.mutable.empty();
        for (int key3 : this.random.selection(keys, 1, keys.length, false)) {
            propertyChanges.put(key3, (Object)this.random.nextValue());
        }
        for (int key3 : this.random.selection(keys, 1, keys.length, false)) {
            propertyChanges.put(key3, (Object)Values.NO_VALUE);
        }
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)propertyChanges);
            tx.commit();
        }
        MutableIntObjectMap expectedProperties = IntObjectMaps.mutable.empty();
        expectedProperties.putAll((IntObjectMap)initialProperties);
        propertyChanges.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
            if (value == Values.NO_VALUE) {
                expectedProperties.remove(key);
            } else {
                expectedProperties.put(key, value);
            }
        });
        this.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                ktx.dataRead().singleRelationship(relationship, relationshipCursor);
                Assertions.assertThat((boolean)relationshipCursor.next()).isTrue();
                this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)expectedProperties);
            }
        }));
    }

    @Test
    void relationshipApplyChangesShouldCheckUniquenessAfterAllChanges() throws Exception {
        long rel;
        RelationshipType type = RelationshipType.withName((String)"Type");
        String key1Name = "key1";
        String key2Name = "key2";
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().constraintFor(type).assertPropertyIsUnique(key1Name).assertPropertyIsUnique(key2Name).create();
            tx.commit();
        }
        try (Transaction tx = this.graphDb.beginTx();){
            Node n1 = tx.createNode();
            Relationship r1 = n1.createRelationshipTo(n1, type);
            r1.setProperty(key1Name, (Object)"A");
            r1.setProperty(key2Name, (Object)"B");
            rel = r1.getId();
            Node n2 = tx.createNode();
            Relationship r2 = n2.createRelationshipTo(n2, type);
            r2.setProperty(key1Name, (Object)"A");
            r2.setProperty(key2Name, (Object)"C");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int key1 = tx.tokenRead().propertyKey(key1Name);
            int key2 = tx.tokenRead().propertyKey(key2Name);
            MutableIntObjectMap propertyChanges = IntObjectMaps.mutable.empty();
            propertyChanges.put(key2, (Object)Values.stringValue((String)"C"));
            propertyChanges.put(key1, (Object)Values.stringValue((String)"D"));
            tx.dataWrite().relationshipApplyChanges(rel, (IntObjectMap)propertyChanges);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try (ResourceIterator relationships = tx.findRelationships(type, MapUtil.map((Object[])new Object[]{key1Name, "D", key2Name, "C"}));){
            Assertions.assertThat((boolean)relationships.hasNext()).isTrue();
            Assertions.assertThat((long)((Relationship)relationships.next()).getId()).isEqualTo(rel);
            Assertions.assertThat((boolean)relationships.hasNext()).isFalse();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void relationshipApplyChangesShouldEnforceUniquenessCorrectly() throws Exception {
        long[] rels = new long[30];
        Object[] types = new RelationshipType[4];
        Object[] keys = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = RelationshipType.withName((String)("Type" + i));
            keys[i] = "key" + i;
        }
        try (Transaction tx = this.graphDb.beginTx();){
            for (int i = 0; i < rels.length; ++i) {
                Node node = tx.createNode();
                Relationship rel = node.createRelationshipTo(node, (RelationshipType)this.random.among(types));
                rels[i] = rel.getId();
            }
            tx.commit();
        }
        ArrayList<RelationshipType> constraintTypes = new ArrayList<RelationshipType>();
        ArrayList<String[]> constraintPropertyKeys = new ArrayList<String[]>();
        try (Transaction tx = this.graphDb.beginTx();){
            RelationshipType constraintType = (RelationshipType)this.random.among(types);
            String constraintKey = (String)this.random.among(keys);
            tx.schema().constraintFor(constraintType).assertPropertyIsUnique(constraintKey).create();
            constraintTypes.add(constraintType);
            constraintPropertyKeys.add(new String[]{constraintKey});
            constraintType = (RelationshipType)this.random.among(types);
            String[] constraintKeys = (String[])this.random.selection(keys, 2, 2, false);
            tx.schema().constraintFor(constraintType).assertPropertyIsUnique(constraintKeys[0]).assertPropertyIsUnique(constraintKeys[1]).create();
            constraintTypes.add(constraintType);
            constraintPropertyKeys.add(constraintKeys);
            tx.commit();
        }
        int[] keyIds = new int[keys.length];
        try (KernelTransaction tx = this.beginTransaction();){
            for (int i = 0; i < keys.length; ++i) {
                keyIds[i] = tx.tokenWrite().propertyKeyGetOrCreateForName((String)keys[i]);
            }
        }
        Race race = new Race().withEndCondition(new BooleanSupplier[]{() -> false});
        race.addContestants(1, Race.throwing(() -> {
            try (KernelTransaction tx = this.beginTransaction();){
                long rel = this.random.among(rels);
                MutableIntObjectMap properties = IntObjectMaps.mutable.empty();
                for (int key : this.random.selection(keyIds, 1, 4, false)) {
                    Value value = (double)this.random.nextFloat() < 0.2 ? Values.NO_VALUE : Values.intValue((int)this.random.nextInt(5));
                    properties.put(key, (Object)value);
                }
                tx.dataWrite().relationshipApplyChanges(rel, (IntObjectMap)properties);
                tx.commit();
            }
            catch (UniquePropertyValueValidationException uniquePropertyValueValidationException) {
                // empty catch block
            }
        }), 150);
        race.goUnchecked();
        try (Transaction tx = this.graphDb.beginTx();){
            for (int i = 0; i < constraintTypes.size(); ++i) {
                RelationshipType type = (RelationshipType)constraintTypes.get(i);
                String[] propertyKeys = (String[])constraintPropertyKeys.get(i);
                HashSet<ValueTuple> entries = new HashSet<ValueTuple>();
                try (ResourceIterator relsWithType = tx.findRelationships(type);){
                    while (relsWithType.hasNext()) {
                        Relationship rel = (Relationship)relsWithType.next();
                        Map properties = rel.getProperties(propertyKeys);
                        if (properties.size() != propertyKeys.length) continue;
                        Object[] values = new Object[propertyKeys.length];
                        for (int v = 0; v < propertyKeys.length; ++v) {
                            String key = propertyKeys[v];
                            values[v] = properties.get(key);
                        }
                        Assertions.assertThat((boolean)entries.add(ValueTuple.of((Object[])values))).isTrue();
                    }
                    continue;
                }
            }
            tx.commit();
        }
    }

    private long createRelationship(RelationshipType type) {
        try (Transaction ctx = this.graphDb.beginTx();){
            long relationship = ctx.createNode().createRelationshipTo(ctx.createNode(), type).getId();
            ctx.commit();
            long l = relationship;
            return l;
        }
    }

    private long createRelationshipWithProperty(RelationshipType type, String key, Object value) {
        try (Transaction ctx = this.graphDb.beginTx();){
            Relationship relationship = ctx.createNode().createRelationshipTo(ctx.createNode(), type);
            relationship.setProperty(key, value);
            ctx.commit();
            long l = relationship.getId();
            return l;
        }
    }

    private /* synthetic */ void lambda$relationshipApplyChangesShouldChangeProperty$1(long relationship, int key, Value changedValue, KernelTransaction ktx) throws Exception {
        try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ktx.dataRead().singleRelationship(relationship, relationshipCursor);
            relationshipCursor.next();
            this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.of(key, (Object)changedValue));
        }
    }

    private /* synthetic */ void lambda$relationshipApplyChangesShouldAddProperty$0(long relationship, int key, Value value, KernelTransaction ktx) throws Exception {
        try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ktx.dataRead().singleRelationship(relationship, relationshipCursor);
            relationshipCursor.next();
            this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.of(key, (Object)value));
        }
    }
}

