/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapEstimatorCacheConfig;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineCostCharacteristics;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.virtual.VirtualValues;

@ImpermanentDbmsExtension
class QueryExecutionLocksIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private GraphDatabaseQueryService queryService;
    @Inject
    private QueryExecutionEngine executionEngine;

    QueryExecutionLocksIT() {
    }

    @Test
    void noLocksTakenForQueryWithoutAnyIndexesUsage() throws Exception {
        String query = "MATCH (n) return count(n)";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).isEmpty();
    }

    @Test
    void takeLabelLockForQueryWithIndexUsages() throws Exception {
        String labelName = "Human";
        Label human = Label.label((String)labelName);
        String propertyKey = "name";
        this.createIndex(human, propertyKey);
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode(new Label[]{human});
            node.setProperty(propertyKey, (Object)RandomStringUtils.randomAscii((int)10));
            transaction.commit();
        }
        String query = "MATCH (n:" + labelName + ") where n." + propertyKey + " = \"Fry\" RETURN n ";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).hasSize(1);
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.LABEL, (Object)operationRecord.resourceType);
    }

    @Test
    void takeRelationshipTypeLockForQueryWithIndexUsages() throws Exception {
        RelationshipType relType = RelationshipType.withName((String)"REL");
        String propertyKey = "name";
        this.createRelationshipIndex(relType, propertyKey);
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            node1.createRelationshipTo(node2, relType).setProperty(propertyKey, (Object)"v");
            transaction.commit();
        }
        String query = "MATCH ()-[r:" + relType.name() + "]-() where r." + propertyKey + " = \"v\" RETURN r ";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).hasSize(1);
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.RELATIONSHIP_TYPE, (Object)operationRecord.resourceType);
    }

    @Test
    void takeRelationshipTypeLockForQueryWithContainsScanIndexUsages() throws Exception {
        RelationshipType relType = RelationshipType.withName((String)"REL");
        String propertyKey = "name";
        this.createRelationshipIndexWithType(relType, propertyKey, IndexType.TEXT);
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            Relationship rel = node1.createRelationshipTo(node2, relType);
            rel.setProperty(propertyKey, (Object)"v");
            transaction.commit();
        }
        String query = "MATCH ()-[r:REL]->() WHERE r.name CONTAINS 'v' RETURN r.prop";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).hasSize(1);
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.RELATIONSHIP_TYPE, (Object)operationRecord.resourceType);
    }

    @Test
    void takeRelationshipTypeLockForQueryWithEndsWithScanIndexUsages() throws Exception {
        RelationshipType relType = RelationshipType.withName((String)"REL");
        String propertyKey = "name";
        this.createRelationshipIndexWithType(relType, propertyKey, IndexType.TEXT);
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            Relationship rel = node1.createRelationshipTo(node2, relType);
            rel.setProperty(propertyKey, (Object)"v");
            transaction.commit();
        }
        String query = "MATCH ()-[r:REL]->() WHERE r.name ENDS WITH 'v' RETURN r.prop";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).hasSize(1);
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.RELATIONSHIP_TYPE, (Object)operationRecord.resourceType);
    }

    @Test
    void takeRelationshipTypeLockForQueryWithSeekIndexUsages() throws Exception {
        RelationshipType relType = RelationshipType.withName((String)"REL");
        String propertyKey = "name";
        this.createRelationshipIndex(relType, propertyKey);
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            Relationship rel = node1.createRelationshipTo(node2, relType);
            rel.setProperty(propertyKey, (Object)"v");
            transaction.commit();
        }
        String query = "MATCH ()-[r:REL]->() WHERE r.name = 'v' RETURN r.prop";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).hasSize(1);
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.RELATIONSHIP_TYPE, (Object)operationRecord.resourceType);
    }

    @Test
    void reTakeLabelLockForQueryWithIndexUsagesWhenSchemaStateWasUpdatedDuringLockOperations() throws Exception {
        String labelName = "Robot";
        Label robot = Label.label((String)labelName);
        String propertyKey = "name";
        this.createIndex(robot, propertyKey);
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode(new Label[]{robot});
            node.setProperty(propertyKey, (Object)RandomStringUtils.randomAscii((int)10));
            transaction.commit();
        }
        String query = "MATCH (n:" + labelName + ") where n." + propertyKey + " = \"Bender\" RETURN n ";
        OnceSchemaFlushListener lockOperationListener = new OnceSchemaFlushListener();
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, lockOperationListener);
        ((ListAssert)Assertions.assertThat(lockOperationRecords).as("Observed list of lock operations is: " + lockOperationRecords, new Object[0])).hasSize(3);
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.LABEL, (Object)operationRecord.resourceType);
        LockOperationRecord operationRecord1 = lockOperationRecords.get(1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord1.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord1.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.LABEL, (Object)operationRecord1.resourceType);
        LockOperationRecord operationRecord2 = lockOperationRecords.get(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord2.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord2.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceType.LABEL, (Object)operationRecord2.resourceType);
    }

    @Test
    void labelScanWithLookupIndex() throws Exception {
        String labelName = "Robot";
        Label robot = Label.label((String)labelName);
        String propertyKey = "name";
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode(new Label[]{robot});
            node.setProperty(propertyKey, (Object)RandomStringUtils.randomAscii((int)10));
            transaction.commit();
        }
        String query = "MATCH (n:" + labelName + ") RETURN n ";
        OnceSchemaFlushListener lockOperationListener = new OnceSchemaFlushListener();
        List<LookupLockOperationRecord> lookupLockOperationRecords = this.traceLookupQueryLocks(query, lockOperationListener);
        ((ListAssert)Assertions.assertThat(lookupLockOperationRecords).as("Observed list of lookup lock operations is: " + lookupLockOperationRecords, new Object[0])).hasSize(3);
        LookupLockOperationRecord operationRecord = lookupLockOperationRecords.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)EntityType.NODE, (Object)operationRecord.entityType);
        LookupLockOperationRecord operationRecord1 = lookupLockOperationRecords.get(1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord1.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord1.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)EntityType.NODE, (Object)operationRecord1.entityType);
        LookupLockOperationRecord operationRecord2 = lookupLockOperationRecords.get(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)operationRecord2.acquisition);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)operationRecord2.exclusive);
        org.junit.jupiter.api.Assertions.assertEquals((Object)EntityType.NODE, (Object)operationRecord2.entityType);
    }

    private void createIndex(Label label, String propertyKey) {
        try (Transaction transaction = this.db.beginTx();){
            transaction.schema().indexFor(label).on(propertyKey).create();
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
    }

    private void createRelationshipIndex(RelationshipType relType, String propertyKey) {
        this.createRelationshipIndexWithType(relType, propertyKey, IndexType.RANGE);
    }

    private void createRelationshipIndexWithType(RelationshipType relType, String propertyKey, IndexType indexType) {
        try (Transaction transaction = this.db.beginTx();){
            transaction.schema().indexFor(relType).on(propertyKey).withIndexType(indexType).create();
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
    }

    private List<LockOperationRecord> traceQueryLocks(String query, LockOperationListener ... listeners) throws QueryExecutionKernelException {
        try (InternalTransaction tx = this.queryService.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            TransactionalContextWrapper context = new TransactionalContextWrapper(QueryExecutionLocksIT.createTransactionContext(this.queryService, tx, query), listeners);
            this.executionEngine.executeQuery(query, VirtualValues.EMPTY_MAP, (TransactionalContext)context, false);
            ArrayList<LockOperationRecord> arrayList = new ArrayList<LockOperationRecord>(context.recordingLocks.getLockOperationRecords());
            return arrayList;
        }
    }

    private List<LookupLockOperationRecord> traceLookupQueryLocks(String query, LockOperationListener ... listeners) throws QueryExecutionKernelException {
        try (InternalTransaction tx = this.queryService.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            TransactionalContextWrapper context = new TransactionalContextWrapper(QueryExecutionLocksIT.createTransactionContext(this.queryService, tx, query), listeners);
            this.executionEngine.executeQuery(query, VirtualValues.EMPTY_MAP, (TransactionalContext)context, false);
            ArrayList<LookupLockOperationRecord> arrayList = new ArrayList<LookupLockOperationRecord>(context.recordingLocks.getLookupLockOperationRecords());
            return arrayList;
        }
    }

    private static TransactionalContext createTransactionContext(GraphDatabaseQueryService graph, InternalTransaction tx, String query) {
        TransactionalContextFactory contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)graph);
        return contextFactory.newContext(tx, query, VirtualValues.EMPTY_MAP, QueryExecutionConfiguration.DEFAULT_CONFIG);
    }

    private static class LockOperationListener
    implements EventListener {
        private LockOperationListener() {
        }

        void lockAcquired(Transaction tx, boolean exclusive, ResourceType resourceType, long ... ids) {
        }

        void lockAcquired(Transaction tx, boolean exclusive, EntityType resourceType) {
        }
    }

    private static class LockOperationRecord {
        private final boolean exclusive;
        private final boolean acquisition;
        private final ResourceType resourceType;
        private final long[] ids;

        LockOperationRecord(boolean exclusive, boolean acquisition, ResourceType resourceType, long[] ids) {
            this.exclusive = exclusive;
            this.acquisition = acquisition;
            this.resourceType = resourceType;
            this.ids = ids;
        }

        public String toString() {
            return "LockOperationRecord{exclusive=" + this.exclusive + ", acquisition=" + this.acquisition + ", resourceType=" + this.resourceType + ", ids=" + Arrays.toString(this.ids) + "}";
        }
    }

    private static class OnceSchemaFlushListener
    extends LockOperationListener {
        private boolean executed;

        private OnceSchemaFlushListener() {
        }

        @Override
        void lockAcquired(Transaction tx, boolean exclusive, ResourceType resourceType, long ... ids) {
            if (!this.executed) {
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                ktx.schemaRead().schemaStateFlush();
            }
            this.executed = true;
        }

        @Override
        void lockAcquired(Transaction tx, boolean exclusive, EntityType type) {
            if (!this.executed) {
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                ktx.schemaRead().schemaStateFlush();
            }
            this.executed = true;
        }
    }

    private static class LookupLockOperationRecord {
        private final boolean exclusive;
        private final boolean acquisition;
        private final EntityType entityType;

        LookupLockOperationRecord(boolean exclusive, boolean acquisition, EntityType entityType) {
            this.exclusive = exclusive;
            this.acquisition = acquisition;
            this.entityType = entityType;
        }

        public String toString() {
            return "LookupLockOperationRecord{exclusive=" + this.exclusive + ", acquisition=" + this.acquisition + ", entityType=" + this.entityType + "}";
        }
    }

    private static class TransactionalContextWrapper
    implements TransactionalContext {
        private final TransactionalContext delegate;
        private final List<LockOperationRecord> recordedLocks;
        private final List<LookupLockOperationRecord> recordedLookupLocks;
        private final LockOperationListener[] listeners;
        private RecordingLocks recordingLocks;

        private TransactionalContextWrapper(TransactionalContext delegate, LockOperationListener ... listeners) {
            this(delegate, new ArrayList<LockOperationRecord>(), new ArrayList<LookupLockOperationRecord>(), listeners);
        }

        private TransactionalContextWrapper(TransactionalContext delegate, List<LockOperationRecord> recordedLocks, List<LookupLockOperationRecord> recordedLookupLocks, LockOperationListener ... listeners) {
            this.delegate = delegate;
            this.recordedLocks = recordedLocks;
            this.listeners = listeners;
            this.recordedLookupLocks = recordedLookupLocks;
        }

        public ExecutingQuery executingQuery() {
            return this.delegate.executingQuery();
        }

        public KernelTransaction kernelTransaction() {
            if (this.recordingLocks == null) {
                this.recordingLocks = new RecordingLocks(this.delegate.transaction(), Arrays.asList(this.listeners), this.recordedLocks, this.recordedLookupLocks);
            }
            return new DelegatingTransaction(this.delegate.kernelTransaction(), this.recordingLocks);
        }

        public InternalTransaction transaction() {
            return this.delegate.transaction();
        }

        public boolean isTopLevelTx() {
            return this.delegate.isTopLevelTx();
        }

        public ConstituentTransactionFactory constituentTransactionFactory() {
            return this.delegate.constituentTransactionFactory();
        }

        public void close() {
            this.delegate.close();
        }

        public void commit() {
            this.delegate.commit();
        }

        public void rollback() {
            this.delegate.rollback();
        }

        public void terminate() {
            this.delegate.terminate();
        }

        public long commitAndRestartTx() {
            return this.delegate.commitAndRestartTx();
        }

        public TransactionalContext getOrBeginNewIfClosed() {
            if (this.isOpen()) {
                return this;
            }
            return new TransactionalContextWrapper(this.delegate.getOrBeginNewIfClosed(), this.recordedLocks, this.recordedLookupLocks, this.listeners);
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public GraphDatabaseQueryService graph() {
            return this.delegate.graph();
        }

        public NamedDatabaseId databaseId() {
            return this.delegate.databaseId();
        }

        public Statement statement() {
            return this.delegate.statement();
        }

        public SecurityContext securityContext() {
            return this.delegate.securityContext();
        }

        public StatisticProvider kernelStatisticProvider() {
            return this.delegate.kernelStatisticProvider();
        }

        public KernelTransaction.Revertable restrictCurrentTransaction(SecurityContext context) {
            return this.delegate.restrictCurrentTransaction(context);
        }

        public ResourceTracker resourceTracker() {
            return this.delegate.resourceTracker();
        }

        public TransactionalContext contextWithNewTransaction() {
            return new TransactionalContextWrapper(this.delegate.contextWithNewTransaction(), this.recordedLocks, this.recordedLookupLocks, this.listeners);
        }

        public ElementIdMapper elementIdMapper() {
            return this.delegate.elementIdMapper();
        }

        public QueryExecutionConfiguration queryExecutingConfiguration() {
            return QueryExecutionConfiguration.DEFAULT_CONFIG;
        }
    }

    private static class RecordingLocks
    implements Locks {
        private final Locks delegate;
        private final List<LockOperationListener> listeners;
        private final List<LockOperationRecord> lockOperationRecords;
        private final List<LookupLockOperationRecord> lookupLockOperationRecords;
        private final InternalTransaction transaction;

        private RecordingLocks(InternalTransaction transaction, List<LockOperationListener> listeners, List<LockOperationRecord> lockOperationRecords, List<LookupLockOperationRecord> lookupLockOperationRecords) {
            this.listeners = listeners;
            this.lockOperationRecords = lockOperationRecords;
            this.lookupLockOperationRecords = lookupLockOperationRecords;
            this.transaction = transaction;
            this.delegate = transaction.kernelTransaction().locks();
        }

        List<LockOperationRecord> getLockOperationRecords() {
            return this.lockOperationRecords;
        }

        List<LookupLockOperationRecord> getLookupLockOperationRecords() {
            return this.lookupLockOperationRecords;
        }

        private void record(boolean exclusive, boolean acquisition, ResourceType type, long ... ids) {
            if (acquisition) {
                for (LockOperationListener listener : this.listeners) {
                    listener.lockAcquired((Transaction)this.transaction, exclusive, type, ids);
                }
            }
            this.lockOperationRecords.add(new LockOperationRecord(exclusive, acquisition, type, ids));
        }

        private void recordLookupIndex(boolean exclusive, boolean acquisition, EntityType type) {
            if (acquisition) {
                for (LockOperationListener listener : this.listeners) {
                    listener.lockAcquired((Transaction)this.transaction, exclusive, type);
                }
            }
            this.lookupLockOperationRecords.add(new LookupLockOperationRecord(exclusive, acquisition, type));
        }

        public void acquireExclusiveNodeLock(long ... ids) {
            this.record(true, true, ResourceType.NODE, ids);
            this.delegate.acquireExclusiveNodeLock(ids);
        }

        public void acquireExclusiveRelationshipLock(long ... ids) {
            this.record(true, true, ResourceType.RELATIONSHIP, ids);
            this.delegate.acquireExclusiveRelationshipLock(ids);
        }

        public void releaseExclusiveNodeLock(long ... ids) {
            this.record(true, false, ResourceType.NODE, ids);
            this.delegate.releaseExclusiveNodeLock(ids);
        }

        public void releaseExclusiveRelationshipLock(long ... ids) {
            this.record(true, false, ResourceType.RELATIONSHIP, ids);
            this.delegate.releaseExclusiveRelationshipLock(ids);
        }

        public void acquireSharedNodeLock(long ... ids) {
            this.record(false, true, ResourceType.NODE, ids);
            this.delegate.acquireSharedNodeLock(ids);
        }

        public void acquireSharedRelationshipLock(long ... ids) {
            this.record(false, true, ResourceType.RELATIONSHIP, ids);
            this.delegate.acquireSharedRelationshipLock(ids);
        }

        public void acquireSharedLabelLock(long ... ids) {
            this.record(false, true, ResourceType.LABEL, ids);
            this.delegate.acquireSharedLabelLock(ids);
        }

        public void acquireSharedRelationshipTypeLock(long ... ids) {
            this.record(false, true, ResourceType.RELATIONSHIP_TYPE, ids);
            this.delegate.acquireSharedRelationshipTypeLock(ids);
        }

        public void releaseSharedNodeLock(long ... ids) {
            this.record(false, false, ResourceType.NODE, ids);
            this.delegate.releaseSharedNodeLock(ids);
        }

        public void releaseSharedRelationshipLock(long ... ids) {
            this.record(false, false, ResourceType.RELATIONSHIP, ids);
            this.delegate.releaseSharedRelationshipLock(ids);
        }

        public void releaseSharedLabelLock(long ... ids) {
            this.record(false, false, ResourceType.LABEL, ids);
            this.delegate.releaseSharedLabelLock(ids);
        }

        public void releaseSharedRelationshipTypeLock(long ... ids) {
            this.record(false, false, ResourceType.RELATIONSHIP_TYPE, ids);
            this.delegate.releaseSharedRelationshipTypeLock(ids);
        }

        public void acquireSharedLookupLock(EntityType entityType) {
            this.recordLookupIndex(false, true, entityType);
            this.delegate.acquireSharedLookupLock(entityType);
        }

        public void releaseSharedLookupLock(EntityType entityType) {
            this.recordLookupIndex(false, false, entityType);
            this.delegate.releaseSharedLookupLock(entityType);
        }

        public void releaseExclusiveIndexEntryLock(long ... indexEntries) {
            this.delegate.releaseExclusiveIndexEntryLock(indexEntries);
        }

        public void acquireExclusiveIndexEntryLock(long ... indexEntries) {
            this.delegate.acquireExclusiveIndexEntryLock(indexEntries);
        }

        public void releaseSharedIndexEntryLock(long ... indexEntries) {
            this.delegate.releaseSharedIndexEntryLock(indexEntries);
        }

        public void acquireSharedIndexEntryLock(long ... indexEntries) {
            this.delegate.acquireSharedIndexEntryLock(indexEntries);
        }

        public void acquireSharedSchemaLock(SchemaDescriptorSupplier schemaLike) {
            this.delegate.acquireSharedSchemaLock(schemaLike);
        }

        public void releaseSharedSchemaLock(SchemaDescriptorSupplier schemaLike) {
            this.delegate.releaseSharedSchemaLock(schemaLike);
        }
    }

    private static class DelegatingTransaction
    implements KernelTransaction {
        private final KernelTransaction internal;
        private final Locks locks;

        DelegatingTransaction(KernelTransaction internal, Locks locks) {
            this.internal = internal;
            this.locks = locks;
        }

        public long commit(KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor) throws TransactionFailureException {
            return this.internal.commit(kernelTransactionMonitor);
        }

        public void rollback() throws TransactionFailureException {
            this.internal.rollback();
        }

        public Read dataRead() {
            return this.internal.dataRead();
        }

        public Write dataWrite() throws InvalidTransactionTypeKernelException {
            return this.internal.dataWrite();
        }

        public TokenRead tokenRead() {
            return this.internal.tokenRead();
        }

        public TokenWrite tokenWrite() {
            return this.internal.tokenWrite();
        }

        public Token token() {
            return this.internal.token();
        }

        public SchemaRead schemaRead() {
            return this.internal.schemaRead();
        }

        public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
            return this.internal.schemaWrite();
        }

        public Upgrade upgrade() {
            return this.internal.upgrade();
        }

        public Locks locks() {
            return this.locks;
        }

        public CursorFactory cursors() {
            return this.internal.cursors();
        }

        public Procedures procedures() {
            return this.internal.procedures();
        }

        public ExecutionStatistics executionStatistics() {
            return this.internal.executionStatistics();
        }

        public StorageEngineCostCharacteristics storageEngineCostCharacteristics() {
            return this.internal.storageEngineCostCharacteristics();
        }

        public Statement acquireStatement() {
            return this.internal.acquireStatement();
        }

        public int aquireStatementCounter() {
            return this.internal.aquireStatementCounter();
        }

        public ResourceMonitor resourceMonitor() {
            return this.internal.resourceMonitor();
        }

        public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) throws KernelException {
            return this.internal.indexUniqueCreate(prototype);
        }

        public long closeTransaction() throws TransactionFailureException {
            return this.internal.closeTransaction();
        }

        public void close() throws TransactionFailureException {
            this.internal.close();
        }

        public boolean isOpen() {
            return this.internal.isOpen();
        }

        public boolean isCommitting() {
            return this.internal.isCommitting();
        }

        public boolean isRollingback() {
            return this.internal.isRollingback();
        }

        public boolean isClosing() {
            return this.internal.isClosing();
        }

        public SecurityContext securityContext() {
            return this.internal.securityContext();
        }

        public SecurityAuthorizationHandler securityAuthorizationHandler() {
            return this.internal.securityAuthorizationHandler();
        }

        public ClientConnectionInfo clientInfo() {
            return this.internal.clientInfo();
        }

        public AuthSubject subjectOrAnonymous() {
            return this.internal.subjectOrAnonymous();
        }

        public Optional<TerminationMark> getTerminationMark() {
            return this.internal.getTerminationMark();
        }

        public boolean isTerminated() {
            return this.internal.isTerminated();
        }

        public void markForTermination(Status reason) {
            this.internal.markForTermination(reason);
        }

        public void bindToUserTransaction(InternalTransaction internalTransaction) {
            this.internal.bindToUserTransaction(internalTransaction);
        }

        public InternalTransaction internalTransaction() {
            return this.internal.internalTransaction();
        }

        public long startTime() {
            return this.internal.startTime();
        }

        public long startTimeNanos() {
            return this.internal.startTimeNanos();
        }

        public TransactionTimeout timeout() {
            return this.internal.timeout();
        }

        public KernelTransaction.Type transactionType() {
            return this.internal.transactionType();
        }

        public long getTransactionId() {
            return this.internal.getTransactionId();
        }

        public long getTransactionSequenceNumber() {
            return this.internal.getTransactionSequenceNumber();
        }

        public long getCommitTime() {
            return this.internal.getCommitTime();
        }

        public KernelTransaction.Revertable overrideWith(SecurityContext context) {
            return this.internal.overrideWith(context);
        }

        public ClockContext clocks() {
            return this.internal.clocks();
        }

        public NodeCursor ambientNodeCursor() {
            return this.internal.ambientNodeCursor();
        }

        public RelationshipScanCursor ambientRelationshipCursor() {
            return this.internal.ambientRelationshipCursor();
        }

        public PropertyCursor ambientPropertyCursor() {
            return this.internal.ambientPropertyCursor();
        }

        public void setMetaData(Map<String, Object> metaData) {
            this.internal.setMetaData(metaData);
        }

        public Map<String, Object> getMetaData() {
            return this.internal.getMetaData();
        }

        public void setStatusDetails(String statusDetails) {
            this.internal.setStatusDetails(statusDetails);
        }

        public String statusDetails() {
            return this.internal.statusDetails();
        }

        public void retryQuery() {
            this.internal.retryQuery();
        }

        public void reportVisibilityBoundaryRefresh() {
            this.internal.reportVisibilityBoundaryRefresh();
        }

        public void assertOpen() {
            this.internal.assertOpen();
        }

        public boolean isSchemaTransaction() {
            return this.internal.isSchemaTransaction();
        }

        public CursorContext cursorContext() {
            return null;
        }

        public ExecutionContext createExecutionContext(HeapEstimatorCacheConfig heapEstimatorCacheConfig) {
            return this.internal.createExecutionContext(heapEstimatorCacheConfig);
        }

        public MemoryTracker createExecutionContextMemoryTracker(HeapEstimatorCacheConfig heapEstimatorCacheConfig) {
            return this.internal.createExecutionContextMemoryTracker(heapEstimatorCacheConfig);
        }

        public QueryContext queryContext() {
            return this.internal.queryContext();
        }

        public StoreCursors storeCursors() {
            return null;
        }

        public MemoryTracker memoryTracker() {
            return EmptyMemoryTracker.INSTANCE;
        }

        public UUID getDatabaseId() {
            return null;
        }

        public String getDatabaseName() {
            return null;
        }

        public InnerTransactionHandler getInnerTransactionHandler() {
            return this.internal.getInnerTransactionHandler();
        }
    }
}

