/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class KernelSchemaStateFlushingTest {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Kernel kernel;
    private int labelId;
    private int propId;

    KernelSchemaStateFlushingTest() {
    }

    @BeforeEach
    void setup() throws KernelException {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.tokenWrite().labelGetOrCreateForName("Label0");
            this.labelId = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.tokenWrite().propertyKeyGetOrCreateForName("prop0");
            this.propId = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            transaction.commit();
        }
    }

    @Test
    void shouldKeepSchemaStateIfSchemaIsNotModified() throws TransactionFailureException {
        String before = this.commitToSchemaState("test", "before");
        Assertions.assertEquals((Object)"before", (Object)before);
        String after = this.commitToSchemaState("test", "after");
        Assertions.assertEquals((Object)"before", (Object)after);
    }

    @Test
    void shouldInvalidateSchemaStateOnCreateIndex() throws Exception {
        this.commitToSchemaState("test", "before");
        this.awaitIndexOnline(this.createIndex(), "test");
        String after = this.commitToSchemaState("test", "after");
        Assertions.assertEquals((Object)"after", (Object)after);
    }

    @Test
    void shouldInvalidateSchemaStateOnDropIndex() throws Exception {
        IndexDescriptor ref = this.createIndex();
        this.awaitIndexOnline(ref, "test");
        this.commitToSchemaState("test", "before");
        this.dropIndex(ref);
        String after = this.commitToSchemaState("test", "after");
        Assertions.assertEquals((Object)"after", (Object)after);
    }

    @Test
    void shouldInvalidateSchemaStateOnCreateConstraint() throws Exception {
        this.commitToSchemaState("test", "before");
        this.createConstraint();
        String after = this.commitToSchemaState("test", "after");
        Assertions.assertEquals((Object)"after", (Object)after);
    }

    @Test
    void shouldInvalidateSchemaStateOnDropConstraint() throws Exception {
        ConstraintDescriptor descriptor = this.createConstraint();
        this.commitToSchemaState("test", "before");
        this.dropConstraint(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assertions.assertEquals((Object)"after", (Object)after);
    }

    private ConstraintDescriptor createConstraint() throws KernelException {
        try (KernelTransaction transaction = this.beginTransaction();){
            ConstraintDescriptor descriptor = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propId})));
            transaction.commit();
            ConstraintDescriptor constraintDescriptor = descriptor;
            return constraintDescriptor;
        }
    }

    private void dropConstraint(ConstraintDescriptor descriptor) throws KernelException {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().constraintDrop(descriptor, false);
            transaction.commit();
        }
    }

    private IndexDescriptor createIndex() throws KernelException {
        try (KernelTransaction transaction = this.beginTransaction();){
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propId});
            IndexDescriptor reference = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema));
            transaction.commit();
            IndexDescriptor indexDescriptor = reference;
            return indexDescriptor;
        }
    }

    private void dropIndex(IndexDescriptor reference) throws KernelException {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexDrop(reference);
            transaction.commit();
        }
    }

    private void awaitIndexOnline(IndexDescriptor descriptor, String keyForProbing) throws IndexNotFoundKernelException, TransactionFailureException {
        try (KernelTransaction transaction = this.beginTransaction();){
            SchemaIndexTestHelper.awaitIndexOnline((SchemaRead)transaction.schemaRead(), (IndexDescriptor)descriptor);
            transaction.commit();
        }
        this.awaitSchemaStateCleared(keyForProbing);
    }

    private void awaitSchemaStateCleared(String keyForProbing) throws TransactionFailureException {
        try (KernelTransaction transaction = this.beginTransaction();){
            while (transaction.schemaRead().schemaStateGetOrCreate((Object)keyForProbing, ignored -> null) != null) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            }
            transaction.commit();
        }
    }

    private String commitToSchemaState(String key, String value) throws TransactionFailureException {
        try (KernelTransaction transaction = this.beginTransaction();){
            String result = KernelSchemaStateFlushingTest.getOrCreateFromState(transaction, key, value);
            transaction.commit();
            String string = result;
            return string;
        }
    }

    private static String getOrCreateFromState(KernelTransaction tx, String key, String value) {
        return (String)tx.schemaRead().schemaStateGetOrCreate((Object)key, from -> value);
    }

    private KernelTransaction beginTransaction() throws TransactionFailureException {
        return this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
    }
}

