/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexTransactionStateTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipIndexTransactionStateTest
extends IndexTransactionStateTestBase {
    private static final String DEFAULT_REl_TYPE = "Rel";

    @Override
    Pair<Long, Value> entityWithProp(KernelTransaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long sourceNode = write.nodeCreate();
        long targetNode = write.nodeCreate();
        long rel = write.relationshipCreate(sourceNode, tx.tokenWrite().relationshipTypeGetOrCreateForName(DEFAULT_REl_TYPE), targetNode);
        Value val = Values.of((Object)value);
        write.relationshipSetProperty(rel, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)rel, (Object)val);
    }

    @Override
    void createIndex(IndexType indexType) {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().indexFor(RelationshipType.withName((String)DEFAULT_REl_TYPE)).on("prop").withIndexType(indexType).withName("myIndex").create();
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    void deleteEntity(KernelTransaction tx, long entity) throws Exception {
        tx.dataWrite().relationshipDelete(entity);
    }

    @Override
    boolean entityExists(KernelTransaction tx, long entity) {
        return tx.dataRead().relationshipExists(entity);
    }

    @Override
    void removeProperty(KernelTransaction tx, long entity) throws Exception {
        int propertyKey = tx.tokenRead().propertyKey("prop");
        tx.dataWrite().relationshipRemoveProperty(entity, propertyKey);
    }

    @Override
    void setProperty(KernelTransaction tx, long entity, Value value) throws Exception {
        int propertyKey = tx.tokenRead().propertyKey("prop");
        tx.dataWrite().relationshipSetProperty(entity, propertyKey, value);
    }

    @Override
    void assertEntityAndValueForSeek(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery, PropertyIndexQuery ... queries) throws Exception {
        try (RelationshipValueIndexCursor relationships = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
            IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
            tx.dataRead().relationshipIndexSeek(tx.queryContext(), indexSession, relationships, IndexQueryConstraints.unordered((boolean)needsValues), queries);
            this.assertEntityAndValue(expected, tx, needsValues, anotherValueFoundByQuery, new RelationshipCursorAdapter(relationships));
        }
    }

    @Override
    void assertEntityAndValueForScan(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery) throws Exception {
        IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
        try (RelationshipValueIndexCursor relationships = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().relationshipIndexScan(indexSession, relationships, IndexQueryConstraints.unordered((boolean)needsValues));
            this.assertEntityAndValue(expected, tx, needsValues, anotherValueFoundByQuery, new RelationshipCursorAdapter(relationships));
        }
    }

    private static class RelationshipCursorAdapter
    implements IndexTransactionStateTestBase.EntityValueIndexCursor {
        private final RelationshipValueIndexCursor relationships;

        private RelationshipCursorAdapter(RelationshipValueIndexCursor relationships) {
            this.relationships = relationships;
        }

        @Override
        public boolean next() {
            return this.relationships.next();
        }

        @Override
        public Value propertyValue(int offset) {
            return this.relationships.propertyValue(offset);
        }

        @Override
        public long entityReference() {
            return this.relationships.relationshipReference();
        }
    }
}

